/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.AbstractDSpaceObjectTest;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.core.Context;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.test.util.ReflectionTestUtils;

public class BitstreamTest
extends AbstractDSpaceObjectTest {
    private static final Logger log = LogManager.getLogger(BitstreamTest.class);
    protected BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
    private Bitstream bs;
    private AuthorizeService authorizeServiceSpy;

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            File f = new File(testProps.get("test.bitstream").toString());
            this.bs = this.bitstreamService.create(this.context, (InputStream)new FileInputStream(f));
            this.dspaceObject = this.bs;
            this.context.restoreAuthSystemState();
            this.authorizeServiceSpy = (AuthorizeService)Mockito.spy((Object)this.authorizeService);
            ReflectionTestUtils.setField((Object)this.bitstreamService, (String)"authorizeService", (Object)this.authorizeServiceSpy);
        }
        catch (IOException ex) {
            log.error("IO Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error("SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        this.bs = null;
        super.destroy();
    }

    @Test
    public void testBSFind() throws SQLException {
        UUID id = this.bs.getID();
        Bitstream found = this.bitstreamService.find(this.context, id);
        MatcherAssert.assertThat((String)"testBSFind 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testBSFind 1", (Object)found.getFormat(this.context).getMIMEType(), (Matcher)CoreMatchers.equalTo((Object)"application/octet-stream"));
        MatcherAssert.assertThat((String)"testBSFind 2", (Object)found.getName(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((String)"testBSFind 3", (Object)found.getID(), (Matcher)CoreMatchers.equalTo((Object)id));
    }

    @Test
    public void testFindAll() throws SQLException {
        List found = this.bitstreamService.findAll(this.context);
        MatcherAssert.assertThat((String)"testFindAll 0", (Object)found, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testFindAll 1", (found.size() >= 1 ? 1 : 0) != 0);
        boolean added = false;
        for (Bitstream b : found) {
            if (!b.equals((Object)this.bs)) continue;
            added = true;
        }
        Assert.assertTrue((String)"testFindAll 2", (boolean)added);
    }

    @Test
    public void testCreate() throws IOException, SQLException {
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream created = this.bitstreamService.create(this.context, (InputStream)new FileInputStream(f));
        MatcherAssert.assertThat((String)"testCreate 0", (Object)created.getFormat(this.context).getMIMEType(), (Matcher)CoreMatchers.equalTo((Object)"application/octet-stream"));
        MatcherAssert.assertThat((String)"testCreate 1", (Object)created.getName(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testRegister() throws IOException, SQLException, AuthorizeException {
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction((Context)ArgumentMatchers.any(Context.class), (DSpaceObject)ArgumentMatchers.any(Bitstream.class), ArgumentMatchers.eq((int)1));
        int assetstore = 0;
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream registered = this.bitstreamService.register(this.context, assetstore, f.getName());
        MatcherAssert.assertThat((String)"testRegister 0", (Object)registered.getFormat(this.context).getMIMEType(), (Matcher)CoreMatchers.equalTo((Object)"application/octet-stream"));
        MatcherAssert.assertThat((String)"testRegister 1", (Object)registered.getName(), (Matcher)CoreMatchers.nullValue());
    }

    @Override
    @Test
    public void testGetID() {
        Assert.assertTrue((String)"testGetID 0", (this.bs.getID() != null ? 1 : 0) != 0);
    }

    @Test
    public void testLegacyID() {
        Assert.assertTrue((String)"testGetLegacyID 0", (this.bs.getLegacyId() == null ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testGetHandle() {
        MatcherAssert.assertThat((String)"testGetHandle 0", (Object)this.bs.getHandle(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testGetSequenceID() {
        MatcherAssert.assertThat((String)"testGetSequenceID 0", (Object)this.bs.getSequenceID(), (Matcher)CoreMatchers.equalTo((Object)-1));
    }

    @Test
    public void testSetSequenceID() {
        int val = 2;
        this.bs.setSequenceID(val);
        MatcherAssert.assertThat((String)"testSetSequenceID 0", (Object)this.bs.getSequenceID(), (Matcher)CoreMatchers.equalTo((Object)val));
    }

    @Override
    @Test
    public void testGetName() {
        MatcherAssert.assertThat((String)"testGetName 0", (Object)this.bs.getName(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetName() throws SQLException {
        String name = "new name";
        this.bs.setName(this.context, name);
        MatcherAssert.assertThat((String)"testGetName 0", (Object)this.bs.getName(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testGetName 1", (Object)this.bs.getName(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
        MatcherAssert.assertThat((String)"testGetName 2", (Object)this.bs.getName(), (Matcher)CoreMatchers.equalTo((Object)name));
    }

    @Test
    public void testGetSource() {
        MatcherAssert.assertThat((String)"testGetSource 0", (Object)this.bs.getSource(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetSource() throws SQLException {
        String source = "new source";
        this.bs.setSource(this.context, source);
        MatcherAssert.assertThat((String)"testSetSource 0", (Object)this.bs.getSource(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testSetSource 1", (Object)this.bs.getSource(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
        MatcherAssert.assertThat((String)"testSetSource 2", (Object)this.bs.getSource(), (Matcher)CoreMatchers.equalTo((Object)source));
    }

    @Test
    public void testGetDescription() {
        MatcherAssert.assertThat((String)"testGetDescription 0", (Object)this.bs.getDescription(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testSetDescription() throws SQLException {
        String description = "new description";
        this.bs.setDescription(this.context, description);
        MatcherAssert.assertThat((String)"testSetDescription 0", (Object)this.bs.getDescription(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testSetDescription 1", (Object)this.bs.getDescription(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
        MatcherAssert.assertThat((String)"testSetDescription 2", (Object)this.bs.getDescription(), (Matcher)CoreMatchers.equalTo((Object)description));
    }

    @Test
    public void testGetChecksum() {
        String checksum = "75a060bf6eb63fd0aad88b7d757728d3";
        MatcherAssert.assertThat((String)"testGetChecksum 0", (Object)this.bs.getChecksum(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testGetChecksum 1", (Object)this.bs.getChecksum(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
        MatcherAssert.assertThat((String)"testGetChecksum 2", (Object)this.bs.getChecksum(), (Matcher)CoreMatchers.equalTo((Object)checksum));
    }

    @Test
    public void testGetChecksumAlgorithm() {
        String alg = "MD5";
        MatcherAssert.assertThat((String)"testGetChecksumAlgorithm 0", (Object)this.bs.getChecksumAlgorithm(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testGetChecksumAlgorithm 1", (Object)this.bs.getChecksumAlgorithm(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
        MatcherAssert.assertThat((String)"testGetChecksumAlgorithm 2", (Object)this.bs.getChecksumAlgorithm(), (Matcher)CoreMatchers.equalTo((Object)alg));
    }

    @Test
    public void testGetSize() {
        long size = 238413L;
        MatcherAssert.assertThat((String)"testGetSize 0", (Object)this.bs.getSizeBytes(), (Matcher)CoreMatchers.equalTo((Object)size));
    }

    @Test
    public void testSetUserFormatDescription() throws SQLException {
        String userdescription = "user format description";
        this.bs.setUserFormatDescription(this.context, userdescription);
        MatcherAssert.assertThat((String)"testSetUserFormatDescription 0", (Object)this.bs.getUserFormatDescription(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testSetUserFormatDescription 1", (Object)this.bs.getUserFormatDescription(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
        MatcherAssert.assertThat((String)"testSetUserFormatDescription 2", (Object)this.bs.getUserFormatDescription(), (Matcher)CoreMatchers.equalTo((Object)userdescription));
    }

    @Test
    public void testGetUserFormatDescription() {
        MatcherAssert.assertThat((String)"testGetUserFormatDescription 0", (Object)this.bs.getUserFormatDescription(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testGetFormatDescription() throws SQLException {
        String format = "Unknown";
        MatcherAssert.assertThat((String)"testGetFormatDescription 0", (Object)this.bs.getFormatDescription(this.context), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testGetFormatDescription 1", (Object)this.bs.getFormatDescription(this.context), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)"")));
        MatcherAssert.assertThat((String)"testGetFormatDescription 2", (Object)this.bs.getFormatDescription(this.context), (Matcher)CoreMatchers.equalTo((Object)format));
    }

    @Test
    public void testGetFormat() throws SQLException {
        MatcherAssert.assertThat((String)"testGetFormat 0", (Object)this.bs.getFormat(this.context), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testGetFormat 1", (Object)this.bs.getFormat(this.context), (Matcher)CoreMatchers.equalTo((Object)this.bitstreamFormatService.findUnknown(this.context)));
    }

    @Test
    public void testSetFormat() throws SQLException {
        int id = 3;
        BitstreamFormat format = (BitstreamFormat)this.bitstreamFormatService.find(this.context, id);
        this.bs.setFormat(format);
        MatcherAssert.assertThat((String)"testSetFormat 0", (Object)this.bs.getFormat(this.context), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((String)"testSetFormat 1", (Object)this.bs.getFormat(this.context), (Matcher)CoreMatchers.equalTo((Object)((BitstreamFormat)this.bitstreamFormatService.find(this.context, id))));
    }

    @Test(expected=AuthorizeException.class)
    public void testUpdateNotAdmin() throws SQLException, AuthorizeException {
        ((AuthorizeService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizeException()}).when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.bs, 1);
        this.bitstreamService.update(this.context, (DSpaceObject)this.bs);
    }

    @Test
    public void testUpdateAdmin() throws SQLException, AuthorizeException {
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.bs, 1);
        this.bitstreamService.update(this.context, (DSpaceObject)this.bs);
    }

    @Test
    public void testDeleteAndExpunge() throws IOException, SQLException, AuthorizeException {
        this.context.ignoreAuthorization();
        File f = new File(testProps.get("test.bitstream").toString());
        Bitstream delBS = this.bitstreamService.create(this.context, (InputStream)new FileInputStream(f));
        UUID bitstreamId = delBS.getID();
        this.context.restoreAuthSystemState();
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)delBS, 1);
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)delBS, 2);
        Assert.assertFalse((String)"testIsDeleted 0", (boolean)delBS.isDeleted());
        this.bitstreamService.delete(this.context, (DSpaceObject)delBS);
        Assert.assertTrue((String)"testDelete 0", (boolean)delBS.isDeleted());
        this.bitstreamService.expunge(this.context, delBS);
        MatcherAssert.assertThat((String)"testExpunge 0", (Object)this.bitstreamService.find(this.context, bitstreamId), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testRetrieveCanRead() throws IOException, SQLException, AuthorizeException {
        ((AuthorizeService)Mockito.doNothing().when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.bs, 0);
        MatcherAssert.assertThat((String)"testRetrieveCanRead 0", (Object)this.bitstreamService.retrieve(this.context, this.bs), (Matcher)CoreMatchers.notNullValue());
    }

    @Test(expected=AuthorizeException.class)
    public void testRetrieveNoRead() throws IOException, SQLException, AuthorizeException {
        ((AuthorizeService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizeException()}).when((Object)this.authorizeServiceSpy)).authorizeAction(this.context, (DSpaceObject)this.bs, 0);
        MatcherAssert.assertThat((String)"testRetrieveNoRead 0", (Object)this.bitstreamService.retrieve(this.context, this.bs), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testGetBundles() throws SQLException {
        MatcherAssert.assertThat((String)"testGetBundles 0", (Object)this.bs.getBundles(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((String)"testGetBundles 1", (this.bs.getBundles().size() == 0 ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testGetType() {
        MatcherAssert.assertThat((String)"testGetType 0", (Object)this.bs.getType(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testIsRegisteredBitstream() {
        MatcherAssert.assertThat((String)"testIsRegisteredBitstream 0", (Object)this.bitstreamService.isRegisteredBitstream(this.bs), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void testGetStoreNumber() {
        Assert.assertTrue((String)"testGetStoreNumber 0", (this.bs.getStoreNumber() == 0 ? 1 : 0) != 0);
    }

    @Override
    @Test
    public void testGetParentObject() throws SQLException {
        MatcherAssert.assertThat((String)"testGetParentObject 0", (Object)this.bitstreamService.getParentObject(this.context, (DSpaceObject)this.bs), (Matcher)CoreMatchers.nullValue());
    }
}

