/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.dspace.AbstractIntegrationTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataValue;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.content.service.MetadataValueService;
import org.dspace.content.service.WorkspaceItemService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ITMetadata
extends AbstractIntegrationTest {
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected MetadataSchemaService metadataSchemaService = ContentServiceFactory.getInstance().getMetadataSchemaService();
    protected MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();
    protected MetadataValueService metadataValueService = ContentServiceFactory.getInstance().getMetadataValueService();

    @Override
    @Before
    public void init() {
        super.init();
    }

    @Override
    @After
    public void destroy() {
        super.destroy();
    }

    @Test
    public void testCreateSchema() throws SQLException, AuthorizeException, NonUniqueMetadataException, IOException {
        String schemaName = "integration";
        this.context.turnOffAuthorisationSystem();
        Community owningCommunity = this.communityService.create(null, this.context);
        Collection collection = this.collectionService.create(this.context, owningCommunity);
        Item it = this.workspaceItemService.create(this.context, collection, false).getItem();
        MetadataSchema schema = this.metadataSchemaService.create(this.context, schemaName, "htpp://test/schema/");
        MetadataField field1 = this.metadataFieldService.create(this.context, schema, "elem1", "qual1", "note 1");
        MetadataField field2 = this.metadataFieldService.create(this.context, schema, "elem2", "qual2", "note 2");
        MetadataValue value1 = this.metadataValueService.create(this.context, (DSpaceObject)it, field1);
        value1.setValue("value1");
        this.metadataValueService.update(this.context, value1);
        MetadataValue value2 = this.metadataValueService.create(this.context, (DSpaceObject)it, field2);
        value2.setValue("value2");
        this.metadataValueService.update(this.context, value2);
        MatcherAssert.assertThat((String)"testCreateSchema 0", (Object)schema.getName(), (Matcher)CoreMatchers.equalTo((Object)schemaName));
        MatcherAssert.assertThat((String)"testCreateSchema 1", (Object)field1.getMetadataSchema(), (Matcher)CoreMatchers.equalTo((Object)schema));
        MatcherAssert.assertThat((String)"testCreateSchema 2", (Object)field2.getMetadataSchema(), (Matcher)CoreMatchers.equalTo((Object)schema));
        List fields = this.metadataFieldService.findAllInSchema(this.context, schema);
        Assert.assertTrue((String)"testCreateSchema 3", (fields.size() == 2 ? 1 : 0) != 0);
        boolean exist = true;
        for (MetadataField f : fields) {
            if (f.equals((Object)field1) || f.equals((Object)field2)) continue;
            exist = false;
        }
        Assert.assertTrue((String)"testCreateSchema 4", (boolean)exist);
        List col1 = this.metadataValueService.findByField(this.context, field1);
        Assert.assertTrue((String)"testCreateSchema 5", (boolean)col1.contains(value1));
        List col2 = this.metadataValueService.findByField(this.context, field2);
        Assert.assertTrue((String)"testCreateSchema 6", (boolean)col2.contains(value2));
        it.removeMetadata(value1);
        col1 = this.metadataValueService.findByField(this.context, field1);
        Assert.assertFalse((String)"testCreateSchema 7", (boolean)col1.contains(value1));
        it.removeMetadata(value2);
        this.metadataFieldService.delete(this.context, field1);
        this.metadataFieldService.delete(this.context, field2);
        this.metadataSchemaService.delete(this.context, schema);
        this.communityService.delete(this.context, (DSpaceObject)owningCommunity);
        this.context.restoreAuthSystemState();
    }
}

