/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.virtual;

import java.util.ArrayList;
import java.util.UUID;
import junit.framework.TestCase;
import org.dspace.content.Entity;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.service.EntityService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.virtual.Related;
import org.dspace.content.virtual.VirtualMetadataConfiguration;
import org.dspace.core.Context;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RelatedTest {
    @InjectMocks
    private Related related;
    @Mock
    private RelationshipService relationshipService;
    @Mock
    private EntityService entityService;
    @Mock
    private VirtualMetadataConfiguration virtualMetadataConfiguration;
    @Mock
    private Context context;

    @Test
    public void testGetRelationshipTypeString() {
        this.related.setRelationshipTypeString("TestType");
        Assert.assertEquals((String)"TestGetRelationshipTypeString 0", (Object)"TestType", (Object)this.related.getRelationshipTypeString());
    }

    @Test
    public void testSetRelationshipTypeString() {
        this.related.setRelationshipTypeString("TestType");
        Assert.assertEquals((String)"TestSetRelationshipTypeString 0", (Object)"TestType", (Object)this.related.getRelationshipTypeString());
    }

    @Test
    public void testSetPlace() {
        this.related.setPlace(Integer.valueOf(0));
        TestCase.assertTrue((String)"TestSetPlace 0", (0 == this.related.getPlace() ? 1 : 0) != 0);
    }

    @Test
    public void testGetPlace() {
        this.related.setPlace(Integer.valueOf(0));
        TestCase.assertTrue((String)"TestGetPlace 0", (0 == this.related.getPlace() ? 1 : 0) != 0);
    }

    @Test
    public void testGetVirtualMetadataConfiguration() {
        Assert.assertEquals((String)"TestGetVirtualMetadataConfiguration 0", this.virtualMetadataConfiguration.getClass(), this.related.getVirtualMetadataConfiguration().getClass());
    }

    @Test
    public void testSetVirtualMetadataConfiguration() {
        this.related.setVirtualMetadataConfiguration(this.virtualMetadataConfiguration);
        Assert.assertEquals((String)"TestGetVirtualMetadataConfiguration 0", (Object)this.virtualMetadataConfiguration, (Object)this.related.getVirtualMetadataConfiguration());
    }

    @Test
    public void testSetUseForPlace() {
        this.related.setUseForPlace(true);
        Assert.assertEquals((String)"TestSetVirtualMetadataConfiguration 0", (Object)true, (Object)this.related.getUseForPlace());
    }

    @Test
    public void testGetUseForPlace() {
        this.related.setUseForPlace(true);
        Assert.assertEquals((String)"TestSetVirtualMetadataConfiguration 0", (Object)true, (Object)this.related.getUseForPlace());
    }

    @Test
    public void testGetValues() throws Exception {
        ArrayList<RelationshipType> relationshipTypeList = new ArrayList<RelationshipType>();
        ArrayList<Relationship> relationshipList = new ArrayList<Relationship>();
        Relationship relationship = (Relationship)Mockito.mock(Relationship.class);
        Item item = (Item)Mockito.mock(Item.class);
        Entity entity = (Entity)Mockito.mock(Entity.class);
        EntityType entityType = (EntityType)Mockito.mock(EntityType.class);
        RelationshipType relationshipType = (RelationshipType)Mockito.mock(RelationshipType.class);
        this.related.setRelationshipTypeString("LeftwardType");
        relationshipTypeList.add(relationshipType);
        relationshipList.add(relationship);
        this.related.setPlace(Integer.valueOf(0));
        Mockito.when((Object)item.getID()).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)relationshipType.getLeftwardType()).thenReturn((Object)"LeftwardType");
        Mockito.when((Object)relationshipType.getLeftType()).thenReturn((Object)entityType);
        Mockito.when((Object)this.entityService.getAllRelationshipTypes(this.context, entity)).thenReturn(relationshipTypeList);
        Mockito.when((Object)this.entityService.findByItemId(this.context, item.getID())).thenReturn((Object)entity);
        Mockito.when((Object)this.entityService.getType(this.context, entity)).thenReturn((Object)entityType);
        Mockito.when((Object)this.relationshipService.findByItemAndRelationshipType(this.context, item, relationshipType)).thenReturn(relationshipList);
        Mockito.when((Object)relationship.getRelationshipType()).thenReturn((Object)relationshipType);
        Mockito.when((Object)relationship.getLeftPlace()).thenReturn((Object)0);
        Mockito.when((Object)relationship.getRightItem()).thenReturn((Object)item);
        Assert.assertEquals((String)"TestGetValues 0", (Object)this.virtualMetadataConfiguration.getValues(this.context, item), (Object)this.related.getValues(this.context, item));
        this.related.setPlace(Integer.valueOf(1));
        Assert.assertEquals((String)"TestGetValues 1", (Object)this.virtualMetadataConfiguration.getValues(this.context, item), (Object)this.related.getValues(this.context, item));
        this.related.setPlace(Integer.valueOf(2));
        Assert.assertEquals((String)"TestGetValues 2", new ArrayList(), (Object)this.related.getValues(this.context, item));
    }
}

