/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.ClaimedTaskBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.PoolTaskBuilder;
import org.dspace.builder.WorkflowItemBuilder;
import org.dspace.builder.WorkspaceItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.authority.factory.ContentAuthorityServiceFactory;
import org.dspace.content.authority.service.MetadataAuthorityService;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.ReloadableEntity;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.IndexingService;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.indexobject.IndexableClaimedTask;
import org.dspace.discovery.indexobject.IndexableCollection;
import org.dspace.discovery.indexobject.IndexableItem;
import org.dspace.discovery.indexobject.IndexablePoolTask;
import org.dspace.discovery.indexobject.IndexableWorkflowItem;
import org.dspace.discovery.indexobject.IndexableWorkspaceItem;
import org.dspace.eperson.EPerson;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.workflow.WorkflowException;
import org.dspace.workflow.WorkflowItem;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.service.WorkflowRequirementsService;
import org.dspace.xmlworkflow.service.XmlWorkflowService;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.Workflow;
import org.dspace.xmlworkflow.state.actions.WorkflowActionConfig;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.dspace.xmlworkflow.storedcomponents.PoolTask;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.dspace.xmlworkflow.storedcomponents.service.ClaimedTaskService;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public class DiscoveryIT
extends AbstractIntegrationTestWithDatabase {
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected SearchService searchService = SearchUtils.getSearchService();
    XmlWorkflowService workflowService = XmlWorkflowServiceFactory.getInstance().getXmlWorkflowService();
    WorkflowRequirementsService workflowRequirementsService = XmlWorkflowServiceFactory.getInstance().getWorkflowRequirementsService();
    ClaimedTaskService claimedTaskService = XmlWorkflowServiceFactory.getInstance().getClaimedTaskService();
    CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    IndexingService indexer = (IndexingService)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(IndexingService.class.getName(), IndexingService.class);
    ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    MetadataAuthorityService metadataAuthorityService = ContentAuthorityServiceFactory.getInstance().getMetadataAuthorityService();

    @Test
    public void solrRecordsAfterDepositOrDeletionOfWorkspaceItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection(this.context, community).withName("Collection without workflow").build();
        Collection colWithWorkflow = CollectionBuilder.createCollection(this.context, community).withName("Collection WITH workflow").withWorkflowGroup(1, this.admin).build();
        WorkspaceItem workspaceItem = WorkspaceItemBuilder.createWorkspaceItem(this.context, col).withTitle("No workflow").withAbstract("headache").build();
        WorkspaceItem anotherWorkspaceItem = WorkspaceItemBuilder.createWorkspaceItem(this.context, col).withTitle("Another WS Item in No workflow collection").withAbstract("headache").build();
        WorkspaceItem workspaceItemInWfCollection = WorkspaceItemBuilder.createWorkspaceItem(this.context, colWithWorkflow).withTitle("WS Item in workflow collection").withAbstract("headache").build();
        this.context.restoreAuthSystemState();
        this.assertSearchQuery(IndexableWorkspaceItem.TYPE, 3);
        this.deposit(workspaceItem);
        this.assertSearchQuery(IndexableWorkflowItem.TYPE, 0);
        this.assertSearchQuery(IndexablePoolTask.TYPE, 0);
        this.assertSearchQuery(IndexableClaimedTask.TYPE, 0);
        this.assertSearchQuery(IndexableWorkspaceItem.TYPE, 2);
        this.assertSearchQuery(IndexableItem.TYPE, 1);
        this.deposit(workspaceItemInWfCollection);
        this.assertSearchQuery(IndexableWorkflowItem.TYPE, 1);
        this.assertSearchQuery(IndexablePoolTask.TYPE, 1);
        this.assertSearchQuery(IndexableClaimedTask.TYPE, 0);
        this.assertSearchQuery(IndexableWorkspaceItem.TYPE, 1);
        this.assertSearchQuery(IndexableItem.TYPE, 1);
        this.deleteSubmission(anotherWorkspaceItem);
        this.assertSearchQuery(IndexableWorkflowItem.TYPE, 1);
        this.assertSearchQuery(IndexablePoolTask.TYPE, 1);
        this.assertSearchQuery(IndexableClaimedTask.TYPE, 0);
        this.assertSearchQuery(IndexableWorkspaceItem.TYPE, 0);
        this.assertSearchQuery(IndexableItem.TYPE, 1);
    }

    @Test
    public void solrRecordsAfterDealingWithWorkflowTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).withWorkflowGroup(1, this.admin).build();
        Workflow workflow = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory().getWorkflow(collection);
        ClaimedTask taskToApprove = ClaimedTaskBuilder.createClaimedTask(this.context, collection, this.admin).withTitle("Test workflow item to approve").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        ClaimedTask taskToReject = ClaimedTaskBuilder.createClaimedTask(this.context, collection, this.admin).withTitle("Test workflow item to reject").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        PoolTask taskToClaim = PoolTaskBuilder.createPoolTask(this.context, collection, this.admin).withTitle("Test pool task to claim").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        ClaimedTask taskToUnclaim = ClaimedTaskBuilder.createClaimedTask(this.context, collection, this.admin).withTitle("Test claimed task to unclaim").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        XmlWorkflowItem wfiToDelete = WorkflowItemBuilder.createWorkflowItem(this.context, collection).withTitle("Test workflow item to return").withIssueDate("2019-03-06").withSubject("ExtraEntry").build();
        this.context.restoreAuthSystemState();
        this.assertSearchQuery(IndexableWorkflowItem.TYPE, 5);
        this.assertSearchQuery(IndexableClaimedTask.TYPE, 3);
        this.assertSearchQuery(IndexablePoolTask.TYPE, 2);
        this.assertSearchQuery(IndexableWorkspaceItem.TYPE, 0);
        this.assertSearchQuery(IndexableItem.TYPE, 0);
        this.claim(workflow, taskToClaim, this.admin);
        this.assertSearchQuery(IndexableWorkflowItem.TYPE, 5);
        this.assertSearchQuery(IndexableClaimedTask.TYPE, 4);
        this.assertSearchQuery(IndexablePoolTask.TYPE, 1);
        this.assertSearchQuery(IndexableWorkspaceItem.TYPE, 0);
        this.assertSearchQuery(IndexableItem.TYPE, 0);
        this.returnClaimedTask(taskToUnclaim);
        this.assertSearchQuery(IndexableWorkflowItem.TYPE, 5);
        this.assertSearchQuery(IndexableClaimedTask.TYPE, 3);
        this.assertSearchQuery(IndexablePoolTask.TYPE, 2);
        this.assertSearchQuery(IndexableWorkspaceItem.TYPE, 0);
        this.assertSearchQuery(IndexableItem.TYPE, 0);
        MockHttpServletRequest httpRejectRequest = new MockHttpServletRequest();
        httpRejectRequest.setParameter("submit_reject", "submit_reject");
        httpRejectRequest.setParameter("reason", "test");
        this.executeWorkflowAction((HttpServletRequest)httpRejectRequest, workflow, taskToReject);
        this.assertSearchQuery(IndexableWorkflowItem.TYPE, 4);
        this.assertSearchQuery(IndexableClaimedTask.TYPE, 2);
        this.assertSearchQuery(IndexablePoolTask.TYPE, 2);
        this.assertSearchQuery(IndexableWorkspaceItem.TYPE, 1);
        this.assertSearchQuery(IndexableItem.TYPE, 0);
        MockHttpServletRequest httpApproveRequest = new MockHttpServletRequest();
        httpApproveRequest.setParameter("submit_approve", "submit_approve");
        this.executeWorkflowAction((HttpServletRequest)httpApproveRequest, workflow, taskToApprove);
        this.assertSearchQuery(IndexableWorkflowItem.TYPE, 3);
        this.assertSearchQuery(IndexableClaimedTask.TYPE, 1);
        this.assertSearchQuery(IndexablePoolTask.TYPE, 2);
        this.assertSearchQuery(IndexableWorkspaceItem.TYPE, 1);
        this.assertSearchQuery(IndexableItem.TYPE, 1);
        this.abort(taskToUnclaim.getWorkflowItem());
        this.assertSearchQuery(IndexableWorkflowItem.TYPE, 2);
        this.assertSearchQuery(IndexableClaimedTask.TYPE, 1);
        this.assertSearchQuery(IndexablePoolTask.TYPE, 1);
        this.assertSearchQuery(IndexableWorkspaceItem.TYPE, 2);
        this.assertSearchQuery(IndexableItem.TYPE, 1);
        this.abort(taskToClaim.getWorkflowItem());
        this.assertSearchQuery(IndexableWorkflowItem.TYPE, 1);
        this.assertSearchQuery(IndexableClaimedTask.TYPE, 0);
        this.assertSearchQuery(IndexablePoolTask.TYPE, 1);
        this.assertSearchQuery(IndexableWorkspaceItem.TYPE, 3);
        this.assertSearchQuery(IndexableItem.TYPE, 1);
        this.deleteWorkflowItem(wfiToDelete);
        this.assertSearchQuery(IndexableWorkflowItem.TYPE, 0);
        this.assertSearchQuery(IndexableClaimedTask.TYPE, 0);
        this.assertSearchQuery(IndexablePoolTask.TYPE, 0);
        this.assertSearchQuery(IndexableWorkspaceItem.TYPE, 3);
        this.assertSearchQuery(IndexableItem.TYPE, 1);
    }

    @Test
    public void solrRecordAfterDeleteTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        Collection col = CollectionBuilder.createCollection(this.context, community).withName("Collection").build();
        Item item1 = ItemBuilder.createItem(this.context, col).withTitle("Publication 1").build();
        Item item2 = ItemBuilder.createItem(this.context, col).withTitle("Publication 2").build();
        this.context.restoreAuthSystemState();
        this.assertSearchQuery(IndexableItem.TYPE, 2);
        this.deleteItem(item2);
        this.assertSearchQuery(IndexableItem.TYPE, 1);
        this.deleteItem(item1);
        this.assertSearchQuery(IndexableItem.TYPE, 0);
    }

    @Test
    public void solrRecordFromMessyItemTest() throws Exception {
        this.configurationService.setProperty("authority.controlled.dc.subject", (Object)"true");
        this.metadataAuthorityService.clearCache();
        try {
            this.context.turnOffAuthorisationSystem();
            this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
            Collection col1 = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("Collection 1").build();
            this.context.restoreAuthSystemState();
            this.assertSearchQuery(IndexableItem.TYPE, 0);
            this.context.turnOffAuthorisationSystem();
            ItemBuilder.createItem(this.context, col1).withTitle("Public item 1").withIssueDate("2021-01-21").withAuthor("Smith, Donald").withSubject("Test Value", "NOT-EXISTING", 600).build();
            this.context.restoreAuthSystemState();
            this.assertSearchQuery(IndexableItem.TYPE, 1);
        }
        finally {
            this.configurationService.setProperty("authority.controlled.dc.subject", (Object)"false");
            this.metadataAuthorityService.clearCache();
        }
    }

    @Test
    public void verifySolrRecordsOfDeletedObjectsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity(this.context, this.parentCommunity).withName("Sub Community 2").build();
        Community child2 = CommunityBuilder.createSubCommunity(this.context, this.parentCommunity).withName("Sub Community 2").build();
        Collection col1 = CollectionBuilder.createCollection(this.context, child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection(this.context, child1).withName("Collection 2").build();
        CollectionBuilder.createCollection(this.context, child2).withName("Collection 3").build();
        ItemBuilder.createItem(this.context, col1).withTitle("Public item 1").withIssueDate("2017-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        ItemBuilder.createItem(this.context, col2).withTitle("Public item 2").withIssueDate("2016-02-13").withAuthor("Smith, Maria").withSubject("TestingForMore").build();
        ItemBuilder.createItem(this.context, col2).withTitle("Public item 3").withIssueDate("2016-02-13").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("ExtraEntry").build();
        this.context.setDispatcher("noindex");
        this.assertSearchQuery(IndexableCollection.TYPE, 3);
        this.assertSearchQuery(IndexableItem.TYPE, 3);
        this.collectionService.delete(this.context, (DSpaceObject)col1);
        this.context.restoreAuthSystemState();
        this.assertSearchQuery(IndexableCollection.TYPE, 2);
        this.assertSearchQuery(IndexableItem.TYPE, 2);
    }

    @Test
    public void verifySolrRecordsOfDeletedObjectsPaginationTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity(this.context, this.parentCommunity).withName("Sub Community 2").build();
        Community child2 = CommunityBuilder.createSubCommunity(this.context, this.parentCommunity).withName("Sub Community 2").build();
        Collection col1 = CollectionBuilder.createCollection(this.context, child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection(this.context, child1).withName("Collection 2").build();
        Collection col3 = CollectionBuilder.createCollection(this.context, child2).withName("Collection 3").build();
        ItemBuilder.createItem(this.context, col1).withTitle("Public item 1").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        ItemBuilder.createItem(this.context, col2).withTitle("Public item 2").withIssueDate("2011-08-13").withAuthor("Smith, Maria").withSubject("TestingForMore").build();
        ItemBuilder.createItem(this.context, col2).withTitle("Public item 3").withIssueDate("2012-02-19").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("ExtraEntry").build();
        ItemBuilder.createItem(this.context, col3).withTitle("Public item 4").withIssueDate("2013-05-16").withAuthor("Vova, Jane").withSubject("ExtraEntry").build();
        ItemBuilder.createItem(this.context, col3).withTitle("Public item 5").withIssueDate("2015-04-13").withAuthor("Marco, Bruni").withSubject("ExtraEntry").build();
        ItemBuilder.createItem(this.context, col3).withTitle("Public item 6").withIssueDate("2016-01-21").withAuthor("Andriy, Beket").withSubject("ExtraEntry").build();
        this.context.setDispatcher("noindex");
        this.assertSearchQuery(IndexableCollection.TYPE, 3, 3, 0, -1);
        this.assertSearchQuery(IndexableItem.TYPE, 6, 6, 0, -1);
        this.collectionService.delete(this.context, (DSpaceObject)col3);
        this.context.restoreAuthSystemState();
        this.assertSearchQuery(IndexableCollection.TYPE, 2, 2, 0, -1);
        this.assertSearchQuery(IndexableItem.TYPE, 2, 6, 0, 2);
        this.assertSearchQuery(IndexableItem.TYPE, 1, 3, 2, 4);
        this.assertSearchQuery(IndexableItem.TYPE, 3, 3, 0, -1);
    }

    @Test
    public void disabledSolrToRemoveStaleObjectsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.configurationService.setProperty("discovery.removestale.attempts", (Object)-1);
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity(this.context, this.parentCommunity).withName("Sub Community 2").build();
        Community child2 = CommunityBuilder.createSubCommunity(this.context, this.parentCommunity).withName("Sub Community 2").build();
        Collection col1 = CollectionBuilder.createCollection(this.context, child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection(this.context, child1).withName("Collection 2").build();
        Collection col3 = CollectionBuilder.createCollection(this.context, child2).withName("Collection 3").build();
        ItemBuilder.createItem(this.context, col1).withTitle("Public item 1").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        ItemBuilder.createItem(this.context, col2).withTitle("Public item 2").withIssueDate("2011-08-13").withAuthor("Smith, Maria").withSubject("TestingForMore").build();
        ItemBuilder.createItem(this.context, col2).withTitle("Public item 3").withIssueDate("2012-02-19").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("ExtraEntry").build();
        ItemBuilder.createItem(this.context, col3).withTitle("Public item 4").withIssueDate("2013-05-16").withAuthor("Vova, Jane").withSubject("ExtraEntry").build();
        ItemBuilder.createItem(this.context, col3).withTitle("Public item 5").withIssueDate("2015-04-13").withAuthor("Marco, Bruni").withSubject("ExtraEntry").build();
        ItemBuilder.createItem(this.context, col3).withTitle("Public item 6").withIssueDate("2016-01-21").withAuthor("Andriy, Beket").withSubject("ExtraEntry").build();
        this.context.setDispatcher("noindex");
        this.assertSearchQuery(IndexableCollection.TYPE, 3, 3, 0, -1);
        this.assertSearchQuery(IndexableItem.TYPE, 6, 6, 0, -1);
        this.collectionService.delete(this.context, (DSpaceObject)col3);
        this.context.restoreAuthSystemState();
        this.assertSearchQuery(IndexableCollection.TYPE, 2, 3, 0, -1);
        this.assertSearchQuery(IndexableItem.TYPE, 2, 6, 0, 2);
        this.assertSearchQuery(IndexableItem.TYPE, 1, 6, 2, 4);
        this.assertSearchQuery(IndexableItem.TYPE, 3, 6, 0, -1);
    }

    @Test
    public void disabledRerunOfSolrQueryDueToStaleObjectsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.configurationService.setProperty("discovery.removestale.attempts", (Object)0);
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        Community child1 = CommunityBuilder.createSubCommunity(this.context, this.parentCommunity).withName("Sub Community 2").build();
        Community child2 = CommunityBuilder.createSubCommunity(this.context, this.parentCommunity).withName("Sub Community 2").build();
        Collection col1 = CollectionBuilder.createCollection(this.context, child1).withName("Collection 1").build();
        Collection col2 = CollectionBuilder.createCollection(this.context, child1).withName("Collection 2").build();
        Collection col3 = CollectionBuilder.createCollection(this.context, child2).withName("Collection 3").build();
        ItemBuilder.createItem(this.context, col1).withTitle("Public item 1").withIssueDate("2010-10-17").withAuthor("Smith, Donald").withSubject("ExtraEntry").build();
        ItemBuilder.createItem(this.context, col2).withTitle("Public item 2").withIssueDate("2011-08-13").withAuthor("Smith, Maria").withSubject("TestingForMore").build();
        ItemBuilder.createItem(this.context, col2).withTitle("Public item 3").withIssueDate("2012-02-19").withAuthor("Doe, Jane").withSubject("AnotherTest").withSubject("ExtraEntry").build();
        ItemBuilder.createItem(this.context, col3).withTitle("Public item 4").withIssueDate("2013-05-16").withAuthor("Vova, Jane").withSubject("ExtraEntry").build();
        ItemBuilder.createItem(this.context, col3).withTitle("Public item 5").withIssueDate("2015-04-13").withAuthor("Marco, Bruni").withSubject("ExtraEntry").build();
        ItemBuilder.createItem(this.context, col3).withTitle("Public item 6").withIssueDate("2016-01-21").withAuthor("Andriy, Beket").withSubject("ExtraEntry").build();
        this.context.setDispatcher("noindex");
        this.assertSearchQuery(IndexableCollection.TYPE, 3, 3, 0, -1);
        this.assertSearchQuery(IndexableItem.TYPE, 6, 6, 0, -1);
        this.collectionService.delete(this.context, (DSpaceObject)col3);
        this.context.restoreAuthSystemState();
        this.assertSearchQuery(IndexableCollection.TYPE, 2, 3, 0, -1);
        this.assertSearchQuery(IndexableCollection.TYPE, 2, 2, 0, -1);
        this.assertSearchQuery(IndexableItem.TYPE, 3, 6, 0, -1);
        this.assertSearchQuery(IndexableItem.TYPE, 3, 3, 0, -1);
    }

    private void assertSearchQuery(String resourceType, int size) throws SearchServiceException {
        this.assertSearchQuery(resourceType, size, size, 0, -1);
    }

    private void assertSearchQuery(String resourceType, int size, int totalFound, int start, int limit) throws SearchServiceException {
        DiscoverQuery discoverQuery = new DiscoverQuery();
        discoverQuery.setQuery("*:*");
        discoverQuery.setStart(start);
        discoverQuery.setMaxResults(limit);
        discoverQuery.addFilterQueries(new String[]{"search.resourcetype:" + resourceType});
        DiscoverResult discoverResult = this.searchService.search(this.context, discoverQuery);
        List indexableObjects = discoverResult.getIndexableObjects();
        Assert.assertEquals((long)size, (long)indexableObjects.size());
        Assert.assertEquals((long)totalFound, (long)discoverResult.getTotalSearchResults());
    }

    private void deposit(WorkspaceItem workspaceItem) throws SQLException, AuthorizeException, IOException, WorkflowException, SearchServiceException {
        this.context.turnOffAuthorisationSystem();
        workspaceItem = (WorkspaceItem)this.context.reloadEntity((ReloadableEntity)workspaceItem);
        XmlWorkflowItem unusedWorkflowItem = (XmlWorkflowItem)this.workflowService.startWithoutNotify(this.context, workspaceItem);
        this.context.commit();
        this.indexer.commit();
        this.context.restoreAuthSystemState();
    }

    private void deleteItem(Item item) throws SQLException, AuthorizeException, IOException, SearchServiceException {
        this.context.turnOffAuthorisationSystem();
        item = (Item)this.context.reloadEntity((ReloadableEntity)item);
        this.itemService.delete(this.context, (DSpaceObject)item);
        this.context.commit();
        this.indexer.commit();
        this.context.restoreAuthSystemState();
    }

    private void deleteSubmission(WorkspaceItem anotherWorkspaceItem) throws SQLException, AuthorizeException, IOException, SearchServiceException {
        this.context.turnOffAuthorisationSystem();
        anotherWorkspaceItem = (WorkspaceItem)this.context.reloadEntity((ReloadableEntity)anotherWorkspaceItem);
        this.workspaceItemService.deleteAll(this.context, anotherWorkspaceItem);
        this.context.commit();
        this.indexer.commit();
        this.context.restoreAuthSystemState();
    }

    private void deleteWorkflowItem(XmlWorkflowItem workflowItem) throws SQLException, AuthorizeException, IOException, SearchServiceException {
        this.context.turnOffAuthorisationSystem();
        workflowItem = (XmlWorkflowItem)this.context.reloadEntity((ReloadableEntity)workflowItem);
        this.workflowService.deleteWorkflowByWorkflowItem(this.context, (WorkflowItem)workflowItem, this.admin);
        this.context.commit();
        this.indexer.commit();
        this.context.restoreAuthSystemState();
    }

    private void returnClaimedTask(ClaimedTask taskToUnclaim) throws SQLException, IOException, WorkflowConfigurationException, AuthorizeException, SearchServiceException {
        EPerson previousUser = this.context.getCurrentUser();
        taskToUnclaim = (ClaimedTask)this.context.reloadEntity((ReloadableEntity)taskToUnclaim);
        this.context.setCurrentUser(taskToUnclaim.getOwner());
        XmlWorkflowItem workflowItem = taskToUnclaim.getWorkflowItem();
        this.workflowService.deleteClaimedTask(this.context, workflowItem, taskToUnclaim);
        this.workflowRequirementsService.removeClaimedUser(this.context, workflowItem, taskToUnclaim.getOwner(), taskToUnclaim.getStepID());
        this.context.commit();
        this.indexer.commit();
        this.context.setCurrentUser(previousUser);
    }

    private void claim(Workflow workflow, PoolTask task, EPerson user) throws Exception {
        EPerson previousUser = this.context.getCurrentUser();
        task = (PoolTask)this.context.reloadEntity((ReloadableEntity)task);
        this.context.setCurrentUser(user);
        Step step = workflow.getStep(task.getStepID());
        WorkflowActionConfig currentActionConfig = step.getActionConfig(task.getActionID());
        this.workflowService.doState(this.context, user, null, task.getWorkflowItem().getID().intValue(), workflow, currentActionConfig);
        this.context.commit();
        this.indexer.commit();
        this.context.setCurrentUser(previousUser);
    }

    private void executeWorkflowAction(HttpServletRequest httpServletRequest, Workflow workflow, ClaimedTask task) throws Exception {
        EPerson previousUser = this.context.getCurrentUser();
        task = (ClaimedTask)this.context.reloadEntity((ReloadableEntity)task);
        this.context.setCurrentUser(task.getOwner());
        this.workflowService.doState(this.context, task.getOwner(), httpServletRequest, task.getWorkflowItem().getID().intValue(), workflow, workflow.getStep(task.getStepID()).getActionConfig(task.getActionID()));
        this.context.commit();
        this.indexer.commit();
        this.context.setCurrentUser(previousUser);
    }

    private void abort(XmlWorkflowItem workflowItem) throws SQLException, AuthorizeException, IOException, SearchServiceException {
        EPerson previousUser = this.context.getCurrentUser();
        workflowItem = (XmlWorkflowItem)this.context.reloadEntity((ReloadableEntity)workflowItem);
        this.context.setCurrentUser(this.admin);
        this.workflowService.abort(this.context, (WorkflowItem)workflowItem, this.admin);
        this.context.commit();
        this.indexer.commit();
        this.context.setCurrentUser(previousUser);
    }
}

