/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import org.dspace.AbstractIntegrationTest;
import org.dspace.eperson.EPersonCLITool;
import org.dspace.util.ConsoleService;
import org.dspace.util.FakeConsoleServiceImpl;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.ExpectedSystemExit;
import org.junit.contrib.java.lang.system.SystemErrRule;

public class EPersonCLIToolIT
extends AbstractIntegrationTest {
    private static final String NEW_PASSWORD = "secret";
    private static final String BAD_PASSWORD = "not secret";
    @Rule
    public final ExpectedSystemExit exit = ExpectedSystemExit.none();
    @Rule
    public final SystemErrRule sysErr = new SystemErrRule().enableLog();

    @Test
    public void testSetPassword() throws Exception {
        this.exit.expectSystemExitWithStatus(0);
        System.out.println("main");
        FakeConsoleServiceImpl consoleService = new FakeConsoleServiceImpl();
        consoleService.setPassword(NEW_PASSWORD.toCharArray());
        String email = this.eperson.getEmail();
        String oldPasswordHash = this.eperson.getPassword();
        EPersonCLITool instance = new EPersonCLITool();
        instance.setConsoleService((ConsoleService)consoleService);
        String[] argv = new String[]{"--modify", "--email", email, "--newPassword"};
        EPersonCLITool.main((String[])argv);
        String newPasswordHash = this.eperson.getPassword();
        Assert.assertNotEquals((String)"Password hash did not change", (Object)oldPasswordHash, (Object)newPasswordHash);
    }

    @Test
    public void testSetEmptyPassword() throws Exception {
        this.exit.expectSystemExitWithStatus(0);
        System.out.println("main");
        FakeConsoleServiceImpl consoleService = new FakeConsoleServiceImpl();
        consoleService.setPassword(new char[0]);
        String email = this.eperson.getEmail();
        String oldPasswordHash = this.eperson.getPassword();
        EPersonCLITool instance = new EPersonCLITool();
        instance.setConsoleService((ConsoleService)consoleService);
        String[] argv = new String[]{"--modify", "--email", email, "--newPassword"};
        EPersonCLITool.main((String[])argv);
        String newPasswordHash = this.eperson.getPassword();
        Assert.assertEquals((String)"Password hash changed", (Object)oldPasswordHash, (Object)newPasswordHash);
        String stderr = this.sysErr.getLog();
        Assert.assertTrue((String)"Standard error did not mention 'empty'", (boolean)stderr.contains("The new password may not be empty."));
    }

    @Test
    public void testSetMismatchedPassword() throws Exception {
        this.exit.expectSystemExitWithStatus(0);
        System.out.println("main");
        FakeConsoleServiceImpl consoleService = new FakeConsoleServiceImpl();
        consoleService.setPassword1(NEW_PASSWORD.toCharArray());
        consoleService.setPassword2(BAD_PASSWORD.toCharArray());
        String email = this.eperson.getEmail();
        String oldPasswordHash = this.eperson.getPassword();
        EPersonCLITool instance = new EPersonCLITool();
        instance.setConsoleService((ConsoleService)consoleService);
        String[] argv = new String[]{"--modify", "--email", email, "--newPassword"};
        EPersonCLITool.main((String[])argv);
        String newPasswordHash = this.eperson.getPassword();
        Assert.assertEquals((String)"Password hash changed", (Object)oldPasswordHash, (Object)newPasswordHash);
        String stderr = this.sysErr.getLog();
        Assert.assertTrue((String)"Standard error did not indicate password mismatch", (boolean)stderr.contains("Passwords do not match.  Password not set"));
    }
}

