/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow;

import java.sql.SQLException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.builder.ClaimedTaskBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EPersonBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ReloadableEntity;
import org.dspace.discovery.IndexingService;
import org.dspace.eperson.EPerson;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.service.XmlWorkflowService;
import org.dspace.xmlworkflow.state.Workflow;
import org.dspace.xmlworkflow.storedcomponents.ClaimedTask;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public class XmlWorkflowServiceIT
extends AbstractIntegrationTestWithDatabase {
    protected XmlWorkflowService xmlWorkflowService = XmlWorkflowServiceFactory.getInstance().getXmlWorkflowService();
    protected IndexingService indexer = (IndexingService)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(IndexingService.class.getName(), IndexingService.class);
    protected AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();

    @Test
    public void workflowUserRejectsItemTheySubmitted_ItemShouldBeEditable() throws Exception {
        this.context.turnOffAuthorisationSystem();
        EPerson submitter = EPersonBuilder.createEPerson(this.context).withEmail("submitter@example.org").build();
        this.context.setCurrentUser(submitter);
        Community community = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        Collection colWithWorkflow = CollectionBuilder.createCollection(this.context, community).withName("Collection WITH workflow").withWorkflowGroup(1, submitter).build();
        Workflow workflow = XmlWorkflowServiceFactory.getInstance().getWorkflowFactory().getWorkflow(colWithWorkflow);
        ClaimedTask taskToReject = ClaimedTaskBuilder.createClaimedTask(this.context, colWithWorkflow, submitter).withTitle("Test workflow item to reject").build();
        this.context.restoreAuthSystemState();
        Assert.assertTrue((boolean)this.containsRPForUser(taskToReject.getWorkflowItem().getItem(), submitter, 1));
        MockHttpServletRequest httpRejectRequest = new MockHttpServletRequest();
        httpRejectRequest.setParameter("submit_reject", "submit_reject");
        httpRejectRequest.setParameter("reason", "test");
        this.executeWorkflowAction((HttpServletRequest)httpRejectRequest, workflow, taskToReject);
        Assert.assertTrue((boolean)this.containsRPForUser(taskToReject.getWorkflowItem().getItem(), submitter, 1));
    }

    private boolean containsRPForUser(Item item, EPerson user, int action) throws SQLException {
        List rps = this.authorizeService.getPolicies(this.context, (DSpaceObject)item);
        for (ResourcePolicy rp : rps) {
            if (!rp.getEPerson().getID().equals(user.getID()) || rp.getAction() != action) continue;
            return true;
        }
        return false;
    }

    private void executeWorkflowAction(HttpServletRequest httpServletRequest, Workflow workflow, ClaimedTask task) throws Exception {
        EPerson previousUser = this.context.getCurrentUser();
        task = (ClaimedTask)this.context.reloadEntity((ReloadableEntity)task);
        this.context.setCurrentUser(task.getOwner());
        this.xmlWorkflowService.doState(this.context, task.getOwner(), httpServletRequest, task.getWorkflowItem().getID().intValue(), workflow, workflow.getStep(task.getStepID()).getActionConfig(task.getActionID()));
        this.context.commit();
        this.indexer.commit();
        this.context.setCurrentUser(previousUser);
    }
}

