/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authorize;

import java.util.Date;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.solr.common.StringUtils;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.hibernate.annotations.Type;
import org.hibernate.proxy.HibernateProxyHelper;

@Entity
@Table(name="resourcepolicy")
public class ResourcePolicy
implements ReloadableEntity<Integer> {
    public static String TYPE_SUBMISSION = "TYPE_SUBMISSION";
    public static String TYPE_WORKFLOW = "TYPE_WORKFLOW";
    public static String TYPE_CUSTOM = "TYPE_CUSTOM";
    public static String TYPE_INHERITED = "TYPE_INHERITED";
    @Id
    @Column(name="policy_id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="resourcepolicy_seq")
    @SequenceGenerator(name="resourcepolicy_seq", sequenceName="resourcepolicy_seq", allocationSize=1)
    private Integer id;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    @JoinColumn(name="dspace_object")
    private DSpaceObject dSpaceObject;
    @Column(name="resource_type_id")
    private int resourceTypeId;
    @Column(name="action_id")
    private int actionId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="eperson_id")
    private EPerson eperson;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="epersongroup_id")
    private Group epersonGroup;
    @Column(name="start_date")
    @Temporal(value=TemporalType.DATE)
    private Date startDate;
    @Column(name="end_date")
    @Temporal(value=TemporalType.DATE)
    private Date endDate;
    @Column(name="rpname", length=30)
    private String rpname;
    @Column(name="rptype", length=30)
    private String rptype;
    @Lob
    @Type(type="org.hibernate.type.MaterializedClobType")
    @Column(name="rpdescription")
    private String rpdescription;

    protected ResourcePolicy() {
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Class objClass = HibernateProxyHelper.getClassWithoutInitializingProxy((Object)obj);
        if (this.getClass() != objClass) {
            return false;
        }
        ResourcePolicy other = (ResourcePolicy)obj;
        if (!StringUtils.equals((String)this.getRpName(), (String)other.getRpName())) {
            return false;
        }
        if (this.getAction() != other.getAction()) {
            return false;
        }
        if (!Objects.equals(this.getEPerson(), other.getEPerson())) {
            return false;
        }
        if (!Objects.equals(this.getGroup(), other.getGroup())) {
            return false;
        }
        if (!Objects.equals(this.getStartDate(), other.getStartDate())) {
            return false;
        }
        return Objects.equals(this.getEndDate(), other.getEndDate());
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + this.getAction();
        hash = this.getGroup() != null ? 19 * hash + this.getGroup().hashCode() : 19 * hash + -1;
        hash = this.getEPerson() != null ? 19 * hash + this.getEPerson().hashCode() : 19 * hash + -1;
        hash = 19 * hash + (this.getStartDate() != null ? this.getStartDate().hashCode() : 0);
        hash = 19 * hash + (this.getEndDate() != null ? this.getEndDate().hashCode() : 0);
        return hash;
    }

    @Override
    public Integer getID() {
        return this.id;
    }

    public DSpaceObject getdSpaceObject() {
        return this.dSpaceObject;
    }

    public void setdSpaceObject(DSpaceObject dSpaceObject) {
        this.dSpaceObject = dSpaceObject;
        this.resourceTypeId = dSpaceObject.getType();
    }

    public void setAction(int myid) {
        this.actionId = myid;
    }

    public int getAction() {
        return this.actionId;
    }

    public EPerson getEPerson() {
        return this.eperson;
    }

    public void setEPerson(EPerson eperson) {
        this.eperson = eperson;
    }

    public Group getGroup() {
        return this.epersonGroup;
    }

    public void setGroup(Group epersonGroup) {
        this.epersonGroup = epersonGroup;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date d) {
        this.startDate = d;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date d) {
        this.endDate = d;
    }

    public String getRpName() {
        return this.rpname;
    }

    public void setRpName(String name) {
        this.rpname = name;
    }

    public String getRpType() {
        return this.rptype;
    }

    public void setRpType(String type) {
        this.rptype = type;
    }

    public String getRpDescription() {
        return this.rpdescription;
    }

    public void setRpDescription(String description) {
        this.rpdescription = description;
    }
}

