/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dspace.content.Item;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.RelationshipType_;
import org.dspace.content.Relationship_;
import org.dspace.content.dao.RelationshipDAO;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;

public class RelationshipDAOImpl
extends AbstractHibernateDAO<Relationship>
implements RelationshipDAO {
    @Override
    public List<Relationship> findByItem(Context context, Item item, boolean excludeTilted) throws SQLException {
        return this.findByItem(context, item, -1, -1, excludeTilted);
    }

    @Override
    public List<Relationship> findByItem(Context context, Item item, Integer limit, Integer offset, boolean excludeTilted) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Relationship> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Relationship.class);
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        criteriaQuery.select((Selection)relationshipRoot);
        if (excludeTilted) {
            criteriaQuery.where((Expression)criteriaBuilder.or((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.leftItem), (Object)item), (Expression)criteriaBuilder.or((Expression)criteriaBuilder.isNull((Expression)relationshipRoot.get(Relationship_.relationshipType).get(RelationshipType_.tilted)), (Expression)criteriaBuilder.notEqual((Expression)relationshipRoot.get(Relationship_.relationshipType).get(RelationshipType_.tilted), (Object)RelationshipType.Tilted.RIGHT))), (Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.rightItem), (Object)item), (Expression)criteriaBuilder.or((Expression)criteriaBuilder.isNull((Expression)relationshipRoot.get(Relationship_.relationshipType).get(RelationshipType_.tilted)), (Expression)criteriaBuilder.notEqual((Expression)relationshipRoot.get(Relationship_.relationshipType).get(RelationshipType_.tilted), (Object)RelationshipType.Tilted.LEFT)))));
        } else {
            criteriaQuery.where((Expression)criteriaBuilder.or((Expression)criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.leftItem), (Object)item), (Expression)criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.rightItem), (Object)item)));
        }
        return this.list(context, criteriaQuery, false, Relationship.class, limit, offset);
    }

    @Override
    public int countByItem(Context context, Item item) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Relationship> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Relationship.class);
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        criteriaQuery.select((Selection)relationshipRoot);
        criteriaQuery.where((Expression)criteriaBuilder.or((Expression)criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.leftItem), (Object)item), (Expression)criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.rightItem), (Object)item)));
        return this.count(context, criteriaQuery, criteriaBuilder, relationshipRoot);
    }

    @Override
    public int findNextLeftPlaceByLeftItem(Context context, Item item) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Relationship> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Relationship.class);
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        criteriaQuery.select((Selection)relationshipRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.leftItem), (Object)item));
        List<Relationship> list = this.list(context, criteriaQuery, false, Relationship.class, -1, -1);
        list.sort((o1, o2) -> o2.getLeftPlace() - o1.getLeftPlace());
        if (!list.isEmpty()) {
            return list.get(0).getLeftPlace() + 1;
        }
        return 0;
    }

    @Override
    public int findNextRightPlaceByRightItem(Context context, Item item) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Relationship> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Relationship.class);
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        criteriaQuery.select((Selection)relationshipRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.rightItem), (Object)item));
        List<Relationship> list = this.list(context, criteriaQuery, false, Relationship.class, -1, -1);
        list.sort((o1, o2) -> o2.getRightPlace() - o1.getRightPlace());
        if (!list.isEmpty()) {
            return list.get(0).getRightPlace() + 1;
        }
        return 0;
    }

    @Override
    public List<Relationship> findByRelationshipType(Context context, RelationshipType relationshipType) throws SQLException {
        return this.findByRelationshipType(context, relationshipType, -1, -1);
    }

    @Override
    public List<Relationship> findByRelationshipType(Context context, RelationshipType relationshipType, Integer limit, Integer offset) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Relationship> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Relationship.class);
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        criteriaQuery.select((Selection)relationshipRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.relationshipType), (Object)relationshipType));
        return this.list(context, criteriaQuery, true, Relationship.class, limit, offset);
    }

    @Override
    public List<Relationship> findByItemAndRelationshipType(Context context, Item item, RelationshipType relationshipType, Integer limit, Integer offset) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Relationship> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Relationship.class);
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        criteriaQuery.select((Selection)relationshipRoot);
        criteriaQuery.where(new Predicate[]{criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.relationshipType), (Object)relationshipType), criteriaBuilder.or((Expression)criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.leftItem), (Object)item), (Expression)criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.rightItem), (Object)item))});
        return this.list(context, criteriaQuery, true, Relationship.class, limit, offset);
    }

    @Override
    public List<Relationship> findByItemAndRelationshipType(Context context, Item item, RelationshipType relationshipType, boolean isLeft, Integer limit, Integer offset) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Relationship> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Relationship.class);
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        criteriaQuery.select((Selection)relationshipRoot);
        if (isLeft) {
            criteriaQuery.where(new Predicate[]{criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.relationshipType), (Object)relationshipType), criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.leftItem), (Object)item)});
            criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)relationshipRoot.get(Relationship_.leftPlace))});
        } else {
            criteriaQuery.where(new Predicate[]{criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.relationshipType), (Object)relationshipType), criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.rightItem), (Object)item)});
            criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)relationshipRoot.get(Relationship_.rightPlace))});
        }
        return this.list(context, criteriaQuery, true, Relationship.class, limit, offset);
    }

    @Override
    public List<Relationship> findByTypeName(Context context, String typeName) throws SQLException {
        return this.findByTypeName(context, typeName, -1, -1);
    }

    @Override
    public List<Relationship> findByTypeName(Context context, String typeName, Integer limit, Integer offset) throws SQLException {
        RelationshipTypeService relationshipTypeService = ContentServiceFactory.getInstance().getRelationshipTypeService();
        List<RelationshipType> relTypes = relationshipTypeService.findByLeftwardOrRightwardTypeName(context, typeName);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (RelationshipType relationshipType : relTypes) {
            ids.add(relationshipType.getID());
        }
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Relationship> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Relationship.class);
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        criteriaQuery.where((Expression)relationshipRoot.get(Relationship_.relationshipType).in(ids));
        return this.list(context, criteriaQuery, true, Relationship.class, limit, offset);
    }

    @Override
    public int countByRelationshipType(Context context, RelationshipType relationshipType) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Relationship> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Relationship.class);
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        criteriaQuery.select((Selection)relationshipRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.relationshipType), (Object)relationshipType));
        return this.count(context, criteriaQuery, criteriaBuilder, relationshipRoot);
    }

    @Override
    public int countRows(Context context) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Relationship> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Relationship.class);
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        criteriaQuery.select((Selection)relationshipRoot);
        return this.count(context, criteriaQuery, criteriaBuilder, relationshipRoot);
    }

    @Override
    public int countByItemAndRelationshipType(Context context, Item item, RelationshipType relationshipType, boolean isLeft) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Relationship> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Relationship.class);
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        criteriaQuery.select((Selection)relationshipRoot);
        if (isLeft) {
            criteriaQuery.where(new Predicate[]{criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.relationshipType), (Object)relationshipType), criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.leftItem), (Object)item)});
        } else {
            criteriaQuery.where(new Predicate[]{criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.relationshipType), (Object)relationshipType), criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.rightItem), (Object)item)});
        }
        return this.count(context, criteriaQuery, criteriaBuilder, relationshipRoot);
    }

    @Override
    public int countByTypeName(Context context, String typeName) throws SQLException {
        RelationshipTypeService relationshipTypeService = ContentServiceFactory.getInstance().getRelationshipTypeService();
        List<RelationshipType> relTypes = relationshipTypeService.findByLeftwardOrRightwardTypeName(context, typeName);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (RelationshipType relationshipType : relTypes) {
            ids.add(relationshipType.getID());
        }
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Relationship> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Relationship.class);
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        criteriaQuery.where((Expression)relationshipRoot.get(Relationship_.relationshipType).in(ids));
        return this.count(context, criteriaQuery, criteriaBuilder, relationshipRoot);
    }

    @Override
    public List<Relationship> findByItemAndRelationshipTypeAndList(Context context, UUID focusUUID, RelationshipType relationshipType, List<UUID> items, boolean isLeft, int offset, int limit) throws SQLException {
        String side = isLeft ? "left_id" : "right_id";
        String otherSide = !isLeft ? "left_id" : "right_id";
        Query query = this.createQuery(context, "FROM " + Relationship.class.getSimpleName() + " WHERE type_id = (:typeId) AND " + side + " = (:focusUUID) AND " + otherSide + " in (:list) ORDER BY id");
        query.setParameter("typeId", (Object)relationshipType.getID());
        query.setParameter("focusUUID", (Object)focusUUID);
        query.setParameter("list", items);
        return this.list(query, limit, offset);
    }

    @Override
    public int countByItemAndRelationshipTypeAndList(Context context, UUID focusUUID, RelationshipType relationshipType, List<UUID> items, boolean isLeft) throws SQLException {
        String side = isLeft ? "left_id" : "right_id";
        String otherSide = !isLeft ? "left_id" : "right_id";
        Query query = this.createQuery(context, "SELECT count(*) FROM " + Relationship.class.getSimpleName() + " WHERE type_id = (:typeId) AND " + side + " = (:focusUUID) AND " + otherSide + " in (:list)");
        query.setParameter("typeId", (Object)relationshipType.getID());
        query.setParameter("focusUUID", (Object)focusUUID);
        query.setParameter("list", items);
        return this.count(query);
    }
}

