/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.datamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;

public class ImportRecord {
    private List<MetadatumDTO> valueList = null;

    public List<MetadatumDTO> getValueList() {
        return Collections.unmodifiableList(this.valueList);
    }

    public ImportRecord(List<MetadatumDTO> valueList) {
        this.valueList = new ArrayList<MetadatumDTO>(valueList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Record");
        sb.append("{valueList=");
        for (MetadatumDTO val : this.valueList) {
            sb.append("{");
            sb.append(val.getSchema());
            sb.append("; ");
            sb.append(val.getElement());
            sb.append("; ");
            sb.append(val.getQualifier());
            sb.append("; ");
            sb.append(val.getValue());
            sb.append("; ");
            sb.append("}\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    public Collection<MetadatumDTO> getValue(String schema, String element, String qualifier) {
        ArrayList<MetadatumDTO> values = new ArrayList<MetadatumDTO>();
        for (MetadatumDTO value : this.valueList) {
            if (!value.getSchema().equals(schema) || !value.getElement().equals(element)) continue;
            if (qualifier == null && value.getQualifier() == null) {
                values.add(value);
                continue;
            }
            if (value.getQualifier() == null || !value.getQualifier().equals(qualifier)) continue;
            values.add(value);
        }
        return values;
    }

    public void addValue(MetadatumDTO value) {
        this.valueList.add(value);
    }
}

