/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.sherpa.submit;

import java.sql.SQLException;
import org.dspace.AbstractUnitTest;
import org.dspace.app.sherpa.submit.SHERPASubmitService;
import org.dspace.app.sherpa.v2.SHERPAResponse;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataValueService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SHERPASubmitServiceTest
extends AbstractUnitTest {
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();
    protected MetadataValueService metadataValueService = ContentServiceFactory.getInstance().getMetadataValueService();
    SHERPASubmitService sherpaSubmitService = (SHERPASubmitService)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName("org.dspace.app.sherpa.submit.SHERPASubmitService", SHERPASubmitService.class);
    Collection testCollection = null;
    Community testCommunity = null;

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() throws SQLException, AuthorizeException {
        this.context.turnOffAuthorisationSystem();
        this.testCommunity = this.communityService.create(null, this.context);
        this.communityService.addMetadata(this.context, (DSpaceObject)this.testCommunity, MetadataSchemaEnum.DC.getName(), "title", null, null, "Test Community");
        this.communityService.update(this.context, (DSpaceObject)this.testCommunity);
        this.testCollection = this.collectionService.create(this.context, this.testCommunity);
        this.collectionService.addMetadata(this.context, (DSpaceObject)this.testCollection, "dc", "title", null, null, "Test Collection");
        this.collectionService.update(this.context, (DSpaceObject)this.testCollection);
    }

    @After
    public void tearDown() {
        this.context.restoreAuthSystemState();
        this.testCommunity = null;
        this.testCollection = null;
    }

    @Test
    public void testGetISSNs() throws AuthorizeException, SQLException {
        String validISSN = "0140-6736";
        WorkspaceItem testWorkspaceItem = this.workspaceItemService.create(this.context, this.testCollection, false);
        Item testItem = this.installItemService.installItem(this.context, (InProgressSubmission)testWorkspaceItem);
        MetadataField issnField = this.metadataFieldService.findByString(this.context, "dc.identifier.issn", '.');
        MetadataValue metadataValue = this.metadataValueService.create(this.context, (DSpaceObject)testItem, issnField);
        metadataValue.setValue(validISSN);
        SHERPAResponse response = this.sherpaSubmitService.searchRelatedJournals(this.context, testItem);
        Assert.assertTrue((String)"Response should not be null", (response != null ? 1 : 0) != 0);
        Assert.assertFalse((String)"Response was flagged as 'isError'", (boolean)response.isError());
    }
}

