/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.AbstractBuilder;
import org.dspace.content.MetadataSchema;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.discovery.SearchServiceException;

public class MetadataSchemaBuilder
extends AbstractBuilder<MetadataSchema, MetadataSchemaService> {
    private static final Logger log = LogManager.getLogger(MetadataSchemaBuilder.class);
    private MetadataSchema metadataSchema;

    protected MetadataSchemaBuilder(Context context) {
        super(context);
    }

    @Override
    protected MetadataSchemaService getService() {
        return metadataSchemaService;
    }

    @Override
    public void cleanup() throws Exception {
        try (Context c = new Context();){
            c.setDispatcher("noindex");
            c.turnOffAuthorisationSystem();
            this.metadataSchema = (MetadataSchema)c.reloadEntity((ReloadableEntity)this.metadataSchema);
            if (this.metadataSchema != null) {
                this.delete(c, this.metadataSchema);
            }
            c.complete();
            indexingService.commit();
        }
    }

    @Override
    public void delete(Context c, MetadataSchema dso) throws Exception {
        if (dso != null) {
            this.getService().delete(c, dso);
        }
    }

    @Override
    public MetadataSchema build() {
        try {
            metadataSchemaService.update(this.context, this.metadataSchema);
            this.context.dispatchEvents();
            indexingService.commit();
        }
        catch (SQLException | AuthorizeException | SearchServiceException e) {
            log.error((Object)e);
        }
        catch (NonUniqueMetadataException e) {
            log.error("Failed to complete MetadataSchema", (Throwable)e);
        }
        return this.metadataSchema;
    }

    public void delete(MetadataSchema dso) throws Exception {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            MetadataSchema attachedDso = (MetadataSchema)c.reloadEntity((ReloadableEntity)dso);
            if (attachedDso != null) {
                this.getService().delete(c, attachedDso);
            }
            c.complete();
        }
        indexingService.commit();
    }

    public static void deleteMetadataSchema(Integer id) throws SQLException, IOException {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            MetadataSchema metadataSchema = metadataSchemaService.find(c, id.intValue());
            if (metadataSchema != null) {
                try {
                    metadataSchemaService.delete(c, metadataSchema);
                }
                catch (AuthorizeException e) {
                    throw new RuntimeException(e);
                }
            }
            c.complete();
        }
    }

    public static MetadataSchemaBuilder createMetadataSchema(Context context, String name, String namespace) throws SQLException, AuthorizeException {
        MetadataSchemaBuilder metadataSchemaBuilder = new MetadataSchemaBuilder(context);
        return metadataSchemaBuilder.create(context, name, namespace);
    }

    private MetadataSchemaBuilder create(Context context, String name, String namespace) throws SQLException, AuthorizeException {
        this.context = context;
        try {
            this.metadataSchema = metadataSchemaService.create(context, name, namespace);
        }
        catch (NonUniqueMetadataException e) {
            log.error("Failed to create MetadataSchema", (Throwable)e);
        }
        return this;
    }
}

