/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.dspace.services.ConfigurationService;
import org.dspace.util.SimpleMapConverter;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SimpleMapConverterTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    @Mock
    private ConfigurationService configurationService;
    private File dspaceDir;
    private File crosswalksDir;

    @Before
    public void before() throws IOException {
        this.dspaceDir = this.folder.getRoot();
        this.crosswalksDir = this.folder.newFolder(new String[]{"config", "crosswalks"});
    }

    @Test
    public void testPropertiesParsing() throws IOException {
        Mockito.when((Object)this.configurationService.getProperty("dspace.dir")).thenReturn((Object)this.dspaceDir.getAbsolutePath());
        this.createFileInFolder(this.crosswalksDir, "test.properties", "key1=value1\nkey2=value2\nkey3=value3");
        SimpleMapConverter simpleMapConverter = new SimpleMapConverter();
        simpleMapConverter.setConfigurationService(this.configurationService);
        simpleMapConverter.setConverterNameFile("test.properties");
        simpleMapConverter.init();
        MatcherAssert.assertThat((Object)simpleMapConverter.getValue("key1"), (Matcher)Matchers.is((Object)"value1"));
        MatcherAssert.assertThat((Object)simpleMapConverter.getValue("key2"), (Matcher)Matchers.is((Object)"value2"));
        MatcherAssert.assertThat((Object)simpleMapConverter.getValue("key3"), (Matcher)Matchers.is((Object)"value3"));
        MatcherAssert.assertThat((Object)simpleMapConverter.getValue(""), (Matcher)Matchers.is((Object)""));
        MatcherAssert.assertThat((Object)simpleMapConverter.getValue(null), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)simpleMapConverter.getValue("key4"), (Matcher)Matchers.is((Object)"key4"));
    }

    @Test
    public void testPropertiesParsingWithDefaultValue() throws IOException {
        Mockito.when((Object)this.configurationService.getProperty("dspace.dir")).thenReturn((Object)this.dspaceDir.getAbsolutePath());
        this.createFileInFolder(this.crosswalksDir, "test.properties", "key1=value1\nkey2=value2\nkey3=value3");
        SimpleMapConverter simpleMapConverter = new SimpleMapConverter();
        simpleMapConverter.setConfigurationService(this.configurationService);
        simpleMapConverter.setConverterNameFile("test.properties");
        simpleMapConverter.setDefaultValue("default");
        simpleMapConverter.init();
        MatcherAssert.assertThat((Object)simpleMapConverter.getValue("key1"), (Matcher)Matchers.is((Object)"value1"));
        MatcherAssert.assertThat((Object)simpleMapConverter.getValue("key2"), (Matcher)Matchers.is((Object)"value2"));
        MatcherAssert.assertThat((Object)simpleMapConverter.getValue("key3"), (Matcher)Matchers.is((Object)"value3"));
        MatcherAssert.assertThat((Object)simpleMapConverter.getValue(""), (Matcher)Matchers.is((Object)"default"));
        MatcherAssert.assertThat((Object)simpleMapConverter.getValue(null), (Matcher)Matchers.is((Object)"default"));
        MatcherAssert.assertThat((Object)simpleMapConverter.getValue("key4"), (Matcher)Matchers.is((Object)"default"));
    }

    @Test
    public void testPropertiesParsingWithAnUnexistingFile() throws IOException {
        Mockito.when((Object)this.configurationService.getProperty("dspace.dir")).thenReturn((Object)this.dspaceDir.getAbsolutePath());
        SimpleMapConverter simpleMapConverter = new SimpleMapConverter();
        simpleMapConverter.setConfigurationService(this.configurationService);
        simpleMapConverter.setConverterNameFile("test.properties");
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> simpleMapConverter.init());
        String separator = File.separator;
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)("An error occurs parsing " + this.dspaceDir.getAbsolutePath() + separator + "config" + separator + "crosswalks" + separator + "test.properties")));
        Throwable cause = exception.getCause();
        MatcherAssert.assertThat((Object)cause, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)cause, (Matcher)Matchers.instanceOf(FileNotFoundException.class));
    }

    @Test
    public void testPropertiesParsingWithCorruptedFile() throws IOException {
        Mockito.when((Object)this.configurationService.getProperty("dspace.dir")).thenReturn((Object)this.dspaceDir.getAbsolutePath());
        this.createFileInFolder(this.crosswalksDir, "test.properties", "key1=value1\nkey2\nkey3=value3");
        SimpleMapConverter simpleMapConverter = new SimpleMapConverter();
        simpleMapConverter.setConfigurationService(this.configurationService);
        simpleMapConverter.setConverterNameFile("test.properties");
        simpleMapConverter.init();
        MatcherAssert.assertThat((Object)simpleMapConverter.getValue("key1"), (Matcher)Matchers.is((Object)"value1"));
        MatcherAssert.assertThat((Object)simpleMapConverter.getValue("key2"), (Matcher)Matchers.is((Object)"key2"));
        MatcherAssert.assertThat((Object)simpleMapConverter.getValue("key3"), (Matcher)Matchers.is((Object)"value3"));
        MatcherAssert.assertThat((Object)simpleMapConverter.getValue("key4"), (Matcher)Matchers.is((Object)"key4"));
    }

    @Test
    public void testPropertiesParsingWithEmptyFile() throws IOException {
        Mockito.when((Object)this.configurationService.getProperty("dspace.dir")).thenReturn((Object)this.dspaceDir.getAbsolutePath());
        this.createFileInFolder(this.crosswalksDir, "test.properties", "");
        SimpleMapConverter simpleMapConverter = new SimpleMapConverter();
        simpleMapConverter.setConfigurationService(this.configurationService);
        simpleMapConverter.setConverterNameFile("test.properties");
        simpleMapConverter.init();
        MatcherAssert.assertThat((Object)simpleMapConverter.getValue("key1"), (Matcher)Matchers.is((Object)"key1"));
        MatcherAssert.assertThat((Object)simpleMapConverter.getValue("key2"), (Matcher)Matchers.is((Object)"key2"));
    }

    private void createFileInFolder(File folder, String name, String content) throws IOException {
        File file = new File(folder, name);
        FileUtils.write((File)file, (CharSequence)content, (Charset)StandardCharsets.UTF_8);
    }
}

