/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow;

import junit.framework.TestCase;
import org.dspace.AbstractUnitTest;
import org.dspace.utils.DSpace;
import org.dspace.xmlworkflow.Role;
import org.dspace.xmlworkflow.state.Workflow;
import org.junit.Test;

public class RoleTest
extends AbstractUnitTest {
    private Workflow defaultWorkflow = (Workflow)new DSpace().getServiceManager().getServiceByName("defaultWorkflow", Workflow.class);
    private Workflow selectSingleReviewer = (Workflow)new DSpace().getServiceManager().getServiceByName("selectSingleReviewer", Workflow.class);
    private Workflow scoreReview = (Workflow)new DSpace().getServiceManager().getServiceByName("scoreReview", Workflow.class);

    @Test
    public void defaultWorkflow_RoleReviewer() {
        Role role = (Role)this.defaultWorkflow.getRoles().get("reviewer");
        TestCase.assertEquals((String)"The people responsible for this step are able to edit the metadata of incoming submissions, and then accept or reject them.", (String)role.getDescription());
        TestCase.assertEquals((String)"Reviewer", (String)role.getName());
        TestCase.assertEquals((Object)Role.Scope.COLLECTION, (Object)role.getScope());
    }

    @Test
    public void defaultWorkflow_RoleEditor() {
        Role role = (Role)this.defaultWorkflow.getRoles().get("editor");
        TestCase.assertEquals((String)"The people responsible for this step are able to edit the metadata of incoming submissions, and then accept or reject them.", (String)role.getDescription());
        TestCase.assertEquals((String)"Editor", (String)role.getName());
        TestCase.assertEquals((Object)Role.Scope.COLLECTION, (Object)role.getScope());
    }

    @Test
    public void defaultWorkflow_RoleFinalEditor() {
        Role role = (Role)this.defaultWorkflow.getRoles().get("finaleditor");
        TestCase.assertEquals((String)"The people responsible for this step are able to edit the metadata of incoming submissions, but will not be able to reject them.", (String)role.getDescription());
        TestCase.assertEquals((String)"Final Editor", (String)role.getName());
        TestCase.assertEquals((Object)Role.Scope.COLLECTION, (Object)role.getScope());
    }

    @Test
    public void selectSingleReviewer_RoleReviewManagers() {
        Role role = (Role)this.selectSingleReviewer.getRoles().get("reviewmanagers");
        TestCase.assertEquals((String)"ReviewManagers", (String)role.getName());
        TestCase.assertEquals((Object)Role.Scope.REPOSITORY, (Object)role.getScope());
    }

    @Test
    public void selectSingleReviewer_RoleReviewer() {
        Role role = (Role)this.selectSingleReviewer.getRoles().get("scoreassignedreviewer");
        TestCase.assertEquals((String)"Reviewer", (String)role.getName());
        TestCase.assertEquals((Object)Role.Scope.ITEM, (Object)role.getScope());
    }

    @Test
    public void scoreReview_RoleScoreReviewers() {
        Role role = (Role)this.scoreReview.getRoles().get("scorereviewers");
        TestCase.assertEquals((String)"ScoreReviewers", (String)role.getName());
        TestCase.assertEquals((Object)Role.Scope.COLLECTION, (Object)role.getScope());
    }
}

