/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemimport;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.dspace.app.itemimport.factory.ItemImportServiceFactory;
import org.dspace.app.itemimport.service.ItemImportService;
import org.dspace.content.Collection;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;

public class ItemImportCLITool {
    private static boolean template = false;
    private static final CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    private static final EPersonService epersonService = EPersonServiceFactory.getInstance().getEPersonService();
    private static final HandleService handleService = HandleServiceFactory.getInstance().getHandleService();

    private ItemImportCLITool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        Date startTime = new Date();
        int status = 0;
        try {
            DefaultParser parser = new DefaultParser();
            Options options = new Options();
            options.addOption("a", "add", false, "add items to DSpace");
            options.addOption("r", "replace", false, "replace items in mapfile");
            options.addOption("d", "delete", false, "delete items listed in mapfile");
            options.addOption("s", "source", true, "source of items (directory)");
            options.addOption("z", "zip", true, "name of zip file");
            options.addOption("c", "collection", true, "destination collection(s) Handle or database ID");
            options.addOption("m", "mapfile", true, "mapfile items in mapfile");
            options.addOption("e", "eperson", true, "email of eperson doing importing");
            options.addOption("w", "workflow", false, "send submission through collection's workflow");
            options.addOption("n", "notify", false, "if sending submissions through the workflow, send notification emails");
            options.addOption("t", "test", false, "test run - do not actually import items");
            options.addOption("p", "template", false, "apply template");
            options.addOption("R", "resume", false, "resume a failed import (add only)");
            options.addOption("q", "quiet", false, "don't display metadata");
            options.addOption("h", "help", false, "help");
            CommandLine line = parser.parse(options, argv);
            String command = null;
            String sourcedir = null;
            String mapfile = null;
            String eperson = null;
            String[] collections = null;
            boolean isTest = false;
            boolean isResume = false;
            boolean useWorkflow = false;
            boolean useWorkflowSendEmail = false;
            boolean isQuiet = false;
            if (line.hasOption('h')) {
                HelpFormatter myhelp = new HelpFormatter();
                myhelp.printHelp("ItemImport\n", options);
                System.out.println("\nadding items:    ItemImport -a -e eperson -c collection -s sourcedir -m mapfile");
                System.out.println("\nadding items from zip file:    ItemImport -a -e eperson -c collection -s sourcedir -z filename.zip -m mapfile");
                System.out.println("replacing items: ItemImport -r -e eperson -c collection -s sourcedir -m mapfile");
                System.out.println("deleting items:  ItemImport -d -e eperson -m mapfile");
                System.out.println("If multiple collections are specified, the first collection will be the one that owns the item.");
                System.exit(0);
            }
            if (line.hasOption('a')) {
                command = "add";
            }
            if (line.hasOption('r')) {
                command = "replace";
            }
            if (line.hasOption('d')) {
                command = "delete";
            }
            if (line.hasOption('w')) {
                useWorkflow = true;
                if (line.hasOption('n')) {
                    useWorkflowSendEmail = true;
                }
            }
            if (line.hasOption('t')) {
                isTest = true;
                System.out.println("**Test Run** - not actually importing items.");
            }
            if (line.hasOption('p')) {
                template = true;
            }
            if (line.hasOption('s')) {
                sourcedir = line.getOptionValue('s');
            }
            if (line.hasOption('m')) {
                mapfile = line.getOptionValue('m');
            }
            if (line.hasOption('e')) {
                eperson = line.getOptionValue('e');
            }
            if (line.hasOption('c')) {
                collections = line.getOptionValues('c');
            }
            if (line.hasOption('R')) {
                isResume = true;
                System.out.println("**Resume import** - attempting to import items not already imported");
            }
            if (line.hasOption('q')) {
                isQuiet = true;
            }
            boolean zip = false;
            String zipfilename = "";
            if (line.hasOption('z')) {
                zip = true;
                zipfilename = line.getOptionValue('z');
            }
            boolean commandLineCollections = true;
            if (command == null) {
                System.out.println("Error - must run with either add, replace, or remove (run with -h flag for details)");
                System.exit(1);
            } else if ("add".equals(command) || "replace".equals(command)) {
                if (sourcedir == null) {
                    System.out.println("Error - a source directory containing items must be set");
                    System.out.println(" (run with -h flag for details)");
                    System.exit(1);
                }
                if (mapfile == null) {
                    System.out.println("Error - a map file to hold importing results must be specified");
                    System.out.println(" (run with -h flag for details)");
                    System.exit(1);
                }
                if (eperson == null) {
                    System.out.println("Error - an eperson to do the importing must be specified");
                    System.out.println(" (run with -h flag for details)");
                    System.exit(1);
                }
                if (collections == null) {
                    System.out.println("No collections given. Assuming 'collections' file inside item directory");
                    commandLineCollections = false;
                }
            } else if ("delete".equals(command)) {
                if (eperson == null) {
                    System.out.println("Error - an eperson to do the importing must be specified");
                    System.exit(1);
                }
                if (mapfile == null) {
                    System.out.println("Error - a map file must be specified");
                    System.exit(1);
                }
            }
            if (isResume && !"add".equals(command)) {
                System.out.println("Error - resume option only works with the --add command");
                System.exit(1);
            }
            File myFile = new File(mapfile);
            if (!isResume && "add".equals(command) && myFile.exists()) {
                System.out.println("Error - the mapfile " + mapfile + " already exists.");
                System.out.println("Either delete it or use --resume if attempting to resume an aborted import.");
                System.exit(1);
            }
            ItemImportService myloader = ItemImportServiceFactory.getInstance().getItemImportService();
            myloader.setTest(isTest);
            myloader.setResume(isResume);
            myloader.setUseWorkflow(useWorkflow);
            myloader.setUseWorkflowSendEmail(useWorkflowSendEmail);
            myloader.setQuiet(isQuiet);
            Context c = new Context(Context.Mode.BATCH_EDIT);
            EPerson myEPerson = null;
            myEPerson = eperson.indexOf(64) != -1 ? epersonService.findByEmail(c, eperson) : (EPerson)epersonService.find(c, UUID.fromString(eperson));
            if (myEPerson == null) {
                System.out.println("Error, eperson cannot be found: " + eperson);
                System.exit(1);
            }
            c.setCurrentUser(myEPerson);
            ArrayList<Collection> mycollections = null;
            if (!"delete".equals(command) && commandLineCollections) {
                System.out.println("Destination collections:");
                mycollections = new ArrayList<Collection>();
                for (int i = 0; i < collections.length; ++i) {
                    Collection resolved = null;
                    if (collections[i] != null) {
                        resolved = collections[i].indexOf(47) != -1 ? (Collection)handleService.resolveToObject(c, collections[i]) : (Collection)collectionService.find(c, UUID.fromString(collections[i]));
                    }
                    if (resolved == null || resolved.getType() != 3) {
                        throw new IllegalArgumentException("Cannot resolve " + collections[i] + " to collection");
                    }
                    mycollections.add(resolved);
                    String owningPrefix = "";
                    if (i == 0) {
                        owningPrefix = "Owning ";
                    }
                    System.out.println(owningPrefix + " Collection: " + resolved.getName());
                }
            }
            try {
                if (zip) {
                    sourcedir = myloader.unzip(sourcedir, zipfilename);
                }
                c.turnOffAuthorisationSystem();
                if ("add".equals(command)) {
                    myloader.addItems(c, mycollections, sourcedir, mapfile, template);
                } else if ("replace".equals(command)) {
                    myloader.replaceItems(c, mycollections, sourcedir, mapfile, template);
                } else if ("delete".equals(command)) {
                    myloader.deleteItems(c, mapfile);
                }
                c.complete();
            }
            catch (Exception e) {
                c.abort();
                e.printStackTrace();
                System.out.println(e);
                status = 1;
            }
            try {
                if (zip) {
                    System.gc();
                    System.out.println("Deleting temporary zip directory: " + myloader.getTempWorkDirFile().getAbsolutePath());
                    myloader.cleanupZipTemp();
                }
            }
            catch (IOException ex) {
                System.out.println("Unable to delete temporary zip archive location: " + myloader.getTempWorkDirFile().getAbsolutePath());
            }
            if (isTest) {
                System.out.println("***End of Test Run***");
            }
        }
        finally {
            Date endTime = new Date();
            System.out.println("Started: " + startTime.getTime());
            System.out.println("Ended: " + endTime.getTime());
            System.out.println("Elapsed time: " + (endTime.getTime() - startTime.getTime()) / 1000L + " secs (" + (endTime.getTime() - startTime.getTime()) + " msecs)");
        }
        System.exit(status);
    }
}

