/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.requestitem;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.dspace.app.requestitem.RequestItem;
import org.dspace.app.requestitem.dao.RequestItemDAO;
import org.dspace.app.requestitem.service.RequestItemService;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.authorize.service.ResourcePolicyService;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.core.Utils;
import org.springframework.beans.factory.annotation.Autowired;

public class RequestItemServiceImpl
implements RequestItemService {
    private final Logger log = LogManager.getLogger();
    @Autowired(required=true)
    protected RequestItemDAO requestItemDAO;
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected ResourcePolicyService resourcePolicyService;

    protected RequestItemServiceImpl() {
    }

    @Override
    public String createRequest(Context context, Bitstream bitstream, Item item, boolean allFiles, String reqEmail, String reqName, String reqMessage) throws SQLException {
        RequestItem requestItem = this.requestItemDAO.create(context, new RequestItem());
        requestItem.setToken(Utils.generateHexKey());
        requestItem.setBitstream(bitstream);
        requestItem.setItem(item);
        requestItem.setAllfiles(allFiles);
        requestItem.setReqEmail(reqEmail);
        requestItem.setReqName(reqName);
        requestItem.setReqMessage(reqMessage);
        requestItem.setRequest_date(new Date());
        this.requestItemDAO.save(context, requestItem);
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = requestItem::getID;
        supplierArray[1] = requestItem::getToken;
        this.log.debug("Created RequestItem with ID {} and token {}", supplierArray);
        return requestItem.getToken();
    }

    @Override
    public List<RequestItem> findAll(Context context) throws SQLException {
        return this.requestItemDAO.findAll(context, RequestItem.class);
    }

    @Override
    public RequestItem findByToken(Context context, String token) {
        try {
            return this.requestItemDAO.findByToken(context, token);
        }
        catch (SQLException e) {
            this.log.error(e.getMessage());
            return null;
        }
    }

    @Override
    public void update(Context context, RequestItem requestItem) {
        try {
            this.requestItemDAO.save(context, requestItem);
        }
        catch (SQLException e) {
            this.log.error(e.getMessage());
        }
    }

    @Override
    public void delete(Context context, RequestItem requestItem) {
        this.log.debug(LogHelper.getHeader(context, "delete_itemrequest", "request_id={}"), (Object)requestItem.getID());
        try {
            this.requestItemDAO.delete(context, requestItem);
        }
        catch (SQLException e) {
            this.log.error(e.getMessage());
        }
    }

    @Override
    public boolean isRestricted(Context context, DSpaceObject o) throws SQLException {
        List<ResourcePolicy> policies = this.authorizeService.getPoliciesActionFilter(context, o, 0);
        for (ResourcePolicy rp : policies) {
            if (!this.resourcePolicyService.isDateValid(rp)) continue;
            return false;
        }
        return true;
    }
}

