/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authenticate.AuthenticationMethod;
import org.dspace.authenticate.factory.AuthenticateServiceFactory;
import org.dspace.authenticate.service.AuthenticationService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class X509Authentication
implements AuthenticationMethod {
    private static Logger log = LogManager.getLogger(X509Authentication.class);
    private static PublicKey caPublicKey = null;
    private static KeyStore caCertKeyStore = null;
    private static String loginPageTitle = null;
    private static String loginPageURL = null;
    protected AuthenticationService authenticationService = AuthenticateServiceFactory.getInstance().getAuthenticationService();
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private static final String X509_AUTHENTICATED = "x509.authenticated";

    private static String getEmail(X509Certificate certificate) throws SQLException {
        Principal principal = certificate.getSubjectDN();
        if (principal == null) {
            return null;
        }
        String dn = principal.getName();
        if (dn == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(dn, ",");
        String token = null;
        while (tokenizer.hasMoreTokens()) {
            int len = "emailaddress=".length();
            token = tokenizer.nextToken();
            if (!token.toLowerCase().startsWith("emailaddress=")) continue;
            if (token.length() <= len) {
                return null;
            }
            return token.substring(len).toLowerCase();
        }
        return null;
    }

    private static boolean isValid(Context context, X509Certificate certificate) {
        if (certificate == null) {
            return false;
        }
        try {
            certificate.checkValidity();
        }
        catch (CertificateException e) {
            log.info(LogHelper.getHeader(context, "authentication", "X.509 Certificate is EXPIRED or PREMATURE: " + e.toString()));
            return false;
        }
        if (caPublicKey != null) {
            try {
                certificate.verify(caPublicKey);
                return true;
            }
            catch (GeneralSecurityException e) {
                log.info(LogHelper.getHeader(context, "authentication", "X.509 Certificate FAILED SIGNATURE check: " + e.toString()));
            }
        }
        if (caCertKeyStore != null) {
            try {
                Enumeration<String> ke = caCertKeyStore.aliases();
                while (ke.hasMoreElements()) {
                    String alias = ke.nextElement();
                    if (!caCertKeyStore.isCertificateEntry(alias)) continue;
                    Certificate ca = caCertKeyStore.getCertificate(alias);
                    try {
                        certificate.verify(ca.getPublicKey());
                        return true;
                    }
                    catch (CertificateException certificateException) {
                    }
                }
                log.info(LogHelper.getHeader(context, "authentication", "Keystore method FAILED SIGNATURE check on client cert."));
            }
            catch (GeneralSecurityException e) {
                log.info(LogHelper.getHeader(context, "authentication", "X.509 Certificate FAILED SIGNATURE check: " + e.toString()));
            }
        }
        return false;
    }

    @Override
    public boolean canSelfRegister(Context context, HttpServletRequest request, String username) throws SQLException {
        return this.configurationService.getBooleanProperty("authentication-x509.autoregister");
    }

    @Override
    public void initEPerson(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
    }

    @Override
    public boolean allowSetPassword(Context context, HttpServletRequest request, String username) throws SQLException {
        return false;
    }

    @Override
    public boolean isImplicit() {
        return true;
    }

    private List<String> getX509Groups() {
        ArrayList<String> groupNames = new ArrayList<String>();
        Object[] groups = this.configurationService.getArrayProperty("authentication-x509.groups");
        if (ArrayUtils.isNotEmpty((Object[])groups)) {
            for (Object group : groups) {
                groupNames.add(((String)group).trim());
            }
        }
        return groupNames;
    }

    private void setSpecialGroupsFlag(HttpServletRequest request, String email) {
        String emailDomain = null;
        emailDomain = (String)request.getAttribute("authentication.x509.emaildomain");
        HttpSession session = request.getSession(true);
        if (null != emailDomain && !"".equals(emailDomain)) {
            if (email.substring(email.length() - emailDomain.length()).equals(emailDomain)) {
                session.setAttribute("x509Auth", (Object)Boolean.TRUE);
            }
        } else {
            session.setAttribute("x509Auth", (Object)Boolean.TRUE);
        }
    }

    @Override
    public List<Group> getSpecialGroups(Context context, HttpServletRequest request) throws SQLException {
        if (request == null) {
            return Collections.EMPTY_LIST;
        }
        Boolean authenticated = false;
        HttpSession session = request.getSession(false);
        authenticated = (Boolean)session.getAttribute("x509Auth");
        authenticated = null == authenticated ? false : authenticated;
        if (authenticated.booleanValue()) {
            List<String> groupNames = this.getX509Groups();
            ArrayList<Group> groups = new ArrayList<Group>();
            if (groupNames != null) {
                for (String groupName : groupNames) {
                    if (groupName == null) continue;
                    Group group = this.groupService.findByName(context, groupName);
                    if (group != null) {
                        groups.add(group);
                        continue;
                    }
                    log.warn(LogHelper.getHeader(context, "configuration_error", "unknown_group=" + groupName));
                }
            }
            return groups;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public int authenticate(Context context, String username, String password, String realm, HttpServletRequest request) throws SQLException {
        X509Certificate[] certs = null;
        if (request != null) {
            certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        }
        if (certs == null || certs.length == 0) {
            return 5;
        }
        try {
            if (!X509Authentication.isValid(context, certs[0])) {
                log.warn(LogHelper.getHeader(context, "authenticate", "type=x509certificate, status=BAD_CREDENTIALS (not valid)"));
                return 2;
            }
            String email = X509Authentication.getEmail(certs[0]);
            EPerson eperson = null;
            if (email != null) {
                eperson = this.ePersonService.findByEmail(context, email);
            }
            if (eperson == null) {
                if (email != null && this.canSelfRegister(context, request, null)) {
                    log.info(LogHelper.getHeader(context, "autoregister", "from=x.509, email=" + email));
                    context.turnOffAuthorisationSystem();
                    eperson = this.ePersonService.create(context);
                    eperson.setEmail(email);
                    eperson.setCanLogIn(true);
                    this.authenticationService.initEPerson(context, request, eperson);
                    this.ePersonService.update(context, eperson);
                    context.dispatchEvents();
                    context.restoreAuthSystemState();
                    context.setCurrentUser(eperson);
                    request.setAttribute(X509_AUTHENTICATED, (Object)true);
                    this.setSpecialGroupsFlag(request, email);
                    return 1;
                }
                log.warn(LogHelper.getHeader(context, "authenticate", "type=cert_but_no_record, cannot auto-register"));
                return 4;
            }
            if (!eperson.canLogIn()) {
                log.warn(LogHelper.getHeader(context, "authenticate", "type=x509certificate, email=" + email + ", canLogIn=false, rejecting."));
                return 5;
            }
            log.info(LogHelper.getHeader(context, "login", "type=x509certificate"));
            context.setCurrentUser(eperson);
            request.setAttribute(X509_AUTHENTICATED, (Object)true);
            this.setSpecialGroupsFlag(request, email);
            return 1;
        }
        catch (AuthorizeException ce) {
            log.warn(LogHelper.getHeader(context, "authorize_exception", ""), (Throwable)ce);
            return 5;
        }
    }

    @Override
    public String loginPageURL(Context context, HttpServletRequest request, HttpServletResponse response) {
        return loginPageURL;
    }

    @Override
    public String getName() {
        return "x509";
    }

    @Override
    public boolean isUsed(Context context, HttpServletRequest request) {
        return request != null && context.getCurrentUser() != null && request.getAttribute(X509_AUTHENTICATED) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        loginPageTitle = configurationService.getProperty("authentication-x509.chooser.title.key");
        loginPageURL = configurationService.getProperty("authentication-x509.chooser.uri");
        String keystorePath = configurationService.getProperty("authentication-x509.keystore.path");
        String keystorePassword = configurationService.getProperty("authentication-x509.keystore.password");
        String caCertPath = configurationService.getProperty("authentication-x509.ca.cert");
        if (keystorePath != null) {
            FileInputStream fis = null;
            if (keystorePassword == null) {
                keystorePassword = "";
            }
            try {
                KeyStore ks = KeyStore.getInstance("JKS");
                fis = new FileInputStream(keystorePath);
                ks.load(fis, keystorePassword.toCharArray());
                caCertKeyStore = ks;
            }
            catch (IOException e) {
                log.error("X509Authentication: Failed to load CA keystore, file=" + keystorePath + ", error=" + e.toString());
            }
            catch (GeneralSecurityException e) {
                log.error("X509Authentication: Failed to extract CA keystore, file=" + keystorePath + ", error=" + e.toString());
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        if (caCertPath != null) {
            InputStream is = null;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(caCertPath);
                is = new BufferedInputStream(fis);
                X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(is);
                if (cert != null) {
                    caPublicKey = cert.getPublicKey();
                }
            }
            catch (IOException e) {
                log.error("X509Authentication: Failed to load CA cert, file=" + caCertPath + ", error=" + e.toString());
            }
            catch (CertificateException e) {
                log.error("X509Authentication: Failed to extract CA cert, file=" + caCertPath + ", error=" + e.toString());
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }
}

