/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLUtils {
    private static Logger log = LogManager.getLogger(XMLUtils.class);

    private XMLUtils() {
    }

    public static String getTextContent(Node xml, String singleNodeXPath) throws XPathExpressionException {
        String text = null;
        Node node = XMLUtils.getNode(xml, singleNodeXPath);
        if (node != null) {
            text = node.getTextContent();
        }
        return text;
    }

    public static Node getNode(Node xml, String nodeListXPath) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        return (Node)xPath.compile(nodeListXPath).evaluate(xml, XPathConstants.NODE);
    }

    public static NodeList getNodeList(Node xml, String nodeListXPath) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        return (NodeList)xPath.compile(nodeListXPath).evaluate(xml, XPathConstants.NODESET);
    }

    public static Iterator<Node> getNodeListIterator(Node xml, String NodeListXPath) throws XPathExpressionException {
        return XMLUtils.getNodeListIterator(XMLUtils.getNodeList(xml, NodeListXPath));
    }

    public static Iterator<Node> getNodeListIterator(final NodeList nodeList) {
        return new Iterator<Node>(){
            private Iterator<Node> nodeIterator;
            private Node lastNode;
            {
                ArrayList<Node> nodes = new ArrayList<Node>();
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Node node = nodeList.item(i);
                        if (node.getNodeType() != 1 || !(node instanceof Element)) continue;
                        nodes.add(node);
                    }
                }
                this.nodeIterator = nodes.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.nodeIterator.hasNext();
            }

            @Override
            public Node next() {
                this.lastNode = this.nodeIterator.next();
                return this.lastNode;
            }

            @Override
            public void remove() {
                this.nodeIterator.remove();
            }
        };
    }

    public static Document convertStreamToXML(InputStream is) {
        Document result = null;
        if (is != null) {
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = domFactory.newDocumentBuilder();
                result = builder.parse(is);
            }
            catch (ParserConfigurationException e) {
                log.error("Error", (Throwable)e);
            }
            catch (SAXException e) {
                log.error("Error", (Throwable)e);
            }
            catch (IOException e) {
                log.error("Error", (Throwable)e);
            }
        }
        return result;
    }
}

