/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.DSpaceObjectLegacySupport;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.content.comparator.NameAscendingComparator;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.eperson.EPerson;
import org.hibernate.proxy.HibernateProxyHelper;

@Entity
@Table(name="item")
public class Item
extends DSpaceObject
implements DSpaceObjectLegacySupport {
    public static final String ANY = "*";
    @Column(name="item_id", insertable=false, updatable=false)
    private Integer legacyId;
    @Column(name="in_archive")
    private boolean inArchive = false;
    @Column(name="discoverable")
    private boolean discoverable = false;
    @Column(name="withdrawn")
    private boolean withdrawn = false;
    @Column(name="last_modified", columnDefinition="timestamp with time zone")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastModified = new Date();
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @JoinColumn(name="owning_collection")
    private Collection owningCollection;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="template")
    private Collection templateItemOf;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="submitter_id")
    private EPerson submitter = null;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @JoinTable(name="collection2item", joinColumns={@JoinColumn(name="item_id")}, inverseJoinColumns={@JoinColumn(name="collection_id")})
    private final Set<Collection> collections = new HashSet<Collection>();
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="items")
    private final List<Bundle> bundles = new ArrayList<Bundle>();
    @Transient
    private transient ItemService itemService;
    @Transient
    private boolean modifiedMetadataCache = true;
    @Transient
    private List<MetadataValue> cachedMetadata = new ArrayList<MetadataValue>();

    protected Item() {
    }

    protected Item(UUID uuid) {
        this.predefinedUUID = uuid;
    }

    public boolean isArchived() {
        return this.inArchive;
    }

    public boolean isWithdrawn() {
        return this.withdrawn;
    }

    void setWithdrawn(boolean withdrawn) {
        this.withdrawn = withdrawn;
    }

    public boolean isDiscoverable() {
        return this.discoverable;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public void setArchived(boolean isArchived) {
        this.inArchive = isArchived;
        this.setModified();
    }

    public void setDiscoverable(boolean discoverable) {
        this.discoverable = discoverable;
        this.setModified();
    }

    public void setOwningCollection(Collection c) {
        this.owningCollection = c;
        this.setModified();
    }

    public Collection getOwningCollection() {
        return this.owningCollection;
    }

    public EPerson getSubmitter() {
        return this.submitter;
    }

    public void setSubmitter(EPerson sub) {
        this.submitter = sub;
        this.setModified();
    }

    public List<Collection> getCollections() {
        Collection[] output = this.collections.toArray(new Collection[0]);
        Arrays.sort(output, new NameAscendingComparator());
        return Arrays.asList(output);
    }

    void addCollection(Collection collection) {
        this.collections.add(collection);
    }

    void removeCollection(Collection collection) {
        this.collections.remove(collection);
    }

    public void clearCollections() {
        this.collections.clear();
    }

    public Collection getTemplateItemOf() {
        return this.templateItemOf;
    }

    void setTemplateItemOf(Collection templateItemOf) {
        this.templateItemOf = templateItemOf;
    }

    public List<Bundle> getBundles() {
        return this.bundles;
    }

    public List<Bundle> getBundles(String name) {
        ArrayList<Bundle> matchingBundles = new ArrayList<Bundle>();
        List<Bundle> bunds = this.getBundles();
        for (Bundle bundle : bunds) {
            if (!name.equals(bundle.getName())) continue;
            matchingBundles.add(bundle);
        }
        return matchingBundles;
    }

    void addBundle(Bundle bundle) {
        this.bundles.add(bundle);
    }

    void removeBundle(Bundle bundle) {
        this.bundles.remove(bundle);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Item)) {
            return false;
        }
        Class objClass = HibernateProxyHelper.getClassWithoutInitializingProxy((Object)obj);
        if (this.getClass() != objClass) {
            return false;
        }
        Item otherItem = (Item)obj;
        return this.getID().equals(otherItem.getID());
    }

    public int hashCode() {
        int hash = 5;
        hash += 71 * hash + this.getType();
        hash += 71 * hash + this.getID().hashCode();
        return hash;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public String getName() {
        return this.getItemService().getMetadataFirstValue(this, MetadataSchemaEnum.DC.getName(), "title", null, ANY);
    }

    @Override
    public Integer getLegacyId() {
        return this.legacyId;
    }

    public ItemService getItemService() {
        if (this.itemService == null) {
            this.itemService = ContentServiceFactory.getInstance().getItemService();
        }
        return this.itemService;
    }

    @Override
    protected void setMetadataModified() {
        super.setMetadataModified();
        this.modifiedMetadataCache = true;
    }

    public boolean isModifiedMetadataCache() {
        return this.modifiedMetadataCache;
    }

    protected List<MetadataValue> getCachedMetadata() {
        return this.cachedMetadata;
    }

    protected void setCachedMetadata(List<MetadataValue> cachedMetadata) {
        this.cachedMetadata = cachedMetadata;
        this.modifiedMetadataCache = false;
    }
}

