/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.dspace.content.Item;
import org.dspace.content.Item_;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.RelationshipType_;
import org.dspace.content.Relationship_;
import org.dspace.content.dao.RelationshipDAO;
import org.dspace.content.dao.pojo.ItemUuidAndRelationshipId;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;

public class RelationshipDAOImpl
extends AbstractHibernateDAO<Relationship>
implements RelationshipDAO {
    @Override
    public List<Relationship> findByItem(Context context, Item item, boolean excludeTilted, boolean excludeNonLatest) throws SQLException {
        return this.findByItem(context, item, -1, -1, excludeTilted, excludeNonLatest);
    }

    @Override
    public List<Relationship> findByItem(Context context, Item item, Integer limit, Integer offset, boolean excludeTilted, boolean excludeNonLatest) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Relationship> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Relationship.class);
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        criteriaQuery.select((Selection)relationshipRoot);
        criteriaQuery.where((Expression)criteriaBuilder.or((Expression)this.getLeftItemPredicate(criteriaBuilder, (Root<Relationship>)relationshipRoot, item, excludeTilted, excludeNonLatest), (Expression)this.getRightItemPredicate(criteriaBuilder, (Root<Relationship>)relationshipRoot, item, excludeTilted, excludeNonLatest)));
        return this.list(context, criteriaQuery, false, Relationship.class, limit, offset);
    }

    protected Predicate getLeftItemPredicate(CriteriaBuilder criteriaBuilder, Root<Relationship> relationshipRoot, Item item, boolean excludeTilted, boolean excludeNonLatest) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.leftItem), (Object)item));
        if (excludeTilted) {
            predicates.add(criteriaBuilder.or((Expression)criteriaBuilder.isNull((Expression)relationshipRoot.get(Relationship_.relationshipType).get(RelationshipType_.tilted)), (Expression)criteriaBuilder.notEqual((Expression)relationshipRoot.get(Relationship_.relationshipType).get(RelationshipType_.tilted), (Object)RelationshipType.Tilted.RIGHT)));
        }
        if (excludeNonLatest) {
            predicates.add(criteriaBuilder.notEqual((Expression)relationshipRoot.get("latestVersionStatus"), (Object)Relationship.LatestVersionStatus.LEFT_ONLY));
        }
        return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
    }

    protected Predicate getRightItemPredicate(CriteriaBuilder criteriaBuilder, Root<Relationship> relationshipRoot, Item item, boolean excludeTilted, boolean excludeNonLatest) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.rightItem), (Object)item));
        if (excludeTilted) {
            predicates.add(criteriaBuilder.or((Expression)criteriaBuilder.isNull((Expression)relationshipRoot.get(Relationship_.relationshipType).get(RelationshipType_.tilted)), (Expression)criteriaBuilder.notEqual((Expression)relationshipRoot.get(Relationship_.relationshipType).get(RelationshipType_.tilted), (Object)RelationshipType.Tilted.LEFT)));
        }
        if (excludeNonLatest) {
            predicates.add(criteriaBuilder.notEqual((Expression)relationshipRoot.get("latestVersionStatus"), (Object)Relationship.LatestVersionStatus.RIGHT_ONLY));
        }
        return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
    }

    @Override
    public int countByItem(Context context, Item item, boolean excludeTilted, boolean excludeNonLatest) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Relationship> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Relationship.class);
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        criteriaQuery.select((Selection)relationshipRoot);
        criteriaQuery.where((Expression)criteriaBuilder.or((Expression)this.getLeftItemPredicate(criteriaBuilder, (Root<Relationship>)relationshipRoot, item, excludeTilted, excludeNonLatest), (Expression)this.getRightItemPredicate(criteriaBuilder, (Root<Relationship>)relationshipRoot, item, excludeTilted, excludeNonLatest)));
        return this.count(context, criteriaQuery, criteriaBuilder, relationshipRoot);
    }

    @Override
    public List<Relationship> findByRelationshipType(Context context, RelationshipType relationshipType) throws SQLException {
        return this.findByRelationshipType(context, relationshipType, -1, -1);
    }

    @Override
    public List<Relationship> findByRelationshipType(Context context, RelationshipType relationshipType, Integer limit, Integer offset) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Relationship> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Relationship.class);
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        criteriaQuery.select((Selection)relationshipRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.relationshipType), (Object)relationshipType));
        return this.list(context, criteriaQuery, true, Relationship.class, limit, offset);
    }

    @Override
    public List<Relationship> findByItemAndRelationshipType(Context context, Item item, RelationshipType relationshipType, Integer limit, Integer offset, boolean excludeNonLatest) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Relationship> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Relationship.class);
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        criteriaQuery.select((Selection)relationshipRoot);
        criteriaQuery.where(new Predicate[]{criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.relationshipType), (Object)relationshipType), criteriaBuilder.or((Expression)this.getLeftItemPredicate(criteriaBuilder, (Root<Relationship>)relationshipRoot, item, false, excludeNonLatest), (Expression)this.getRightItemPredicate(criteriaBuilder, (Root<Relationship>)relationshipRoot, item, false, excludeNonLatest))});
        return this.list(context, criteriaQuery, true, Relationship.class, limit, offset);
    }

    @Override
    public List<Relationship> findByItemAndRelationshipType(Context context, Item item, RelationshipType relationshipType, boolean isLeft, Integer limit, Integer offset, boolean excludeNonLatest) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Relationship> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Relationship.class);
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        criteriaQuery.select((Selection)relationshipRoot);
        if (isLeft) {
            criteriaQuery.where(new Predicate[]{criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.relationshipType), (Object)relationshipType), this.getLeftItemPredicate(criteriaBuilder, (Root<Relationship>)relationshipRoot, item, false, excludeNonLatest)});
            criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)relationshipRoot.get(Relationship_.leftPlace))});
        } else {
            criteriaQuery.where(new Predicate[]{criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.relationshipType), (Object)relationshipType), this.getRightItemPredicate(criteriaBuilder, (Root<Relationship>)relationshipRoot, item, false, excludeNonLatest)});
            criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)relationshipRoot.get(Relationship_.rightPlace))});
        }
        return this.list(context, criteriaQuery, true, Relationship.class, limit, offset);
    }

    @Override
    public List<ItemUuidAndRelationshipId> findByLatestItemAndRelationshipType(Context context, Item latestItem, RelationshipType relationshipType, boolean isLeft) throws SQLException {
        String relationshipIdAlias = "relationshipId";
        String itemUuidAlias = "itemUuid";
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery criteriaQuery = criteriaBuilder.createTupleQuery();
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.relationshipType), (Object)relationshipType));
        if (isLeft) {
            predicates.add(criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.leftItem), (Object)latestItem));
            predicates.add(criteriaBuilder.notEqual((Expression)relationshipRoot.get("latestVersionStatus"), (Object)Relationship.LatestVersionStatus.RIGHT_ONLY));
            criteriaQuery.multiselect(new Selection[]{relationshipRoot.get(Relationship_.id).alias("relationshipId"), relationshipRoot.get(Relationship_.rightItem).get(Item_.id).alias("itemUuid")});
        } else {
            predicates.add(criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.rightItem), (Object)latestItem));
            predicates.add(criteriaBuilder.notEqual((Expression)relationshipRoot.get("latestVersionStatus"), (Object)Relationship.LatestVersionStatus.LEFT_ONLY));
            criteriaQuery.multiselect(new Selection[]{relationshipRoot.get(Relationship_.id).alias("relationshipId"), relationshipRoot.get(Relationship_.leftItem).get(Item_.id).alias("itemUuid")});
        }
        criteriaQuery.where(predicates.toArray(new Predicate[0]));
        criteriaQuery.distinct(true);
        org.hibernate.query.Query query = this.getHibernateSession(context).createQuery(criteriaQuery);
        query.setHint("org.hibernate.cacheable", (Object)true);
        List resultList = query.getResultList();
        return resultList.stream().map(Tuple.class::cast).map(t -> new ItemUuidAndRelationshipId((UUID)t.get("itemUuid"), (Integer)t.get("relationshipId"))).collect(Collectors.toList());
    }

    @Override
    public List<Relationship> findByTypeName(Context context, String typeName) throws SQLException {
        return this.findByTypeName(context, typeName, -1, -1);
    }

    @Override
    public List<Relationship> findByTypeName(Context context, String typeName, Integer limit, Integer offset) throws SQLException {
        RelationshipTypeService relationshipTypeService = ContentServiceFactory.getInstance().getRelationshipTypeService();
        List<RelationshipType> relTypes = relationshipTypeService.findByLeftwardOrRightwardTypeName(context, typeName);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (RelationshipType relationshipType : relTypes) {
            ids.add(relationshipType.getID());
        }
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Relationship> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Relationship.class);
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        criteriaQuery.where((Expression)relationshipRoot.get(Relationship_.relationshipType).in(ids));
        return this.list(context, criteriaQuery, true, Relationship.class, limit, offset);
    }

    @Override
    public int countByRelationshipType(Context context, RelationshipType relationshipType) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Relationship> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Relationship.class);
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        criteriaQuery.select((Selection)relationshipRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.relationshipType), (Object)relationshipType));
        return this.count(context, criteriaQuery, criteriaBuilder, relationshipRoot);
    }

    @Override
    public int countRows(Context context) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Relationship> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Relationship.class);
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        criteriaQuery.select((Selection)relationshipRoot);
        return this.count(context, criteriaQuery, criteriaBuilder, relationshipRoot);
    }

    @Override
    public int countByItemAndRelationshipType(Context context, Item item, RelationshipType relationshipType, boolean isLeft, boolean excludeNonLatest) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Relationship> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Relationship.class);
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        criteriaQuery.select((Selection)relationshipRoot);
        if (isLeft) {
            criteriaQuery.where(new Predicate[]{criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.relationshipType), (Object)relationshipType), this.getLeftItemPredicate(criteriaBuilder, (Root<Relationship>)relationshipRoot, item, false, excludeNonLatest)});
        } else {
            criteriaQuery.where(new Predicate[]{criteriaBuilder.equal((Expression)relationshipRoot.get(Relationship_.relationshipType), (Object)relationshipType), this.getRightItemPredicate(criteriaBuilder, (Root<Relationship>)relationshipRoot, item, false, excludeNonLatest)});
        }
        return this.count(context, criteriaQuery, criteriaBuilder, relationshipRoot);
    }

    @Override
    public int countByTypeName(Context context, String typeName) throws SQLException {
        RelationshipTypeService relationshipTypeService = ContentServiceFactory.getInstance().getRelationshipTypeService();
        List<RelationshipType> relTypes = relationshipTypeService.findByLeftwardOrRightwardTypeName(context, typeName);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (RelationshipType relationshipType : relTypes) {
            ids.add(relationshipType.getID());
        }
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<Relationship> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, Relationship.class);
        Root relationshipRoot = criteriaQuery.from(Relationship.class);
        criteriaQuery.where((Expression)relationshipRoot.get(Relationship_.relationshipType).in(ids));
        return this.count(context, criteriaQuery, criteriaBuilder, relationshipRoot);
    }

    @Override
    public List<Relationship> findByItemAndRelationshipTypeAndList(Context context, UUID focusUUID, RelationshipType relationshipType, List<UUID> items, boolean isLeft, int offset, int limit) throws SQLException {
        String side = isLeft ? "left_id" : "right_id";
        String otherSide = !isLeft ? "left_id" : "right_id";
        Query query = this.createQuery(context, "FROM " + Relationship.class.getSimpleName() + " WHERE type_id = (:typeId) AND " + side + " = (:focusUUID) AND " + otherSide + " in (:list) ORDER BY id");
        query.setParameter("typeId", (Object)relationshipType.getID());
        query.setParameter("focusUUID", (Object)focusUUID);
        query.setParameter("list", items);
        return this.list(query, limit, offset);
    }

    @Override
    public int countByItemAndRelationshipTypeAndList(Context context, UUID focusUUID, RelationshipType relationshipType, List<UUID> items, boolean isLeft) throws SQLException {
        String side = isLeft ? "left_id" : "right_id";
        String otherSide = !isLeft ? "left_id" : "right_id";
        Query query = this.createQuery(context, "SELECT count(*) FROM " + Relationship.class.getSimpleName() + " WHERE type_id = (:typeId) AND " + side + " = (:focusUUID) AND " + otherSide + " in (:list)");
        query.setParameter("typeId", (Object)relationshipType.getID());
        query.setParameter("focusUUID", (Object)focusUUID);
        query.setParameter("list", items);
        return this.count(query);
    }
}

