/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ContextReadOnlyCache;
import org.dspace.core.DBConnection;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogHelper;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.event.Dispatcher;
import org.dspace.event.Event;
import org.dspace.event.factory.EventServiceFactory;
import org.dspace.event.service.EventService;
import org.dspace.storage.rdbms.DatabaseConfigVO;
import org.dspace.storage.rdbms.DatabaseUtils;
import org.dspace.utils.DSpace;
import org.springframework.util.CollectionUtils;

public class Context
implements AutoCloseable {
    private static final Logger log = LogManager.getLogger(Context.class);
    protected static final AtomicBoolean databaseUpdated = new AtomicBoolean(false);
    private EPerson currentUser;
    private EPerson currentUserPreviousState;
    private Locale currentLocale;
    private String extraLogInfo;
    private boolean ignoreAuth;
    private Deque<Boolean> authStateChangeHistory;
    private Deque<String> authStateClassCallHistory;
    private Set<UUID> specialGroups;
    private Set<UUID> specialGroupsPreviousState;
    private String authenticationMethod;
    private LinkedList<Event> events = null;
    private String dispName = null;
    private Mode mode;
    private final ContextReadOnlyCache readOnlyCache = new ContextReadOnlyCache();
    protected EventService eventService;
    private DBConnection dbConnection;

    protected Context(EventService eventService, DBConnection dbConnection) {
        this.eventService = eventService;
        this.dbConnection = dbConnection;
        this.init();
    }

    public Context() {
        this.init();
    }

    public Context(Mode mode) {
        this.mode = mode;
        this.init();
    }

    protected void init() {
        Context.updateDatabase();
        if (this.eventService == null) {
            this.eventService = EventServiceFactory.getInstance().getEventService();
        }
        if (this.dbConnection == null) {
            this.dbConnection = (DBConnection)new DSpace().getServiceManager().getServiceByName(null, DBConnection.class);
            if (this.dbConnection == null) {
                log.fatal("Cannot obtain the bean which provides a database connection. Check previous entries in the dspace.log to find why the db failed to initialize.");
            }
        }
        this.currentUser = null;
        this.currentLocale = I18nUtil.getDefaultLocale();
        this.extraLogInfo = "";
        this.ignoreAuth = false;
        this.specialGroups = new HashSet<UUID>();
        this.authStateChangeHistory = new ConcurrentLinkedDeque<Boolean>();
        this.authStateClassCallHistory = new ConcurrentLinkedDeque<String>();
        if (this.mode != null) {
            this.setMode(this.mode);
        }
    }

    public static synchronized boolean updateDatabase() {
        if (databaseUpdated.compareAndSet(false, true)) {
            try {
                DatabaseUtils.updateDatabase();
            }
            catch (SQLException sqle) {
                log.fatal("Cannot update or initialize database via Flyway!", (Throwable)sqle);
                databaseUpdated.set(false);
            }
        }
        return databaseUpdated.get();
    }

    DBConnection getDBConnection() {
        return this.dbConnection;
    }

    public DatabaseConfigVO getDBConfig() throws SQLException {
        return this.dbConnection.getDatabaseConfig();
    }

    public String getDbType() {
        return this.dbConnection.getType();
    }

    public void setCurrentUser(EPerson user) {
        this.currentUser = user;
    }

    public EPerson getCurrentUser() {
        return this.currentUser;
    }

    public Locale getCurrentLocale() {
        return this.currentLocale;
    }

    public void setCurrentLocale(Locale locale) {
        this.currentLocale = locale;
    }

    public boolean ignoreAuthorization() {
        return this.ignoreAuth;
    }

    public void turnOffAuthorisationSystem() {
        this.authStateChangeHistory.push(this.ignoreAuth);
        if (log.isDebugEnabled()) {
            Thread currThread = Thread.currentThread();
            StackTraceElement[] stackTrace = currThread.getStackTrace();
            String caller = stackTrace[stackTrace.length - 1].getClassName();
            this.authStateClassCallHistory.push(caller);
        }
        this.ignoreAuth = true;
    }

    public void restoreAuthSystemState() {
        Boolean previousState;
        try {
            previousState = this.authStateChangeHistory.pop();
        }
        catch (NoSuchElementException ex) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = ex::getLocalizedMessage;
            log.warn(LogHelper.getHeader(this, "restore_auth_sys_state", "not previous state info available:  {}"), supplierArray);
            previousState = Boolean.FALSE;
        }
        if (log.isDebugEnabled()) {
            String previousCaller;
            Thread currThread = Thread.currentThread();
            StackTraceElement[] stackTrace = currThread.getStackTrace();
            String caller = stackTrace[stackTrace.length - 1].getClassName();
            try {
                previousCaller = this.authStateClassCallHistory.pop();
            }
            catch (NoSuchElementException ex) {
                previousCaller = "none";
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = ex::getLocalizedMessage;
                log.warn(LogHelper.getHeader(this, "restore_auth_sys_state", "no previous caller info available:  {}"), supplierArray);
            }
            if (!previousCaller.equals(caller)) {
                log.warn(LogHelper.getHeader(this, "restore_auth_sys_state", "Class: " + caller + " call restore but previous state change made by " + previousCaller));
            }
        }
        this.ignoreAuth = previousState;
    }

    public void setExtraLogInfo(String info) {
        this.extraLogInfo = info;
    }

    public String getExtraLogInfo() {
        return this.extraLogInfo;
    }

    public void complete() throws SQLException {
        if (!this.isValid()) {
            log.info("complete() was called on a closed Context object. No changes to commit.");
            return;
        }
        try {
            if (!this.isReadOnly()) {
                this.commit();
            }
        }
        finally {
            if (this.dbConnection != null) {
                this.dbConnection.closeDBConnection();
                this.dbConnection = null;
            }
        }
    }

    public void commit() throws SQLException {
        if (!this.isValid()) {
            log.info("commit() was called on a closed Context object. No changes to commit.");
            return;
        }
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("You cannot commit a read-only context");
        }
        try {
            this.dispatchEvents();
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("Cache size on commit is " + this.getCacheSize());
            }
            if (this.dbConnection != null) {
                this.dbConnection.commit();
                this.reloadContextBoundEntities();
            }
        }
    }

    public void dispatchEvents() {
        Dispatcher dispatcher = null;
        try {
            if (this.events != null) {
                if (this.dispName == null) {
                    this.dispName = "default";
                }
                dispatcher = this.eventService.getDispatcher(this.dispName);
                dispatcher.dispatch(this);
            }
        }
        finally {
            this.events = null;
            if (dispatcher != null) {
                this.eventService.returnDispatcher(this.dispName, dispatcher);
            }
        }
    }

    public void setDispatcher(String dispatcher) {
        if (log.isDebugEnabled()) {
            log.debug(this.toString() + ": setDispatcher(\"" + dispatcher + "\")");
        }
        this.dispName = dispatcher;
    }

    public void addEvent(Event event) {
        if (this.isReadOnly()) {
            throw new IllegalStateException("Attempt to mutate object in read-only context");
        }
        if (this.events == null) {
            this.events = new LinkedList();
        }
        this.events.add(event);
    }

    public LinkedList<Event> getEvents() {
        return this.events;
    }

    public boolean hasEvents() {
        return !CollectionUtils.isEmpty(this.events);
    }

    public Event pollEvent() {
        if (this.hasEvents()) {
            return this.events.poll();
        }
        return null;
    }

    public void rollback() throws SQLException {
        if (!this.isValid()) {
            log.info("rollback() was called on a closed Context object. No changes to abort.");
            return;
        }
        try {
            if (!this.isReadOnly() && this.isTransactionAlive()) {
                this.dbConnection.rollback();
                this.reloadContextBoundEntities();
            }
        }
        finally {
            this.events = null;
        }
    }

    public void abort() {
        if (!this.isValid()) {
            log.info("abort() was called on a closed Context object. No changes to abort.");
            return;
        }
        try {
            if (!this.isReadOnly() && this.isTransactionAlive()) {
                this.dbConnection.rollback();
            }
        }
        catch (SQLException se) {
            log.error("Error rolling back transaction during an abort()", (Throwable)se);
        }
        finally {
            try {
                if (this.dbConnection != null) {
                    this.dbConnection.closeDBConnection();
                    this.dbConnection = null;
                }
            }
            catch (Exception ex) {
                log.error("Error closing the database connection", (Throwable)ex);
            }
            this.events = null;
        }
    }

    @Override
    public void close() {
        if (this.isValid()) {
            this.abort();
        }
    }

    public boolean isValid() {
        return this.dbConnection != null && this.dbConnection.isSessionAlive();
    }

    protected boolean isTransactionAlive() {
        return this.isValid() && this.dbConnection.isTransActionAlive();
    }

    public boolean isReadOnly() {
        return this.mode != null && this.mode == Mode.READ_ONLY;
    }

    public void setSpecialGroup(UUID groupID) {
        this.specialGroups.add(groupID);
    }

    public boolean inSpecialGroup(UUID groupID) {
        return this.specialGroups.contains(groupID);
    }

    public List<Group> getSpecialGroups() throws SQLException {
        ArrayList<Group> myGroups = new ArrayList<Group>();
        for (UUID groupId : this.specialGroups) {
            myGroups.add((Group)EPersonServiceFactory.getInstance().getGroupService().find(this, groupId));
        }
        return myGroups;
    }

    public Set<UUID> getSpecialGroupUuids() {
        return CollectionUtils.isEmpty(this.specialGroups) ? Set.of() : this.specialGroups;
    }

    public void switchContextUser(EPerson newUser) {
        if (this.currentUserPreviousState != null) {
            throw new IllegalStateException("A previous user is already set, you can only switch back and foreward one time");
        }
        this.currentUserPreviousState = this.currentUser;
        this.specialGroupsPreviousState = this.specialGroups;
        this.specialGroups = new HashSet<UUID>();
        this.currentUser = newUser;
    }

    public void restoreContextUser() {
        if (this.specialGroupsPreviousState == null) {
            throw new IllegalStateException("No previous state found");
        }
        this.currentUser = this.currentUserPreviousState;
        this.specialGroups = this.specialGroupsPreviousState;
        this.specialGroupsPreviousState = null;
        this.currentUserPreviousState = null;
    }

    protected void finalize() throws Throwable {
        if (this.dbConnection != null && this.dbConnection.isTransActionAlive()) {
            this.abort();
        }
        super.finalize();
    }

    public void shutDownDatabase() throws SQLException {
        this.dbConnection.shutdown();
    }

    public long getCacheSize() throws SQLException {
        return this.getDBConnection().getCacheSize();
    }

    public void setMode(Mode newMode) {
        try {
            switch (newMode) {
                case BATCH_EDIT: {
                    this.dbConnection.setConnectionMode(true, false);
                    break;
                }
                case READ_ONLY: {
                    this.dbConnection.setConnectionMode(false, true);
                    break;
                }
                case READ_WRITE: {
                    this.dbConnection.setConnectionMode(false, false);
                    break;
                }
                default: {
                    log.warn("New context mode detected that has not been configured.");
                    break;
                }
            }
        }
        catch (SQLException ex) {
            log.warn("Unable to set database connection mode", (Throwable)ex);
        }
        if (this.mode != Mode.READ_ONLY || newMode != Mode.READ_ONLY) {
            this.readOnlyCache.clear();
        }
        this.mode = newMode;
    }

    public Mode getCurrentMode() {
        return this.mode != null ? this.mode : Mode.READ_WRITE;
    }

    @Deprecated
    public void enableBatchMode(boolean batchModeEnabled) throws SQLException {
        if (batchModeEnabled) {
            this.setMode(Mode.BATCH_EDIT);
        } else {
            this.setMode(Mode.READ_WRITE);
        }
    }

    @Deprecated
    public boolean isBatchModeEnabled() {
        return this.mode != null && this.mode == Mode.BATCH_EDIT;
    }

    public <E extends ReloadableEntity> E reloadEntity(E entity) throws SQLException {
        return this.dbConnection.reloadEntity(entity);
    }

    public <E extends ReloadableEntity> void uncacheEntity(E entity) throws SQLException {
        this.dbConnection.uncacheEntity(entity);
    }

    public Boolean getCachedAuthorizationResult(DSpaceObject dspaceObject, int action, EPerson eperson) {
        if (this.isReadOnly()) {
            return this.readOnlyCache.getCachedAuthorizationResult(dspaceObject, action, eperson);
        }
        return null;
    }

    public void cacheAuthorizedAction(DSpaceObject dspaceObject, int action, EPerson eperson, Boolean result, ResourcePolicy rp) {
        if (this.isReadOnly()) {
            this.readOnlyCache.cacheAuthorizedAction(dspaceObject, action, eperson, result);
            try {
                this.uncacheEntity(rp);
            }
            catch (SQLException e) {
                log.warn("Unable to uncache a resource policy when in read-only mode", (Throwable)e);
            }
        }
    }

    public Boolean getCachedGroupMembership(Group group, EPerson eperson) {
        if (this.isReadOnly()) {
            return this.readOnlyCache.getCachedGroupMembership(group, eperson);
        }
        return null;
    }

    public void cacheGroupMembership(Group group, EPerson eperson, Boolean isMember) {
        if (this.isReadOnly()) {
            this.readOnlyCache.cacheGroupMembership(group, eperson, isMember);
        }
    }

    public void cacheAllMemberGroupsSet(EPerson ePerson, Set<Group> groups) {
        if (this.isReadOnly()) {
            this.readOnlyCache.cacheAllMemberGroupsSet(ePerson, groups);
        }
    }

    public Set<Group> getCachedAllMemberGroupsSet(EPerson ePerson) {
        if (this.isReadOnly()) {
            return this.readOnlyCache.getCachedAllMemberGroupsSet(ePerson);
        }
        return null;
    }

    private void reloadContextBoundEntities() throws SQLException {
        this.currentUser = this.reloadEntity(this.currentUser);
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public static enum Mode {
        READ_ONLY,
        READ_WRITE,
        BATCH_EDIT;

    }
}

