/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class I18nUtil {
    private static final Logger log = LogManager.getLogger(I18nUtil.class);
    private static final String LOCALE_DELIMITERS = " _.";

    private I18nUtil() {
    }

    public static Locale getDefaultLocale() {
        ConfigurationService config = DSpaceServicesFactory.getInstance().getConfigurationService();
        Locale defaultLocale = null;
        if (config.hasProperty("default.locale")) {
            defaultLocale = I18nUtil.makeLocale(config.getProperty("default.locale"));
        }
        if (defaultLocale == null) {
            defaultLocale = Locale.getDefault();
        }
        return defaultLocale;
    }

    private static Locale makeLocale(String localeSpec) {
        StringTokenizer st = new StringTokenizer(localeSpec, LOCALE_DELIMITERS);
        int countTokens = st.countTokens();
        switch (countTokens) {
            case 1: {
                return new Locale(st.nextToken().trim());
            }
            case 2: {
                return new Locale(st.nextToken().trim(), st.nextToken().trim());
            }
            case 3: {
                return new Locale(st.nextToken().trim(), st.nextToken().trim(), st.nextToken().trim());
            }
        }
        return null;
    }

    public static Locale getEPersonLocale(EPerson ep) {
        if (ep == null) {
            log.error("No EPerson specified, returning default locale");
            return I18nUtil.getDefaultLocale();
        }
        String lang = ep.getLanguage();
        if (StringUtils.isBlank((CharSequence)lang)) {
            log.error("No language specified for EPerson " + ep.getID());
            return I18nUtil.getDefaultLocale();
        }
        return I18nUtil.getSupportedLocale(new Locale(lang));
    }

    public static Locale[] getSupportedLocales() {
        ConfigurationService config = DSpaceServicesFactory.getInstance().getConfigurationService();
        String[] locales = config.getArrayProperty("webui.supported.locales");
        if (locales != null && locales.length > 0) {
            return I18nUtil.parseLocales(locales);
        }
        Locale[] availableLocales = new Locale[]{I18nUtil.getDefaultLocale()};
        return availableLocales;
    }

    public static Locale getSupportedLocale(Locale locale) {
        Locale[] availableLocales = I18nUtil.getSupportedLocales();
        boolean isSupported = false;
        Locale supportedLocale = null;
        Object testLocale = "";
        if (availableLocales == null) {
            supportedLocale = I18nUtil.getDefaultLocale();
        } else {
            int i;
            if (!locale.getVariant().equals("")) {
                testLocale = locale.toString();
                for (i = 0; i < availableLocales.length; ++i) {
                    if (!((String)testLocale).equalsIgnoreCase(availableLocales[i].toString())) continue;
                    isSupported = true;
                    supportedLocale = availableLocales[i];
                }
            }
            if (!isSupported || !locale.getCountry().equals("")) {
                testLocale = locale.getLanguage() + "_" + locale.getCountry();
                for (i = 0; i < availableLocales.length; ++i) {
                    if (!((String)testLocale).equalsIgnoreCase(availableLocales[i].toString())) continue;
                    isSupported = true;
                    supportedLocale = availableLocales[i];
                }
            }
            if (!isSupported) {
                testLocale = locale.getLanguage();
                for (i = 0; i < availableLocales.length; ++i) {
                    if (!((String)testLocale).equalsIgnoreCase(availableLocales[i].toString())) continue;
                    isSupported = true;
                    supportedLocale = availableLocales[i];
                }
            }
            if (!isSupported) {
                supportedLocale = I18nUtil.getDefaultLocale();
            }
        }
        return supportedLocale;
    }

    public static Locale getSupportedLocale(String locale) {
        Locale currentLocale = null;
        currentLocale = locale != null ? I18nUtil.getSupportedLocale(new Locale(locale)) : I18nUtil.getDefaultLocale();
        return currentLocale;
    }

    public static String getInputFormsFileName(Locale locale) {
        String FORM_DEF_FILE = "submission-forms";
        String FILE_TYPE = ".xml";
        String defsFilename = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("dspace.dir") + File.separator + "config" + File.separator + "submission-forms";
        String fileName = I18nUtil.getFilename(locale, defsFilename, ".xml");
        return fileName;
    }

    public static String getMessage(String key) {
        return I18nUtil.getMessage(key.trim(), I18nUtil.getDefaultLocale());
    }

    public static String getMessage(String key, Locale locale) {
        if (locale == null) {
            locale = I18nUtil.getDefaultLocale();
        }
        ResourceBundle.Control control = ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT);
        ResourceBundle messages = ResourceBundle.getBundle("Messages", locale, control);
        try {
            String message = messages.getString(key.trim());
            return message;
        }
        catch (MissingResourceException e) {
            log.error("'" + key + "' translation undefined in locale '" + locale.toString() + "'");
            return key;
        }
    }

    public static String getMessage(String key, Context c) {
        return I18nUtil.getMessage(key.trim(), c.getCurrentLocale());
    }

    public static String getDefaultLicense(Context context) {
        Locale locale = context.getCurrentLocale();
        String DEF_LIC_FILE = "default";
        String FILE_TYPE = ".license";
        String defsFilename = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("dspace.dir") + File.separator + "config" + File.separator + "default";
        String fileName = I18nUtil.getFilename(locale, defsFilename, ".license");
        return fileName;
    }

    private static String getFilename(Locale locale, String fileName, String fileType) {
        File fileTmp;
        String localizedFileName = null;
        boolean fileFound = false;
        String fileNameLCV = null;
        String fileNameLC = null;
        String fileNameL = fileName + "_" + locale.getLanguage();
        if (fileType == null) {
            fileType = "";
        }
        if (!locale.getCountry().isEmpty()) {
            fileNameLC = fileName + "_" + locale.getLanguage() + "_" + locale.getCountry();
            if (!locale.getVariant().isEmpty()) {
                fileNameLCV = fileName + "_" + locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant();
            }
        }
        if (fileNameLCV != null && !fileFound && (fileTmp = new File(fileNameLCV + fileType)).exists()) {
            fileFound = true;
            localizedFileName = fileNameLCV + fileType;
        }
        if (fileNameLC != null && !fileFound && (fileTmp = new File(fileNameLC + fileType)).exists()) {
            fileFound = true;
            localizedFileName = fileNameLC + fileType;
        }
        if (fileNameL != null && !fileFound && (fileTmp = new File(fileNameL + fileType)).exists()) {
            fileFound = true;
            localizedFileName = fileNameL + fileType;
        }
        if (!fileFound) {
            localizedFileName = fileName + fileType;
        }
        return localizedFileName;
    }

    public static String getEmailFilename(Locale locale, String name) {
        String templateFile = DSpaceServicesFactory.getInstance().getConfigurationService().getProperty("dspace.dir") + File.separator + "config" + File.separator + "emails" + File.separator + name;
        String templateName = I18nUtil.getFilename(locale, templateFile, "");
        return templateName;
    }

    public static Locale[] parseLocales(String[] locales) {
        ArrayList<Locale> resultList = new ArrayList<Locale>();
        for (String ls : locales) {
            Locale lc = I18nUtil.makeLocale(ls);
            if (lc == null) continue;
            resultList.add(lc);
        }
        return resultList.toArray(new Locale[resultList.size()]);
    }

    public static boolean isSupportedLocale(Locale locale) {
        boolean isSupported = false;
        Locale[] supportedLocales = I18nUtil.getSupportedLocales();
        if (supportedLocales != null) {
            for (Locale sLocale : supportedLocales) {
                if (!locale.getLanguage().equals(sLocale.getLanguage())) continue;
                isSupported = true;
                break;
            }
        }
        return isSupported;
    }
}

