/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.dspace.content.DSpaceObject;
import org.dspace.content.DSpaceObjectLegacySupport;
import org.dspace.content.WorkspaceItem;
import org.dspace.eperson.EPerson;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.proxy.HibernateProxyHelper;

@Entity
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, include="non-lazy")
@Table(name="epersongroup")
public class Group
extends DSpaceObject
implements DSpaceObjectLegacySupport {
    @Transient
    public static final String ANONYMOUS = "Anonymous";
    @Transient
    public static final String ADMIN = "Administrator";
    @Column(name="eperson_group_id", insertable=false, updatable=false)
    private Integer legacyId;
    @Column
    private Boolean permanent = false;
    @Column(length=250, unique=true)
    private String name;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="epersongroup2eperson", joinColumns={@JoinColumn(name="eperson_group_id")}, inverseJoinColumns={@JoinColumn(name="eperson_id")})
    private final List<EPerson> epeople = new ArrayList<EPerson>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="group2group", joinColumns={@JoinColumn(name="parent_id")}, inverseJoinColumns={@JoinColumn(name="child_id")})
    private final List<Group> groups = new ArrayList<Group>();
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="groups")
    private final List<Group> parentGroups = new ArrayList<Group>();
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="supervisorGroups")
    private final List<WorkspaceItem> supervisedItems = new ArrayList<WorkspaceItem>();
    @Transient
    private boolean groupsChanged;

    protected Group() {
    }

    void addMember(EPerson e) {
        this.getMembers().add(e);
    }

    public List<EPerson> getMembers() {
        return this.epeople;
    }

    void addMember(Group g) {
        this.getMemberGroups().add(g);
        this.groupsChanged = true;
    }

    void addParentGroup(Group group) {
        this.getParentGroups().add(group);
        this.groupsChanged = true;
    }

    void removeParentGroup(Group group) {
        this.getParentGroups().remove(group);
        this.groupsChanged = true;
    }

    boolean remove(EPerson e) {
        return this.getMembers().remove(e);
    }

    boolean remove(Group g) {
        this.groupsChanged = true;
        return this.getMemberGroups().remove(g);
    }

    boolean contains(Group g) {
        return this.getMemberGroups().contains(g);
    }

    boolean contains(EPerson e) {
        return this.getMembers().contains(e);
    }

    List<Group> getParentGroups() {
        return this.parentGroups;
    }

    public List<Group> getMemberGroups() {
        return this.groups;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Class objClass = HibernateProxyHelper.getClassWithoutInitializingProxy((Object)obj);
        if (this.getClass() != objClass) {
            return false;
        }
        Group other = (Group)obj;
        return this.getID().equals(other.getID());
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + this.getID().hashCode();
        hash = 59 * hash + (this.getName() != null ? this.getName().hashCode() : 0);
        return hash;
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void setName(String name) throws SQLException {
        if (!StringUtils.equals((CharSequence)this.name, (CharSequence)name) && !this.isPermanent().booleanValue()) {
            this.name = name;
            this.setMetadataModified();
        }
    }

    public boolean isGroupsChanged() {
        return this.groupsChanged;
    }

    public void clearGroupsChanged() {
        this.groupsChanged = false;
    }

    @Override
    public Integer getLegacyId() {
        return this.legacyId;
    }

    public List<WorkspaceItem> getSupervisedItems() {
        return this.supervisedItems;
    }

    public Boolean isPermanent() {
        return this.permanent;
    }

    void setPermanent(boolean permanence) {
        this.permanent = permanence;
        this.setModified();
    }
}

