/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.google;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUtils;
import org.apache.commons.collections.buffer.CircularFifoBuffer;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Context;
import org.dspace.google.GoogleAnalyticsEvent;
import org.dspace.service.ClientInfoService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.model.Event;
import org.dspace.usage.AbstractUsageEventListener;
import org.dspace.usage.UsageEvent;
import org.springframework.beans.factory.annotation.Autowired;

public class GoogleAsyncEventListener
extends AbstractUsageEventListener {
    private static final int MAX_TIME_SINCE_EVENT = 14400000;
    private static final int GA_MAX_EVENTS = 20;
    private static final String ANALYTICS_BATCH_ENDPOINT = "https://www.google-analytics.com/batch";
    private static final Logger log = LogManager.getLogger();
    private static String analyticsKey;
    private static CloseableHttpClient httpclient;
    private static Buffer buffer;
    private static ExecutorService executor;
    private static Future future;
    private static boolean destroyed;
    @Autowired(required=true)
    ConfigurationService configurationService;
    @Autowired(required=true)
    ClientInfoService clientInfoService;

    @PostConstruct
    public void init() {
        analyticsKey = this.configurationService.getProperty("google.analytics.key");
        if (StringUtils.isNotEmpty((String)analyticsKey)) {
            int analyticsBufferlimit = this.configurationService.getIntProperty("google.analytics.buffer.limit", 256);
            buffer = BufferUtils.synchronizedBuffer((Buffer)new CircularFifoBuffer(analyticsBufferlimit));
            httpclient = HttpClients.createDefault();
            executor = Executors.newSingleThreadExecutor();
            future = executor.submit(new GoogleAnalyticsTask());
        }
    }

    public void receiveEvent(Event event) {
        if (event instanceof UsageEvent && StringUtils.isNotEmpty((String)analyticsKey)) {
            UsageEvent ue = (UsageEvent)event;
            log.debug("Usage event received " + event.getName());
            try {
                if (ue.getAction() == UsageEvent.Action.VIEW && ue.getObject().getType() == 0) {
                    String cid = ue.getRequest().getHeader("X-CORRELATION-ID") != null ? ue.getRequest().getHeader("X-CORRELATION-ID") : (ue.getRequest().getSession(false) != null ? ue.getRequest().getSession().getId() : UUID.randomUUID().toString());
                    String referrer = ue.getRequest().getHeader("X-REFERRER") != null ? ue.getRequest().getHeader("X-REFERRER") : ue.getRequest().getHeader("referer");
                    buffer.add((Object)new GoogleAnalyticsEvent(cid, this.clientInfoService.getClientIp(ue.getRequest()), ue.getRequest().getHeader("USER-AGENT"), referrer, ue.getRequest().getRequestURI() + "?" + ue.getRequest().getQueryString(), this.getObjectName(ue), System.currentTimeMillis()));
                }
            }
            catch (Exception e) {
                log.error("Failed to add event to buffer", (Throwable)e);
                log.error("Event information: " + ue);
                Context context = ue.getContext();
                if (context != null) {
                    log.error("Context information:");
                    log.error("    Current User: " + context.getCurrentUser());
                    log.error("    Extra log info: " + context.getExtraLogInfo());
                    if (context.getEvents() != null && !context.getEvents().isEmpty()) {
                        for (int x = 1; x <= context.getEvents().size(); ++x) {
                            log.error("    Context Event " + x + ": " + context.getEvents().get(x));
                        }
                    }
                }
                log.error("UsageEvent has no Context object");
            }
        }
    }

    private String getObjectName(UsageEvent ue) {
        try {
            if (ue.getObject().getType() == 0) {
                return ContentServiceFactory.getInstance().getDSpaceObjectService(ue.getObject()).getParentObject(ue.getContext(), ue.getObject()).getName();
            }
            return ue.getObject().getName();
        }
        catch (SQLException e) {
            log.error("Error in Google Analytics recording - can't determine ParentObjectName for bitstream " + ue.getObject().getID(), (Throwable)e);
            return null;
        }
    }

    @PreDestroy
    public void destroy() throws InterruptedException {
        destroyed = true;
        if (StringUtils.isNotEmpty((String)analyticsKey)) {
            future.cancel(true);
            executor.shutdown();
            executor.awaitTermination(1L, TimeUnit.SECONDS);
        }
    }

    static {
        destroyed = false;
    }

    private static class GoogleAnalyticsTask
    implements Runnable {
        private GoogleAnalyticsTask() {
        }

        @Override
        public void run() {
            while (!destroyed) {
                try {
                    boolean sleep = false;
                    StringBuilder request = null;
                    ArrayList<GoogleAnalyticsEvent> events = new ArrayList<GoogleAnalyticsEvent>();
                    Iterator iterator = buffer.iterator();
                    for (int x = 0; x < 20 && iterator.hasNext(); ++x) {
                        GoogleAnalyticsEvent event = (GoogleAnalyticsEvent)iterator.next();
                        events.add(event);
                        if (System.currentTimeMillis() - event.getTime() >= 14400000L) continue;
                        String download = "v=1&tid=" + analyticsKey + "&cid=" + event.getCid() + "&t=event&uip=" + URLEncoder.encode(event.getUip(), "UTF-8") + "&ua=" + URLEncoder.encode(event.getUa(), "UTF-8") + "&dr=" + URLEncoder.encode(event.getDr(), "UTF-8") + "&dp=" + URLEncoder.encode(event.getDp(), "UTF-8") + "&dt=" + URLEncoder.encode(event.getDt(), "UTF-8") + "&qt=" + (System.currentTimeMillis() - event.getTime()) + "&ec=bitstream&ea=download&el=item";
                        if (request == null) {
                            request = new StringBuilder(download);
                            continue;
                        }
                        request.append("\n").append(download);
                    }
                    if (request != null) {
                        HttpPost httpPost = new HttpPost(GoogleAsyncEventListener.ANALYTICS_BATCH_ENDPOINT);
                        httpPost.setEntity((HttpEntity)new StringEntity(request.toString()));
                        try (CloseableHttpResponse response2 = httpclient.execute((HttpUriRequest)httpPost);){
                            log.debug("Google Analytics response is " + response2.getStatusLine());
                            buffer.removeAll(events);
                        }
                        catch (IOException e) {
                            log.error("GA post failed", (Throwable)e);
                        }
                    } else {
                        sleep = true;
                    }
                    if (!sleep) continue;
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException e) {
                        log.debug("Interrupted; checking if we should stop");
                    }
                }
                catch (Throwable t) {
                    log.error("Unexpected error; aborting GA event recording", t);
                    Throwables.propagate((Throwable)t);
                }
            }
            log.info("Stopping GA event recording");
        }
    }
}

