/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Context;
import org.dspace.handle.service.HandleService;
import org.dspace.identifier.Identifier;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.IdentifierNotApplicableException;
import org.dspace.identifier.IdentifierNotFoundException;
import org.dspace.identifier.IdentifierNotResolvableException;
import org.dspace.identifier.IdentifierProvider;
import org.dspace.identifier.service.IdentifierService;
import org.springframework.beans.factory.annotation.Autowired;

public class IdentifierServiceImpl
implements IdentifierService {
    private List<IdentifierProvider> providers;
    private static final Logger log = LogManager.getLogger(IdentifierServiceImpl.class);
    @Autowired(required=true)
    protected ContentServiceFactory contentServiceFactory;
    @Autowired(required=true)
    protected HandleService handleService;

    protected IdentifierServiceImpl() {
    }

    @Autowired(required=true)
    public void setProviders(List<IdentifierProvider> providers) {
        this.providers = providers;
        for (IdentifierProvider p : providers) {
            p.setParentService(this);
        }
    }

    @Override
    public void reserve(Context context, DSpaceObject dso) throws AuthorizeException, SQLException, IdentifierException {
        for (IdentifierProvider service : this.providers) {
            try {
                String identifier = service.mint(context, dso);
                if (StringUtils.isEmpty((CharSequence)identifier)) continue;
                service.reserve(context, dso, identifier);
            }
            catch (IdentifierNotApplicableException e) {
                log.warn("Identifier not reserved (inapplicable): " + e.getMessage());
            }
        }
        this.contentServiceFactory.getDSpaceObjectService(dso).update(context, dso);
    }

    @Override
    public void reserve(Context context, DSpaceObject dso, String identifier) throws AuthorizeException, SQLException, IdentifierException {
        for (IdentifierProvider service : this.providers) {
            if (!service.supports(identifier)) continue;
            try {
                service.reserve(context, dso, identifier);
            }
            catch (IdentifierNotApplicableException e) {
                log.warn("Identifier not reserved (inapplicable): " + e.getMessage());
            }
        }
        this.contentServiceFactory.getDSpaceObjectService(dso).update(context, dso);
    }

    @Override
    public void register(Context context, DSpaceObject dso) throws AuthorizeException, SQLException, IdentifierException {
        for (IdentifierProvider service : this.providers) {
            try {
                service.register(context, dso);
            }
            catch (IdentifierNotApplicableException e) {
                log.warn("Identifier not registered (inapplicable): " + e.getMessage());
            }
        }
        this.contentServiceFactory.getDSpaceObjectService(dso).update(context, dso);
    }

    @Override
    public void register(Context context, DSpaceObject object, String identifier) throws AuthorizeException, SQLException, IdentifierException {
        boolean registered = false;
        for (IdentifierProvider service : this.providers) {
            if (!service.supports(identifier)) continue;
            try {
                service.register(context, object, identifier);
                registered = true;
            }
            catch (IdentifierNotApplicableException e) {
                log.warn("Identifier not registered (inapplicable): " + e.getMessage());
            }
        }
        if (!registered) {
            throw new IdentifierException("Cannot register identifier: Didn't find a provider that supports this identifier.");
        }
        this.contentServiceFactory.getDSpaceObjectService(object).update(context, object);
    }

    @Override
    public String lookup(Context context, DSpaceObject dso, Class<? extends Identifier> identifier) {
        for (IdentifierProvider service : this.providers) {
            if (!service.supports(identifier)) continue;
            try {
                String result = service.lookup(context, dso);
                if (result == null) continue;
                return result;
            }
            catch (IdentifierNotFoundException ex) {
                log.info(service.getClass().getName() + " doesn't find an Identifier for " + this.contentServiceFactory.getDSpaceObjectService(dso).getTypeText(dso) + ", " + dso.getID().toString() + ".");
            }
            catch (IdentifierException e) {
                log.error((Object)e);
            }
        }
        return null;
    }

    @Override
    public List<String> lookup(Context context, DSpaceObject dso) {
        ArrayList<String> identifiers = new ArrayList<String>();
        for (IdentifierProvider service : this.providers) {
            try {
                String result = service.lookup(context, dso);
                if (StringUtils.isEmpty((CharSequence)result)) continue;
                if (log.isDebugEnabled()) {
                    try {
                        log.debug("Got an identifier from " + service.getClass().getCanonicalName() + ".");
                    }
                    catch (NullPointerException ex) {
                        log.debug(ex.getMessage(), (Throwable)ex);
                    }
                }
                identifiers.add(result);
            }
            catch (IdentifierNotFoundException ex) {
                log.debug(service.getClass().getName() + " doesn't find an Identifier for " + this.contentServiceFactory.getDSpaceObjectService(dso).getTypeText(dso) + ", " + dso.getID().toString() + ".");
            }
            catch (IdentifierException ex) {
                log.error((Object)ex);
            }
        }
        try {
            String handle = dso.getHandle();
            if (!(StringUtils.isEmpty((CharSequence)handle) || identifiers.contains(handle) || identifiers.contains("hdl:" + handle) || identifiers.contains(this.handleService.getCanonicalForm(handle)))) {
                log.info("Adding handle '" + handle + "' to the array of looked up identifiers.");
                identifiers.add(handle);
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        log.debug("Found identifiers: " + ((Object)identifiers).toString());
        return identifiers;
    }

    @Override
    public DSpaceObject resolve(Context context, String identifier) throws IdentifierNotFoundException, IdentifierNotResolvableException {
        for (IdentifierProvider service : this.providers) {
            if (!service.supports(identifier)) continue;
            try {
                DSpaceObject result = service.resolve(context, identifier, new String[0]);
                if (result == null) continue;
                return result;
            }
            catch (IdentifierNotFoundException ex) {
                log.info(service.getClass().getName() + " cannot resolve Identifier " + identifier + ": identifier not found.");
            }
            catch (IdentifierException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public void delete(Context context, DSpaceObject dso) throws AuthorizeException, SQLException, IdentifierException {
        for (IdentifierProvider service : this.providers) {
            try {
                service.delete(context, dso);
            }
            catch (IdentifierException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void delete(Context context, DSpaceObject dso, String identifier) throws AuthorizeException, SQLException, IdentifierException {
        for (IdentifierProvider service : this.providers) {
            try {
                if (!service.supports(identifier)) continue;
                service.delete(context, dso, identifier);
            }
            catch (IdentifierException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

