/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.license;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.license.CCLicense;
import org.dspace.license.CCLicenseConnectorService;
import org.dspace.license.CCLicenseField;
import org.dspace.license.CCLicenseFieldEnum;
import org.dspace.services.ConfigurationService;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.InputSource;

public class CCLicenseConnectorServiceImpl
implements CCLicenseConnectorService,
InitializingBean {
    private Logger log = LogManager.getLogger(CCLicenseConnectorServiceImpl.class);
    private CloseableHttpClient client;
    protected SAXBuilder parser = new SAXBuilder();
    private String postArgument = "answers";
    private String postAnswerFormat = "<answers> <locale>{1}</locale><license-{0}>{2}</license-{0}></answers>";
    @Autowired
    private ConfigurationService configurationService;

    public void afterPropertiesSet() throws Exception {
        HttpClientBuilder builder = HttpClientBuilder.create();
        this.client = builder.disableAutomaticRetries().setMaxConnTotal(5).build();
        this.parser.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
    }

    @Override
    public Map<String, CCLicense> retrieveLicenses(String language) {
        List<String> licenses;
        String ccLicenseUrl = this.configurationService.getProperty("cc.api.rooturl");
        String uri = ccLicenseUrl + "/?locale=" + language;
        HttpGet httpGet = new HttpGet(uri);
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)httpGet);){
            licenses = this.retrieveLicenses(response);
        }
        catch (IOException | JDOMException e) {
            this.log.error("Error while retrieving the license details using url: " + uri, e);
            licenses = Collections.emptyList();
        }
        HashMap<String, CCLicense> ccLicenses = new HashMap<String, CCLicense>();
        for (String license : licenses) {
            String licenseUri = ccLicenseUrl + "/license/" + license;
            HttpGet licenseHttpGet = new HttpGet(licenseUri);
            try {
                CloseableHttpResponse response = this.client.execute((HttpUriRequest)licenseHttpGet);
                try {
                    CCLicense ccLicense = this.retrieveLicenseObject(license, response);
                    ccLicenses.put(ccLicense.getLicenseId(), ccLicense);
                }
                finally {
                    if (response == null) continue;
                    response.close();
                }
            }
            catch (IOException | JDOMException e) {
                this.log.error("Error while retrieving the license details using url: " + licenseUri, e);
            }
        }
        return ccLicenses;
    }

    private List<String> retrieveLicenses(CloseableHttpResponse response) throws IOException, JDOMException {
        LinkedList<String> domains = new LinkedList<String>();
        Object[] excludedLicenses = this.configurationService.getArrayProperty("cc.license.classfilter");
        String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
        XPathExpression licenseClassXpath = XPathFactory.instance().compile("//licenses/license", Filters.element());
        try (StringReader stringReader = new StringReader(responseString);){
            InputSource is = new InputSource(stringReader);
            Document classDoc = this.parser.build(is);
            List elements = licenseClassXpath.evaluate((Object)classDoc);
            for (Element element : elements) {
                String licenseId = this.getSingleNodeValue(element, "@id");
                if (!StringUtils.isNotBlank((CharSequence)licenseId) || ArrayUtils.contains((Object[])excludedLicenses, (Object)licenseId)) continue;
                domains.add(licenseId);
            }
        }
        return domains;
    }

    private CCLicense retrieveLicenseObject(String licenseId, CloseableHttpResponse response) throws IOException, JDOMException {
        String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
        XPathExpression licenseClassXpath = XPathFactory.instance().compile("//licenseclass", Filters.fpassthrough());
        XPathExpression licenseFieldXpath = XPathFactory.instance().compile("field", Filters.element());
        try (StringReader stringReader = new StringReader(responseString);){
            InputSource is = new InputSource(stringReader);
            Document classDoc = this.parser.build(is);
            Object element = licenseClassXpath.evaluateFirst((Object)classDoc);
            String licenseLabel = this.getSingleNodeValue(element, "label");
            LinkedList<CCLicenseField> ccLicenseFields = new LinkedList<CCLicenseField>();
            List licenseFields = licenseFieldXpath.evaluate(element);
            for (Element licenseField : licenseFields) {
                CCLicenseField ccLicenseField = this.parseLicenseField(licenseField);
                ccLicenseFields.add(ccLicenseField);
            }
            CCLicense cCLicense = new CCLicense(licenseId, licenseLabel, ccLicenseFields);
            return cCLicense;
        }
    }

    private CCLicenseField parseLicenseField(Element licenseField) {
        String id = this.getSingleNodeValue(licenseField, "@id");
        String label = this.getSingleNodeValue(licenseField, "label");
        String description = this.getSingleNodeValue(licenseField, "description");
        XPathExpression enumXpath = XPathFactory.instance().compile("enum", Filters.element());
        List enums = enumXpath.evaluate((Object)licenseField);
        LinkedList<CCLicenseFieldEnum> ccLicenseFieldEnumList = new LinkedList<CCLicenseFieldEnum>();
        for (Element enumElement : enums) {
            CCLicenseFieldEnum ccLicenseFieldEnum = this.parseEnum(enumElement);
            ccLicenseFieldEnumList.add(ccLicenseFieldEnum);
        }
        return new CCLicenseField(id, label, description, ccLicenseFieldEnumList);
    }

    private CCLicenseFieldEnum parseEnum(Element enumElement) {
        String id = this.getSingleNodeValue(enumElement, "@id");
        String label = this.getSingleNodeValue(enumElement, "label");
        String description = this.getSingleNodeValue(enumElement, "description");
        return new CCLicenseFieldEnum(id, label, description);
    }

    private String getNodeValue(Object el) {
        if (el instanceof Element) {
            return ((Element)el).getValue();
        }
        if (el instanceof Attribute) {
            return ((Attribute)el).getValue();
        }
        if (el instanceof String) {
            return (String)el;
        }
        return null;
    }

    private String getSingleNodeValue(Object t, String query) {
        XPathExpression xpath = XPathFactory.instance().compile(query, Filters.fpassthrough());
        Object singleNode = xpath.evaluateFirst(t);
        return this.getNodeValue(singleNode);
    }

    @Override
    public String retrieveRightsByQuestion(String licenseId, String language, Map<String, String> answerMap) {
        String string;
        block8: {
            String ccLicenseUrl = this.configurationService.getProperty("cc.api.rooturl");
            HttpPost httpPost = new HttpPost(ccLicenseUrl + "/license/" + licenseId + "/issue");
            String answers = this.createAnswerString(answerMap);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            String text = MessageFormat.format(this.postAnswerFormat, licenseId, language, answers);
            builder.addTextBody(this.postArgument, text);
            HttpEntity multipart = builder.build();
            httpPost.setEntity(multipart);
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)httpPost);
            try {
                string = this.retrieveLicenseUri(response);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | JDOMException e) {
                    this.log.error("Error while retrieving the license uri for license : " + licenseId + " with answers " + answerMap.toString(), e);
                    return null;
                }
            }
            response.close();
        }
        return string;
    }

    private String retrieveLicenseUri(CloseableHttpResponse response) throws IOException, JDOMException {
        String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
        XPathExpression licenseClassXpath = XPathFactory.instance().compile("//result/license-uri", Filters.fpassthrough());
        try (StringReader stringReader = new StringReader(responseString);){
            InputSource is = new InputSource(stringReader);
            Document classDoc = this.parser.build(is);
            Object node = licenseClassXpath.evaluateFirst((Object)classDoc);
            String nodeValue = this.getNodeValue(node);
            if (StringUtils.isNotBlank((CharSequence)nodeValue)) {
                String string = nodeValue;
                return string;
            }
        }
        return null;
    }

    private String createAnswerString(Map<String, String> parameterMap) {
        StringBuilder sb = new StringBuilder();
        for (String key : parameterMap.keySet()) {
            sb.append("<");
            sb.append(key);
            sb.append(">");
            sb.append(parameterMap.get(key));
            sb.append("</");
            sb.append(key);
            sb.append(">");
        }
        return sb.toString();
    }

    @Override
    public Document retrieveLicenseRDFDoc(String licenseURI) throws IOException {
        URL request_url;
        String ccLicenseUrl = this.configurationService.getProperty("cc.api.rooturl");
        String issueUrl = ccLicenseUrl + "/details?license-uri=" + licenseURI;
        try {
            request_url = new URL(issueUrl);
        }
        catch (MalformedURLException e) {
            return null;
        }
        URLConnection connection = request_url.openConnection();
        connection.setDoOutput(true);
        try {
            InputStream stream = connection.getInputStream();
            Document doc = this.parser.build(stream);
            return doc;
        }
        catch (Exception e) {
            this.log.error("Error while retrieving the license document for URI: " + licenseURI, (Throwable)e);
            return null;
        }
    }

    @Override
    public String retrieveLicenseName(Document doc) {
        return this.getSingleNodeValue(doc, "//result/license-name");
    }
}

