/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.model.factory;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class OrcidFactoryUtils {
    private OrcidFactoryUtils() {
    }

    public static Map<String, String> parseConfigurations(String configurations) {
        HashMap<String, String> configurationMap = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)configurations)) {
            return configurationMap;
        }
        for (String configuration : configurations.split(",")) {
            String[] configurationSections = OrcidFactoryUtils.parseConfiguration(configuration);
            configurationMap.put(configurationSections[0], configurationSections[1]);
        }
        return configurationMap;
    }

    private static String[] parseConfiguration(String configuration) {
        String[] configurations = configuration.split("::");
        if (configurations.length != 2) {
            throw new IllegalStateException("The configuration '" + configuration + "' is not valid. Expected field::type");
        }
        return configurations;
    }
}

