/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.script;

import java.sql.SQLException;
import org.apache.commons.cli.Options;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.dspace.orcid.script.OrcidBulkPush;
import org.dspace.scripts.configuration.ScriptConfiguration;
import org.springframework.beans.factory.annotation.Autowired;

public class OrcidBulkPushScriptConfiguration<T extends OrcidBulkPush>
extends ScriptConfiguration<T> {
    @Autowired
    private AuthorizeService authorizeService;
    private Class<T> dspaceRunnableClass;

    @Override
    public boolean isAllowedToExecute(Context context) {
        try {
            return this.authorizeService.isAdmin(context);
        }
        catch (SQLException e) {
            throw new RuntimeException("SQLException occurred when checking if the current user is an admin", e);
        }
    }

    @Override
    public Class<T> getDspaceRunnableClass() {
        return this.dspaceRunnableClass;
    }

    @Override
    public void setDspaceRunnableClass(Class<T> dspaceRunnableClass) {
        this.dspaceRunnableClass = dspaceRunnableClass;
    }

    @Override
    public Options getOptions() {
        if (this.options == null) {
            Options options = new Options();
            options.addOption("f", "force", false, "force the synchronization ignoring maximum attempts");
            options.getOption("f").setType(Boolean.TYPE);
            options.getOption("f").setRequired(false);
            this.options = options;
        }
        return this.options;
    }
}

