/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics;

import com.maxmind.geoip2.DatabaseReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class GeoIpService {
    @Autowired
    private ConfigurationService configurationService;

    public DatabaseReader getDatabaseReader() throws IllegalStateException {
        String dbPath = this.configurationService.getProperty("usage-statistics.dbfile");
        if (StringUtils.isBlank((CharSequence)dbPath)) {
            throw new IllegalStateException("The required 'dbfile' configuration is missing in solr-statistics.cfg!");
        }
        try {
            File dbFile = new File(dbPath);
            return new DatabaseReader.Builder(dbFile).build();
        }
        catch (FileNotFoundException fe) {
            throw new IllegalStateException("The GeoLite Database file is missing (" + dbPath + ")! Solr Statistics cannot generate location based reports! Please see the DSpace installation instructions for instructions to install this file.", fe);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to load GeoLite Database file (" + dbPath + ")! You may need to reinstall it. See the DSpace installation instructions for more details.", e);
        }
    }
}

