/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.export.processor;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.statistics.export.processor.ExportEventProcessor;

public class ItemEventProcessor
extends ExportEventProcessor {
    private final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private final Item item;

    public ItemEventProcessor(Context context, HttpServletRequest request, Item item) {
        super(context, request);
        this.item = item;
    }

    @Override
    public void processEvent() throws SQLException, IOException {
        if (this.shouldProcessItem(this.item)) {
            String baseParam = this.getBaseParameters(this.item);
            String fullParam = this.addObjectSpecificData(baseParam, this.item);
            this.processObject(fullParam);
        }
    }

    protected String addObjectSpecificData(String string, Item item) throws UnsupportedEncodingException {
        StringBuilder data = new StringBuilder(string);
        String itemInfo = this.getItemInfo(item);
        data.append("&").append(URLEncoder.encode("svc_dat", "UTF-8")).append("=").append(URLEncoder.encode(itemInfo, "UTF-8"));
        data.append("&").append(URLEncoder.encode("rft_dat", "UTF-8")).append("=").append(URLEncoder.encode("Investigation", "UTF-8"));
        return data.toString();
    }

    private String getItemInfo(Item item) {
        StringBuilder sb = new StringBuilder(this.configurationService.getProperty("dspace.ui.url"));
        sb.append("/handle/").append(item.getHandle());
        return sb.toString();
    }
}

