/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms.hibernate;

import org.apache.commons.lang.StringUtils;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.StringTypeDescriptor;
import org.hibernate.type.descriptor.sql.ClobTypeDescriptor;
import org.hibernate.type.descriptor.sql.LongVarcharTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class DatabaseAwareLobType
extends AbstractSingleColumnStandardBasicType<String> {
    public static final DatabaseAwareLobType INSTANCE = new DatabaseAwareLobType();

    public DatabaseAwareLobType() {
        super(DatabaseAwareLobType.getDbDescriptor(), (JavaTypeDescriptor)StringTypeDescriptor.INSTANCE);
    }

    public static SqlTypeDescriptor getDbDescriptor() {
        if (DatabaseAwareLobType.isPostgres()) {
            return LongVarcharTypeDescriptor.INSTANCE;
        }
        return ClobTypeDescriptor.DEFAULT;
    }

    private static boolean isPostgres() {
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        String dbDialect = configurationService.getProperty("db.dialect");
        return StringUtils.containsIgnoreCase((String)dbDialect, (String)"PostgreSQL");
    }

    public String getName() {
        return "database_aware_lob";
    }
}

