/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.state.actions.userassignment;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.eperson.EPerson;
import org.dspace.workflow.WorkflowException;
import org.dspace.xmlworkflow.RoleMembers;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.service.WorkflowRequirementsService;
import org.dspace.xmlworkflow.service.XmlWorkflowService;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.actions.ActionResult;
import org.dspace.xmlworkflow.state.actions.WorkflowActionConfig;
import org.dspace.xmlworkflow.state.actions.userassignment.UserSelectionAction;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.springframework.beans.factory.annotation.Autowired;

public class AssignOriginalSubmitterAction
extends UserSelectionAction {
    @Autowired(required=true)
    protected WorkflowRequirementsService workflowRequirementsService;

    @Override
    public boolean isFinished(XmlWorkflowItem wfi) {
        return false;
    }

    @Override
    public void regenerateTasks(Context c, XmlWorkflowItem wfi, RoleMembers roleMembers) throws SQLException {
    }

    @Override
    public boolean isValidUserSelection(Context context, XmlWorkflowItem wfi, boolean hasUI) throws WorkflowConfigurationException, SQLException {
        return wfi.getSubmitter() != null;
    }

    @Override
    public boolean usesTaskPool() {
        return false;
    }

    @Override
    public void activate(Context c, XmlWorkflowItem wf) throws SQLException, IOException {
    }

    @Override
    public void alertUsersOnActivation(Context c, XmlWorkflowItem wfi, RoleMembers roleMembers) throws IOException, SQLException {
        if (wfi.getSubmitter() != null) {
            try {
                XmlWorkflowService xmlWorkflowService = XmlWorkflowServiceFactory.getInstance().getXmlWorkflowService();
                xmlWorkflowService.alertUsersOnTaskActivation(c, wfi, "submit_task", Arrays.asList(wfi.getSubmitter()), wfi.getItem().getName(), wfi.getCollection().getName(), wfi.getSubmitter().getFullName(), "New task available.", xmlWorkflowService.getMyDSpaceLink());
            }
            catch (MessagingException e) {
                this.log.info(LogHelper.getHeader(c, "error emailing user(s) for claimed task", "step: " + this.getParent().getStep().getId() + " workflowitem: " + wfi.getID()));
            }
        }
    }

    @Override
    public ActionResult execute(Context c, XmlWorkflowItem wfi, Step step, HttpServletRequest request) throws SQLException, AuthorizeException, IOException, WorkflowException {
        EPerson submitter = wfi.getSubmitter();
        WorkflowActionConfig nextAction = this.getParent().getStep().getNextAction(this.getParent());
        while (nextAction != null && !nextAction.requiresUI()) {
            nextAction = nextAction.getStep().getNextAction(nextAction);
        }
        if (nextAction == null) {
            this.log.error("Could not find next action for step with id: " + step.getId() + " to assign a submitter to. Aborting the action.");
            throw new IllegalStateException();
        }
        if (submitter != null) {
            this.createTaskForEPerson(c, wfi, step, nextAction, submitter);
        }
        return new ActionResult(ActionResult.TYPE.TYPE_OUTCOME, 0);
    }

    @Override
    public List<String> getOptions() {
        return new ArrayList<String>();
    }

    protected void createTaskForEPerson(Context c, XmlWorkflowItem wfi, Step step, WorkflowActionConfig actionConfig, EPerson user) throws SQLException, AuthorizeException, IOException {
        if (this.claimedTaskService.find(c, wfi, step.getId(), actionConfig.getId()) != null) {
            this.workflowRequirementsService.addClaimedUser(c, wfi, step, c.getCurrentUser());
            XmlWorkflowServiceFactory.getInstance().getXmlWorkflowService().createOwnedTask(c, wfi, step, actionConfig, user);
        }
    }
}

