/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.state.actions.userassignment;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.service.GroupService;
import org.dspace.xmlworkflow.Role;
import org.dspace.xmlworkflow.RoleMembers;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.factory.XmlWorkflowServiceFactory;
import org.dspace.xmlworkflow.service.WorkflowRequirementsService;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.actions.ActionResult;
import org.dspace.xmlworkflow.state.actions.WorkflowActionConfig;
import org.dspace.xmlworkflow.state.actions.userassignment.UserSelectionAction;
import org.dspace.xmlworkflow.storedcomponents.WorkflowItemRole;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;
import org.springframework.beans.factory.annotation.Autowired;

public class AutoAssignAction
extends UserSelectionAction {
    private final Logger log = LogManager.getLogger(AutoAssignAction.class);
    @Autowired(required=true)
    protected GroupService groupService;
    @Autowired(required=true)
    protected WorkflowRequirementsService workflowRequirementsService;

    @Override
    public void activate(Context c, XmlWorkflowItem wfItem) {
    }

    @Override
    public ActionResult execute(Context c, XmlWorkflowItem wfi, Step step, HttpServletRequest request) throws SQLException, AuthorizeException, IOException {
        try {
            Role role = this.getParent().getStep().getRole();
            if (role != null) {
                WorkflowActionConfig nextAction = this.getParent().getStep().getNextAction(this.getParent());
                while (nextAction != null && !nextAction.requiresUI()) {
                    nextAction = nextAction.getStep().getNextAction(nextAction);
                }
                if (nextAction != null) {
                    List<WorkflowItemRole> workflowItemRoles = this.workflowItemRoleService.find(c, wfi, role.getId());
                    for (WorkflowItemRole workflowItemRole : workflowItemRoles) {
                        if (workflowItemRole.getEPerson() != null) {
                            this.createTaskForEPerson(c, wfi, step, nextAction, workflowItemRole.getEPerson());
                        } else {
                            List<EPerson> members = this.groupService.allMembers(c, workflowItemRole.getGroup());
                            for (EPerson member : members) {
                                this.createTaskForEPerson(c, wfi, step, nextAction, member);
                            }
                        }
                        this.workflowItemRoleService.delete(c, workflowItemRole);
                    }
                } else {
                    this.log.warn(LogHelper.getHeader(c, "Error while executing auto assign action", "No valid next action. Workflow item:" + wfi.getID()));
                }
            }
        }
        catch (SQLException e) {
            this.log.error(LogHelper.getHeader(c, "Error while executing auto assign action", "Workflow item: " + wfi.getID() + " step :" + this.getParent().getStep().getId()), (Throwable)e);
            throw e;
        }
        catch (AuthorizeException e) {
            this.log.error(LogHelper.getHeader(c, "Error while executing auto assign action", "Workflow item: " + wfi.getID() + " step :" + this.getParent().getStep().getId()), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            this.log.error(LogHelper.getHeader(c, "Error while executing auto assign action", "Workflow item: " + wfi.getID() + " step :" + this.getParent().getStep().getId()), (Throwable)e);
            throw e;
        }
        return new ActionResult(ActionResult.TYPE.TYPE_OUTCOME, 0);
    }

    @Override
    public List<String> getOptions() {
        return new ArrayList<String>();
    }

    protected void createTaskForEPerson(Context c, XmlWorkflowItem wfi, Step step, WorkflowActionConfig actionConfig, EPerson user) throws SQLException, AuthorizeException, IOException {
        if (this.claimedTaskService.find(c, wfi, step.getId(), actionConfig.getId()) != null) {
            this.workflowRequirementsService.addClaimedUser(c, wfi, step, c.getCurrentUser());
            XmlWorkflowServiceFactory.getInstance().getXmlWorkflowService().createOwnedTask(c, wfi, step, actionConfig, user);
        }
    }

    @Override
    public boolean isFinished(XmlWorkflowItem wfi) {
        return true;
    }

    @Override
    public void regenerateTasks(Context c, XmlWorkflowItem wfi, RoleMembers roleMembers) throws SQLException {
    }

    @Override
    public boolean isValidUserSelection(Context context, XmlWorkflowItem wfi, boolean hasUI) throws WorkflowConfigurationException, SQLException {
        Role role = this.getParent().getStep().getRole();
        if (role != null) {
            List<WorkflowItemRole> workflowItemRoles = this.workflowItemRoleService.find(context, wfi, role.getId());
            if (workflowItemRoles.size() == 0) {
                throw new WorkflowConfigurationException("The next step is invalid, since it doesn't have any individual item roles");
            }
            return true;
        }
        throw new WorkflowConfigurationException("The next step is invalid, since it doesn't have a valid role");
    }

    @Override
    public boolean usesTaskPool() {
        return false;
    }
}

