/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.sherpa;

import java.util.List;
import java.util.Optional;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.dspace.AbstractDSpaceTest;
import org.dspace.content.dto.MetadataValueDTO;
import org.dspace.external.factory.ExternalServiceFactory;
import org.dspace.external.model.ExternalDataObject;
import org.dspace.external.provider.ExternalDataProvider;
import org.dspace.external.service.ExternalDataService;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SHERPADataProviderTest
extends AbstractDSpaceTest {
    ExternalDataService externalDataService;
    ExternalDataProvider sherpaJournalProvider;
    ExternalDataProvider sherpaPublisherProvider;
    ExternalDataProvider sherpaJournalIssnProvider;

    @BeforeClass
    public static void setUpClass() {
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        this.externalDataService = ExternalServiceFactory.getInstance().getExternalDataService();
        this.sherpaJournalProvider = this.externalDataService.getExternalDataProvider("sherpaJournal");
        this.sherpaPublisherProvider = this.externalDataService.getExternalDataProvider("sherpaPublisher");
        this.sherpaJournalIssnProvider = this.externalDataService.getExternalDataProvider("sherpaJournalIssn");
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGetJournalISSNExternalObject() {
        String validIssn = "0140-6736";
        String validName = "The Lancet";
        Optional externalDataObject = this.sherpaJournalIssnProvider.getExternalDataObject(validIssn);
        ExternalDataObject dataObject = (ExternalDataObject)externalDataObject.orElseThrow(() -> new ResourceNotFoundException("Couldn't find a data object for ISSN " + validIssn));
        String title = null;
        String identifier = null;
        for (MetadataValueDTO metadataValue : dataObject.getMetadata()) {
            if (metadataValue.getSchema().equalsIgnoreCase("dc") && metadataValue.getElement().equalsIgnoreCase("title")) {
                title = metadataValue.getValue();
                continue;
            }
            if (!metadataValue.getSchema().equalsIgnoreCase("dc") || !metadataValue.getElement().equalsIgnoreCase("identifier") || !metadataValue.getQualifier().equalsIgnoreCase("issn")) continue;
            identifier = metadataValue.getValue();
        }
        Assert.assertEquals((String)("Title metadata must equal '" + validName + "' "), (Object)validName, title);
        Assert.assertEquals((String)("Identifier ISSN must equal " + validIssn), (Object)validIssn, identifier);
    }

    @Test
    public void testSearchJournalISSNExternalObjects() {
        String validIssn = "0140-6736";
        String validName = "The Lancet";
        List externalDataObjects = this.sherpaJournalIssnProvider.searchExternalDataObjects(validIssn, 0, 1);
        Assert.assertTrue((String)("Couldn't find a data object for publication name " + validName), (externalDataObjects != null && !externalDataObjects.isEmpty() ? 1 : 0) != 0);
        ExternalDataObject dataObject = (ExternalDataObject)externalDataObjects.get(0);
        Assert.assertNotNull((String)"External data object must not be null", (Object)dataObject);
        String title = null;
        String identifier = null;
        for (MetadataValueDTO metadataValue : dataObject.getMetadata()) {
            if (metadataValue.getSchema().equalsIgnoreCase("dc") && metadataValue.getElement().equalsIgnoreCase("title")) {
                title = metadataValue.getValue();
                continue;
            }
            if (!metadataValue.getSchema().equalsIgnoreCase("dc") || !metadataValue.getElement().equalsIgnoreCase("identifier") || !metadataValue.getQualifier().equalsIgnoreCase("issn")) continue;
            identifier = metadataValue.getValue();
        }
        Assert.assertEquals((String)("Title metadata must equal '" + validName + "' "), (Object)validName, title);
        Assert.assertEquals((String)("Identifier ISSN must equal " + validIssn), (Object)validIssn, identifier);
    }

    @Test
    public void testGetJournalExternalObject() {
        String validIssn = "0140-6736";
        String validName = "The Lancet";
        Optional externalDataObject = this.sherpaJournalProvider.getExternalDataObject(validName);
        ExternalDataObject dataObject = (ExternalDataObject)externalDataObject.orElseThrow(() -> new ResourceNotFoundException("Couldn't find a data object for publication name " + validName));
        String title = null;
        String identifier = null;
        for (MetadataValueDTO metadataValue : dataObject.getMetadata()) {
            if (metadataValue.getSchema().equalsIgnoreCase("dc") && metadataValue.getElement().equalsIgnoreCase("title")) {
                title = metadataValue.getValue();
                continue;
            }
            if (!metadataValue.getSchema().equalsIgnoreCase("dc") || !metadataValue.getElement().equalsIgnoreCase("identifier") || !metadataValue.getQualifier().equalsIgnoreCase("issn")) continue;
            identifier = metadataValue.getValue();
        }
        Assert.assertEquals((String)("Title metadata must equal '" + validName + "' "), (Object)validName, title);
        Assert.assertEquals((String)("Identifier ISSN must equal " + validIssn), (Object)validIssn, identifier);
    }

    @Test
    public void testSearchJournalObjects() {
        String validIssn = "0140-6736";
        String validName = "The Lancet";
        List externalDataObjects = this.sherpaJournalProvider.searchExternalDataObjects(validName, 0, 1);
        Assert.assertTrue((String)("Couldn't find a data object for publication name " + validName), (externalDataObjects != null && !externalDataObjects.isEmpty() ? 1 : 0) != 0);
        ExternalDataObject dataObject = (ExternalDataObject)externalDataObjects.get(0);
        Assert.assertNotNull((String)"External data object must not be null", (Object)dataObject);
        String title = null;
        String identifier = null;
        for (MetadataValueDTO metadataValue : dataObject.getMetadata()) {
            if (metadataValue.getSchema().equalsIgnoreCase("dc") && metadataValue.getElement().equalsIgnoreCase("title")) {
                title = metadataValue.getValue();
                continue;
            }
            if (!metadataValue.getSchema().equalsIgnoreCase("dc") || !metadataValue.getElement().equalsIgnoreCase("identifier") || !metadataValue.getQualifier().equalsIgnoreCase("issn")) continue;
            identifier = metadataValue.getValue();
        }
        Assert.assertEquals((String)("Title metadata must equal '" + validName + "' "), (Object)validName, title);
        Assert.assertEquals((String)("Identifier ISSN must equal " + validIssn), (Object)validIssn, identifier);
    }

    @Test
    public void testGetPublisherExternalObject() {
        String validName = "Public Library of Science";
        String validIdentifier = "112";
        String validUrl = "http://www.plos.org/";
        Optional externalDataObject = this.sherpaPublisherProvider.getExternalDataObject(validName);
        ExternalDataObject dataObject = (ExternalDataObject)externalDataObject.orElseThrow(() -> new ResourceNotFoundException("Couldn't find a data object for publication name " + validName));
        String title = null;
        String identifier = null;
        String url = null;
        for (MetadataValueDTO metadataValue : dataObject.getMetadata()) {
            if (metadataValue.getSchema().equalsIgnoreCase("dc") && metadataValue.getElement().equalsIgnoreCase("title")) {
                title = metadataValue.getValue();
                continue;
            }
            if (metadataValue.getSchema().equalsIgnoreCase("dc") && metadataValue.getElement().equalsIgnoreCase("identifier") && metadataValue.getQualifier().equalsIgnoreCase("sherpaPublisher")) {
                identifier = metadataValue.getValue();
                continue;
            }
            if (!metadataValue.getSchema().equalsIgnoreCase("dc") || !metadataValue.getElement().equalsIgnoreCase("identifier") || !metadataValue.getQualifier().equalsIgnoreCase("other")) continue;
            url = metadataValue.getValue();
        }
        Assert.assertEquals((String)("Title metadata must equal '" + validName + "' "), (Object)validName, title);
        Assert.assertEquals((String)("Publisher ID must equal " + validIdentifier), (Object)validIdentifier, identifier);
        Assert.assertEquals((String)("Publisher URL must equal " + validUrl), (Object)validUrl, url);
    }

    @Test
    public void testSearchPublisherExternalObjects() {
        String validName = "Public Library of Science";
        String validIdentifier = "112";
        String validUrl = "http://www.plos.org/";
        List externalDataObjects = this.sherpaPublisherProvider.searchExternalDataObjects(validName, 0, 1);
        Assert.assertTrue((String)("Couldn't find a data object for publication name " + validName), (externalDataObjects != null && !externalDataObjects.isEmpty() ? 1 : 0) != 0);
        ExternalDataObject dataObject = (ExternalDataObject)externalDataObjects.get(0);
        Assert.assertNotNull((String)"External data object must not be null", (Object)dataObject);
        String title = null;
        String identifier = null;
        String url = null;
        for (MetadataValueDTO metadataValue : dataObject.getMetadata()) {
            if (metadataValue.getSchema().equalsIgnoreCase("dc") && metadataValue.getElement().equalsIgnoreCase("title")) {
                title = metadataValue.getValue();
                continue;
            }
            if (metadataValue.getSchema().equalsIgnoreCase("dc") && metadataValue.getElement().equalsIgnoreCase("identifier") && metadataValue.getQualifier().equalsIgnoreCase("sherpaPublisher")) {
                identifier = metadataValue.getValue();
                continue;
            }
            if (!metadataValue.getSchema().equalsIgnoreCase("dc") || !metadataValue.getElement().equalsIgnoreCase("identifier") || !metadataValue.getQualifier().equalsIgnoreCase("other")) continue;
            url = metadataValue.getValue();
        }
        Assert.assertEquals((String)("Title metadata must equal '" + validName + "' "), (Object)validName, title);
        Assert.assertEquals((String)("Publisher ID must equal " + validIdentifier), (Object)validIdentifier, identifier);
        Assert.assertEquals((String)("Publisher URL must equal " + validUrl), (Object)validUrl, url);
    }
}

