/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.sql.SQLException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.AbstractBuilder;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.orcid.OrcidOperation;
import org.dspace.orcid.OrcidQueue;
import org.dspace.orcid.service.OrcidQueueService;

public class OrcidQueueBuilder
extends AbstractBuilder<OrcidQueue, OrcidQueueService> {
    private OrcidQueue orcidQueue;

    protected OrcidQueueBuilder(Context context) {
        super(context);
    }

    @Override
    protected OrcidQueueService getService() {
        return orcidQueueService;
    }

    @Override
    public void cleanup() throws Exception {
        this.delete(this.orcidQueue);
    }

    public static OrcidQueueBuilder createOrcidQueue(Context context, Item profileItem, Item entity) {
        OrcidQueueBuilder builder = new OrcidQueueBuilder(context);
        return builder.createEntityInsertionRecord(context, profileItem, entity);
    }

    public static OrcidQueueBuilder createOrcidQueue(Context context, Item profileItem, Item entity, String putCode) {
        OrcidQueueBuilder builder = new OrcidQueueBuilder(context);
        return builder.createEntityUpdateRecord(context, profileItem, entity, putCode);
    }

    public static OrcidQueueBuilder createOrcidQueue(Context context, Item profileItem, String description, String type, String putCode) {
        OrcidQueueBuilder builder = new OrcidQueueBuilder(context);
        return builder.createEntityDeletionRecord(context, profileItem, description, type, putCode);
    }

    private OrcidQueueBuilder createEntityDeletionRecord(Context context, Item profileItem, String description, String type, String putCode) {
        try {
            this.context = context;
            this.orcidQueue = this.getService().createEntityDeletionRecord(context, profileItem, description, type, putCode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    private OrcidQueueBuilder createEntityUpdateRecord(Context context, Item profileItem, Item entity, String putCode) {
        try {
            this.context = context;
            this.orcidQueue = this.getService().createEntityUpdateRecord(context, profileItem, entity, putCode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    private OrcidQueueBuilder createEntityInsertionRecord(Context context, Item profileItem, Item entity) {
        try {
            this.context = context;
            this.orcidQueue = this.getService().createEntityInsertionRecord(context, profileItem, entity);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public OrcidQueue build() throws SQLException, AuthorizeException {
        try {
            this.getService().update(this.context, this.orcidQueue);
            this.context.dispatchEvents();
            indexingService.commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.orcidQueue;
    }

    public OrcidQueueBuilder withPutCode(String putCode) {
        this.orcidQueue.setPutCode(putCode);
        return this;
    }

    public OrcidQueueBuilder withMetadata(String metadata) throws SQLException {
        this.orcidQueue.setMetadata(metadata);
        return this;
    }

    public OrcidQueueBuilder withRecordType(String recordType) throws SQLException {
        this.orcidQueue.setRecordType(recordType);
        return this;
    }

    public OrcidQueueBuilder withOperation(OrcidOperation operation) throws SQLException {
        this.orcidQueue.setOperation(operation);
        return this;
    }

    public OrcidQueueBuilder withDescription(String description) throws SQLException {
        this.orcidQueue.setDescription(description);
        return this;
    }

    @Override
    public void delete(Context c, OrcidQueue orcidQueue) throws Exception {
        if (orcidQueue != null) {
            this.getService().delete(c, orcidQueue);
        }
    }

    public void delete(OrcidQueue orcidQueue) throws Exception {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            OrcidQueue attachedTab = (OrcidQueue)c.reloadEntity((ReloadableEntity)orcidQueue);
            if (attachedTab != null) {
                this.getService().delete(c, attachedTab);
            }
            c.complete();
        }
        indexingService.commit();
    }
}

