/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.EntityType;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.MetadataValue;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipMetadataService;
import org.dspace.content.RelationshipType;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataValueService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.content.service.WorkspaceItemService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RelationshipServiceImplPlaceTest
extends AbstractUnitTest {
    private static final Logger log = LogManager.getLogger(RelationshipServiceImplPlaceTest.class);
    protected RelationshipService relationshipService = ContentServiceFactory.getInstance().getRelationshipService();
    protected RelationshipTypeService relationshipTypeService = ContentServiceFactory.getInstance().getRelationshipTypeService();
    protected RelationshipMetadataService relationshipMetadataService = ContentServiceFactory.getInstance().getRelationshipMetadataService();
    protected EntityTypeService entityTypeService = ContentServiceFactory.getInstance().getEntityTypeService();
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected MetadataValueService metadataValueService = ContentServiceFactory.getInstance().getMetadataValueService();
    Community community;
    Collection col;
    Item item;
    Item authorItem;
    Item author1;
    Item author2;
    Item author3;
    Item author4;
    Item author5;
    Item author6;
    Item publication1;
    Item publication2;
    Item publication3;
    Item publication4;
    Item publication5;
    Item publication6;
    Item project1;
    Item project2;
    Item project3;
    Item project4;
    Item project5;
    Item project6;
    RelationshipType isAuthorOfPublication;
    RelationshipType isProjectOfPublication;
    RelationshipType isProjectOfPerson;
    EntityType publicationEntityType;
    EntityType projectEntityType;
    EntityType personEntityType;
    String authorQualifier = "author";
    String contributorElement = "contributor";
    String dcSchema = "dc";

    @Override
    @Before
    public void init() {
        super.init();
        try {
            this.context.turnOffAuthorisationSystem();
            this.community = this.communityService.create(null, this.context);
            this.col = this.collectionService.create(this.context, this.community);
            WorkspaceItem is = this.workspaceItemService.create(this.context, this.col, false);
            WorkspaceItem authorIs = this.workspaceItemService.create(this.context, this.col, false);
            this.item = this.installItemService.installItem(this.context, (InProgressSubmission)is);
            this.itemService.addMetadata(this.context, (DSpaceObject)this.item, "dspace", "entity", "type", null, "Publication");
            this.authorItem = this.installItemService.installItem(this.context, (InProgressSubmission)authorIs);
            this.itemService.addMetadata(this.context, (DSpaceObject)this.authorItem, "dspace", "entity", "type", null, "Person");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.authorItem, "person", "familyName", null, null, "familyName");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.authorItem, "person", "givenName", null, null, "firstName");
            WorkspaceItem wi = this.workspaceItemService.create(this.context, this.col, false);
            this.author1 = this.installItemService.installItem(this.context, (InProgressSubmission)wi);
            this.itemService.addMetadata(this.context, (DSpaceObject)this.author1, "dspace", "entity", "type", null, "Person");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.author1, "person", "familyName", null, null, "Author");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.author1, "person", "givenName", null, null, "First");
            wi = this.workspaceItemService.create(this.context, this.col, false);
            this.author2 = this.installItemService.installItem(this.context, (InProgressSubmission)wi);
            this.itemService.addMetadata(this.context, (DSpaceObject)this.author2, "dspace", "entity", "type", null, "Person");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.author2, "person", "familyName", null, null, "Author");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.author2, "person", "givenName", null, null, "Second");
            wi = this.workspaceItemService.create(this.context, this.col, false);
            this.author3 = this.installItemService.installItem(this.context, (InProgressSubmission)wi);
            this.itemService.addMetadata(this.context, (DSpaceObject)this.author3, "dspace", "entity", "type", null, "Person");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.author3, "person", "familyName", null, null, "Author");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.author3, "person", "givenName", null, null, "Third");
            wi = this.workspaceItemService.create(this.context, this.col, false);
            this.author4 = this.installItemService.installItem(this.context, (InProgressSubmission)wi);
            this.itemService.addMetadata(this.context, (DSpaceObject)this.author4, "dspace", "entity", "type", null, "Person");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.author4, "person", "familyName", null, null, "Author");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.author4, "person", "givenName", null, null, "Fourth");
            wi = this.workspaceItemService.create(this.context, this.col, false);
            this.author5 = this.installItemService.installItem(this.context, (InProgressSubmission)wi);
            this.itemService.addMetadata(this.context, (DSpaceObject)this.author5, "dspace", "entity", "type", null, "Person");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.author5, "person", "familyName", null, null, "Author");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.author5, "person", "givenName", null, null, "Fifth");
            wi = this.workspaceItemService.create(this.context, this.col, false);
            this.author6 = this.installItemService.installItem(this.context, (InProgressSubmission)wi);
            this.itemService.addMetadata(this.context, (DSpaceObject)this.author6, "dspace", "entity", "type", null, "Person");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.author6, "person", "familyName", null, null, "Author");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.author6, "person", "givenName", null, null, "Sixth");
            wi = this.workspaceItemService.create(this.context, this.col, false);
            this.publication1 = this.installItemService.installItem(this.context, (InProgressSubmission)wi);
            this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, "dspace", "entity", "type", null, "Publication");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, "dc", "title", null, null, "Publication 1");
            wi = this.workspaceItemService.create(this.context, this.col, false);
            this.publication2 = this.installItemService.installItem(this.context, (InProgressSubmission)wi);
            this.itemService.addMetadata(this.context, (DSpaceObject)this.publication2, "dspace", "entity", "type", null, "Publication");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.publication2, "dc", "title", null, null, "Publication 2");
            wi = this.workspaceItemService.create(this.context, this.col, false);
            this.publication3 = this.installItemService.installItem(this.context, (InProgressSubmission)wi);
            this.itemService.addMetadata(this.context, (DSpaceObject)this.publication3, "dspace", "entity", "type", null, "Publication");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.publication3, "dc", "title", null, null, "Publication 3");
            wi = this.workspaceItemService.create(this.context, this.col, false);
            this.publication4 = this.installItemService.installItem(this.context, (InProgressSubmission)wi);
            this.itemService.addMetadata(this.context, (DSpaceObject)this.publication4, "dspace", "entity", "type", null, "Publication");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.publication4, "dc", "title", null, null, "Publication 4");
            wi = this.workspaceItemService.create(this.context, this.col, false);
            this.publication5 = this.installItemService.installItem(this.context, (InProgressSubmission)wi);
            this.itemService.addMetadata(this.context, (DSpaceObject)this.publication5, "dspace", "entity", "type", null, "Publication");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.publication5, "dc", "title", null, null, "Publication 5");
            wi = this.workspaceItemService.create(this.context, this.col, false);
            this.publication6 = this.installItemService.installItem(this.context, (InProgressSubmission)wi);
            this.itemService.addMetadata(this.context, (DSpaceObject)this.publication6, "dspace", "entity", "type", null, "Publication");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.publication6, "dc", "title", null, null, "Publication 6");
            wi = this.workspaceItemService.create(this.context, this.col, false);
            this.project1 = this.installItemService.installItem(this.context, (InProgressSubmission)wi);
            this.itemService.addMetadata(this.context, (DSpaceObject)this.project1, "dspace", "entity", "type", null, "Project");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.project1, "dc", "title", null, null, "Project 1");
            wi = this.workspaceItemService.create(this.context, this.col, false);
            this.project2 = this.installItemService.installItem(this.context, (InProgressSubmission)wi);
            this.itemService.addMetadata(this.context, (DSpaceObject)this.project2, "dspace", "entity", "type", null, "Project");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.project2, "dc", "title", null, null, "Project 2");
            wi = this.workspaceItemService.create(this.context, this.col, false);
            this.project3 = this.installItemService.installItem(this.context, (InProgressSubmission)wi);
            this.itemService.addMetadata(this.context, (DSpaceObject)this.project3, "dspace", "entity", "type", null, "Project");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.project3, "dc", "title", null, null, "Project 3");
            wi = this.workspaceItemService.create(this.context, this.col, false);
            this.project4 = this.installItemService.installItem(this.context, (InProgressSubmission)wi);
            this.itemService.addMetadata(this.context, (DSpaceObject)this.project4, "dspace", "entity", "type", null, "Project");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.project4, "dc", "title", null, null, "Project 4");
            wi = this.workspaceItemService.create(this.context, this.col, false);
            this.project5 = this.installItemService.installItem(this.context, (InProgressSubmission)wi);
            this.itemService.addMetadata(this.context, (DSpaceObject)this.project5, "dspace", "entity", "type", null, "Project");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.project5, "dc", "title", null, null, "Project 5");
            wi = this.workspaceItemService.create(this.context, this.col, false);
            this.project6 = this.installItemService.installItem(this.context, (InProgressSubmission)wi);
            this.itemService.addMetadata(this.context, (DSpaceObject)this.project6, "dspace", "entity", "type", null, "Project");
            this.itemService.addMetadata(this.context, (DSpaceObject)this.project6, "dc", "title", null, null, "Project 6");
            this.publicationEntityType = this.entityTypeService.create(this.context, "Publication");
            this.projectEntityType = this.entityTypeService.create(this.context, "Project");
            this.personEntityType = this.entityTypeService.create(this.context, "Person");
            this.isAuthorOfPublication = this.relationshipTypeService.create(this.context, this.publicationEntityType, this.personEntityType, "isAuthorOfPublication", "isPublicationOfAuthor", null, null, null, null);
            this.isProjectOfPublication = this.relationshipTypeService.create(this.context, this.publicationEntityType, this.projectEntityType, "isProjectOfPublication", "isPublicationOfProject", null, null, null, null);
            this.isProjectOfPerson = this.relationshipTypeService.create(this.context, this.personEntityType, this.projectEntityType, "isProjectOfPerson", "isPersonOfProject", null, null, null, null);
            this.context.restoreAuthSystemState();
        }
        catch (AuthorizeException ex) {
            log.error("Authorization Error in init", (Throwable)ex);
            Assert.fail((String)("Authorization Error in init: " + ex.getMessage()));
        }
        catch (SQLException ex) {
            log.error("SQL Error in init", (Throwable)ex);
            Assert.fail((String)("SQL Error in init: " + ex.getMessage()));
        }
    }

    @Override
    @After
    public void destroy() {
        this.context.abort();
        super.destroy();
    }

    @Test
    public void addMetadataAndRelationshipTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, one");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, two");
        Relationship relationship = this.relationshipService.create(this.context, this.item, this.authorItem, this.isAuthorOfPublication, -1, -1);
        this.context.restoreAuthSystemState();
        List list = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        MatcherAssert.assertThat((Object)list.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, two", null, 1, (MetadataValue)list.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "familyName, firstName", "virtual::" + relationship.getID(), 2, (MetadataValue)list.get(2));
        MatcherAssert.assertThat((Object)relationship.getLeftPlace(), (Matcher)CoreMatchers.equalTo((Object)2));
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, three");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, four");
        WorkspaceItem authorIs = this.workspaceItemService.create(this.context, this.col, false);
        Item secondAuthorItem = this.installItemService.installItem(this.context, (InProgressSubmission)authorIs);
        this.itemService.addMetadata(this.context, (DSpaceObject)secondAuthorItem, "dspace", "entity", "type", null, "Person");
        this.itemService.addMetadata(this.context, (DSpaceObject)secondAuthorItem, "person", "familyName", null, null, "familyNameTwo");
        this.itemService.addMetadata(this.context, (DSpaceObject)secondAuthorItem, "person", "givenName", null, null, "firstNameTwo");
        Relationship relationshipTwo = this.relationshipService.create(this.context, this.item, secondAuthorItem, this.isAuthorOfPublication, -1, -1);
        this.context.restoreAuthSystemState();
        list = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, two", null, 1, (MetadataValue)list.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "familyName, firstName", "virtual::" + relationship.getID(), 2, (MetadataValue)list.get(2));
        MatcherAssert.assertThat((Object)relationship.getLeftPlace(), (Matcher)CoreMatchers.equalTo((Object)2));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 3, (MetadataValue)list.get(3));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, four", null, 4, (MetadataValue)list.get(4));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "familyNameTwo, firstNameTwo", "virtual::" + relationshipTwo.getID(), 5, (MetadataValue)list.get(5));
        MatcherAssert.assertThat((Object)relationshipTwo.getLeftPlace(), (Matcher)CoreMatchers.equalTo((Object)5));
    }

    @Test
    public void AddMetadataAndRelationshipWithSpecificPlaceTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, one");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, two");
        Relationship relationship = this.relationshipService.create(this.context, this.item, this.authorItem, this.isAuthorOfPublication, 2, -1);
        this.context.restoreAuthSystemState();
        List list = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        MatcherAssert.assertThat((Object)list.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, two", null, 1, (MetadataValue)list.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "familyName, firstName", "virtual::" + relationship.getID(), 2, (MetadataValue)list.get(2));
        MatcherAssert.assertThat((Object)relationship.getLeftPlace(), (Matcher)CoreMatchers.equalTo((Object)2));
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, three");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, four");
        WorkspaceItem authorIs = this.workspaceItemService.create(this.context, this.col, false);
        Item secondAuthorItem = this.installItemService.installItem(this.context, (InProgressSubmission)authorIs);
        this.itemService.addMetadata(this.context, (DSpaceObject)secondAuthorItem, "dspace", "entity", "type", null, "Person");
        this.itemService.addMetadata(this.context, (DSpaceObject)secondAuthorItem, "person", "familyName", null, null, "familyNameTwo");
        this.itemService.addMetadata(this.context, (DSpaceObject)secondAuthorItem, "person", "givenName", null, null, "firstNameTwo");
        Relationship relationshipTwo = this.relationshipService.create(this.context, this.item, secondAuthorItem, this.isAuthorOfPublication, 1, -1);
        this.context.restoreAuthSystemState();
        list = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "familyNameTwo, firstNameTwo", "virtual::" + relationshipTwo.getID(), 1, (MetadataValue)list.get(1));
        MatcherAssert.assertThat((Object)relationshipTwo.getLeftPlace(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, two", null, 2, (MetadataValue)list.get(2));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "familyName, firstName", "virtual::" + relationship.getID(), 3, (MetadataValue)list.get(3));
        MatcherAssert.assertThat((Object)relationship.getLeftPlace(), (Matcher)CoreMatchers.equalTo((Object)3));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 4, (MetadataValue)list.get(4));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, four", null, 5, (MetadataValue)list.get(5));
    }

    @Test
    public void AddAndRemoveMetadataAndRelationshipsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, one");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, two");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, three");
        MetadataValue metadataValueToRemove = (MetadataValue)this.itemService.getMetadata((DSpaceObject)this.item, "dc", "contributor", "author", "*").get(1);
        this.item.removeMetadata(metadataValueToRemove);
        this.metadataValueService.delete(this.context, metadataValueToRemove);
        this.context.restoreAuthSystemState();
        List list = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        MatcherAssert.assertThat((Object)list.size(), (Matcher)CoreMatchers.equalTo((Object)2));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 2, (MetadataValue)list.get(1));
        this.context.turnOffAuthorisationSystem();
        Relationship relationship = this.relationshipService.create(this.context, this.item, this.authorItem, this.isAuthorOfPublication, 1, -1);
        this.context.restoreAuthSystemState();
        list = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        MatcherAssert.assertThat((Object)list.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "familyName, firstName", "virtual::" + relationship.getID(), 1, (MetadataValue)list.get(1));
        MatcherAssert.assertThat((Object)relationship.getLeftPlace(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 2, (MetadataValue)list.get(2));
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, four");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, five");
        metadataValueToRemove = (MetadataValue)this.itemService.getMetadata((DSpaceObject)this.item, "dc", "contributor", "author", "*").get(3);
        this.item.removeMetadata(metadataValueToRemove);
        this.metadataValueService.delete(this.context, metadataValueToRemove);
        this.context.restoreAuthSystemState();
        list = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "familyName, firstName", "virtual::" + relationship.getID(), 1, (MetadataValue)list.get(1));
        MatcherAssert.assertThat((Object)relationship.getLeftPlace(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 2, (MetadataValue)list.get(2));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, five", null, 4, (MetadataValue)list.get(3));
        this.context.turnOffAuthorisationSystem();
        WorkspaceItem authorIs = this.workspaceItemService.create(this.context, this.col, false);
        Item secondAuthorItem = this.installItemService.installItem(this.context, (InProgressSubmission)authorIs);
        this.itemService.addMetadata(this.context, (DSpaceObject)secondAuthorItem, "dspace", "entity", "type", null, "Person");
        this.itemService.addMetadata(this.context, (DSpaceObject)secondAuthorItem, "person", "familyName", null, null, "familyNameTwo");
        this.itemService.addMetadata(this.context, (DSpaceObject)secondAuthorItem, "person", "givenName", null, null, "firstNameTwo");
        Relationship relationshipTwo = this.relationshipService.create(this.context, this.item, secondAuthorItem, this.isAuthorOfPublication, 3, -1);
        this.context.restoreAuthSystemState();
        list = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "familyName, firstName", "virtual::" + relationship.getID(), 1, (MetadataValue)list.get(1));
        MatcherAssert.assertThat((Object)relationship.getLeftPlace(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 2, (MetadataValue)list.get(2));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "familyNameTwo, firstNameTwo", "virtual::" + relationshipTwo.getID(), 3, (MetadataValue)list.get(3));
        MatcherAssert.assertThat((Object)relationshipTwo.getLeftPlace(), (Matcher)CoreMatchers.equalTo((Object)3));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, five", null, 4, (MetadataValue)list.get(4));
    }

    @Test
    public void AddAndUpdateMetadataAndRelationshipsTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, one");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, two");
        this.itemService.addMetadata(this.context, (DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, null, "test, three");
        Relationship relationship = this.relationshipService.create(this.context, this.item, this.authorItem, this.isAuthorOfPublication, -1, -1);
        this.context.restoreAuthSystemState();
        List list = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        MatcherAssert.assertThat((Object)list.size(), (Matcher)CoreMatchers.equalTo((Object)4));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, two", null, 1, (MetadataValue)list.get(1));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 2, (MetadataValue)list.get(2));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "familyName, firstName", "virtual::" + relationship.getID(), 3, (MetadataValue)list.get(3));
        MatcherAssert.assertThat((Object)relationship.getLeftPlace(), (Matcher)CoreMatchers.equalTo((Object)3));
        this.context.turnOffAuthorisationSystem();
        MetadataValue metadataValueToUpdate = (MetadataValue)this.itemService.getMetadata((DSpaceObject)this.item, "dc", "contributor", "author", "*").get(1);
        metadataValueToUpdate.setPlace(3);
        this.metadataValueService.update(this.context, metadataValueToUpdate);
        relationship.setLeftPlace(1);
        this.relationshipService.update(this.context, (Object)relationship);
        this.context.restoreAuthSystemState();
        list = this.itemService.getMetadata((DSpaceObject)this.item, this.dcSchema, this.contributorElement, this.authorQualifier, "*");
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, one", null, 0, (MetadataValue)list.get(0));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, two", null, 3, (MetadataValue)list.get(3));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "test, three", null, 2, (MetadataValue)list.get(2));
        this.assertMetadataValue(this.authorQualifier, this.contributorElement, this.dcSchema, "familyName, firstName", "virtual::" + relationship.getID(), 1, (MetadataValue)list.get(1));
        MatcherAssert.assertThat((Object)relationship.getLeftPlace(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    private void assertMetadataValue(String authorQualifier, String contributorElement, String dcSchema, String value, String authority, int place, MetadataValue metadataValue) {
        MatcherAssert.assertThat((Object)metadataValue.getValue(), (Matcher)CoreMatchers.equalTo((Object)value));
        MatcherAssert.assertThat((Object)metadataValue.getMetadataField().getMetadataSchema().getName(), (Matcher)CoreMatchers.equalTo((Object)dcSchema));
        MatcherAssert.assertThat((Object)metadataValue.getMetadataField().getElement(), (Matcher)CoreMatchers.equalTo((Object)contributorElement));
        MatcherAssert.assertThat((Object)metadataValue.getMetadataField().getQualifier(), (Matcher)CoreMatchers.equalTo((Object)authorQualifier));
        MatcherAssert.assertThat((Object)metadataValue.getAuthority(), (Matcher)CoreMatchers.equalTo((Object)authority));
        MatcherAssert.assertThat((Object)metadataValue.getPlace(), (Matcher)CoreMatchers.equalTo((Object)place));
    }

    @Test
    public void createUseForPlaceRelationshipAppendingLeftNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r2, 1);
        this.assertLeftPlace(r3, 2);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r1, r2, r3));
    }

    @Test
    public void createUseForPlaceRelationshipWithLeftPlaceAtTheStartNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, 0, -1);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r3, 0);
        this.assertLeftPlace(r1, 1);
        this.assertLeftPlace(r2, 2);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r3, r1, r2));
    }

    @Test
    public void createUseForPlaceRelationshipWithLeftPlaceInTheMiddleNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, 1, -1);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r3, 1);
        this.assertLeftPlace(r2, 2);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r1, r3, r2));
    }

    @Test
    public void createUseForPlaceRelationshipWithLeftPlaceAtTheEndNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, 2, -1);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r2, 1);
        this.assertLeftPlace(r3, 2);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r1, r2, r3));
    }

    @Test
    public void createUseForPlaceRelationshipAppendingLeftWithMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 1");
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 2");
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 1);
        this.assertLeftPlace(r2, 2);
        this.assertLeftPlace(r3, 4);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r1, r2, r3));
        this.assertMetadataOrder(this.publication1, "dc.contributor.author", List.of("MDV 1", "Author, First", "Author, Second", "MDV 2", "Author, Third"));
    }

    @Test
    public void createUseForPlaceRelationshipWithLeftPlaceAtTheStartWithMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 1");
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 2");
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, 0, -1);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r3, 0);
        this.assertLeftPlace(r1, 2);
        this.assertLeftPlace(r2, 3);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r3, r1, r2));
        this.assertMetadataOrder(this.publication1, "dc.contributor.author", List.of("Author, Third", "MDV 1", "Author, First", "Author, Second", "MDV 2"));
    }

    @Test
    public void createUseForPlaceRelationshipWithLeftPlaceInTheMiddleWithMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 1");
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 2");
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, 2, -1);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 1);
        this.assertLeftPlace(r3, 2);
        this.assertLeftPlace(r2, 3);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r1, r3, r2));
        this.assertMetadataOrder(this.publication1, "dc.contributor.author", List.of("MDV 1", "Author, First", "Author, Third", "Author, Second", "MDV 2"));
    }

    @Test
    public void createUseForPlaceRelationshipWithLeftPlaceInTheMiddleWithMetadataTest_ignoreOtherRels() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 1");
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship ur1 = this.relationshipService.create(this.context, this.publication1, this.project1, this.isProjectOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 2");
        Relationship ur2 = this.relationshipService.create(this.context, this.author2, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, 2, -1);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 1);
        this.assertLeftPlace(r3, 2);
        this.assertLeftPlace(r2, 3);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r1, r3, r2));
        this.assertMetadataOrder(this.publication1, "dc.contributor.author", List.of("MDV 1", "Author, First", "Author, Third", "Author, Second", "MDV 2"));
        this.assertLeftPlace(ur1, 0);
        this.assertRightPlace(ur1, 0);
        this.assertLeftPlace(ur2, 0);
        this.assertRightPlace(ur2, 0);
    }

    @Test
    public void createUseForPlaceRelationshipWithLeftPlaceAtTheEndWithMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 1");
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 2");
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, 4, -1);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 1);
        this.assertLeftPlace(r2, 2);
        this.assertLeftPlace(r3, 4);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r1, r2, r3));
        this.assertMetadataOrder(this.publication1, "dc.contributor.author", List.of("MDV 1", "Author, First", "Author, Second", "MDV 2", "Author, Third"));
    }

    @Test
    public void createUseForPlaceRelationshipAppendingRightNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication2, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication3, this.author1, this.isAuthorOfPublication, -1, -1);
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r1, 0);
        this.assertRightPlace(r2, 1);
        this.assertRightPlace(r3, 2);
        this.assertRelationMetadataOrder(this.author1, this.isAuthorOfPublication, List.of(r1, r2, r3));
    }

    @Test
    public void createUseForPlaceRelationshipWithRightPlaceAtTheStartNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication2, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication3, this.author1, this.isAuthorOfPublication, -1, 0);
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r3, 0);
        this.assertRightPlace(r1, 1);
        this.assertRightPlace(r2, 2);
        this.assertRelationMetadataOrder(this.author1, this.isAuthorOfPublication, List.of(r3, r1, r2));
    }

    @Test
    public void createUseForPlaceRelationshipWithRightPlaceInTheMiddleNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication2, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication3, this.author1, this.isAuthorOfPublication, -1, 1);
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r1, 0);
        this.assertRightPlace(r3, 1);
        this.assertRightPlace(r2, 2);
        this.assertRelationMetadataOrder(this.author1, this.isAuthorOfPublication, List.of(r1, r3, r2));
    }

    @Test
    public void createUseForPlaceRelationshipWithRightPlaceInTheMiddleNoMetadataTest_ignoreOtherRels() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication2, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship ur1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship ur2 = this.relationshipService.create(this.context, this.author1, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication3, this.author1, this.isAuthorOfPublication, -1, 1);
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r1, 0);
        this.assertRightPlace(r3, 1);
        this.assertRightPlace(r2, 2);
        this.assertRelationMetadataOrder(this.author1, this.isAuthorOfPublication, List.of(r1, r3, r2));
        this.assertLeftPlace(ur1, 0);
        this.assertRightPlace(ur1, 0);
        this.assertLeftPlace(ur2, 1);
        this.assertRightPlace(ur2, 0);
    }

    @Test
    public void createUseForPlaceRelationshipWithRightPlaceAtTheEndNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication2, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication3, this.author1, this.isAuthorOfPublication, -1, 2);
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r1, 0);
        this.assertRightPlace(r2, 1);
        this.assertRightPlace(r3, 2);
        this.assertRelationMetadataOrder(this.author1, this.isAuthorOfPublication, List.of(r1, r2, r3));
    }

    @Test
    public void createNonUseForPlaceRelationshipAppendingLeftTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author1, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author1, this.project3, this.isProjectOfPerson, -1, -1);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r2, 1);
        this.assertLeftPlace(r3, 2);
        this.assertRelationMetadataOrder(this.author1, this.isProjectOfPerson, List.of(r1, r2, r3));
    }

    @Test
    public void createNonUseForPlaceRelationshipWithLeftPlaceAtTheStartTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author1, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author1, this.project3, this.isProjectOfPerson, 0, -1);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r3, 0);
        this.assertLeftPlace(r1, 1);
        this.assertLeftPlace(r2, 2);
        this.assertRelationMetadataOrder(this.author1, this.isProjectOfPerson, List.of(r3, r1, r2));
    }

    @Test
    public void createNonUseForPlaceRelationshipWithLeftPlaceInTheMiddleTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author1, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author1, this.project3, this.isProjectOfPerson, 1, -1);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r3, 1);
        this.assertLeftPlace(r2, 2);
        this.assertRelationMetadataOrder(this.author1, this.isProjectOfPerson, List.of(r1, r3, r2));
    }

    @Test
    public void createNonUseForPlaceRelationshipWithLeftPlaceInTheMiddleTest_ignoreOtherRels() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author1, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship ur1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author1, this.project3, this.isProjectOfPerson, 1, -1);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r3, 1);
        this.assertLeftPlace(r2, 2);
        this.assertRelationMetadataOrder(this.author1, this.isProjectOfPerson, List.of(r1, r3, r2));
        this.assertLeftPlace(ur1, 0);
        this.assertRightPlace(ur1, 0);
    }

    @Test
    public void createNonUseForPlaceRelationshipWithLeftPlaceAtTheEndTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author1, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author1, this.project3, this.isProjectOfPerson, 2, -1);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r2, 1);
        this.assertLeftPlace(r3, 2);
        this.assertRelationMetadataOrder(this.author1, this.isProjectOfPerson, List.of(r1, r2, r3));
    }

    @Test
    public void createNonUseForPlaceRelationshipAppendingRightTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author2, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author3, this.project1, this.isProjectOfPerson, -1, -1);
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r1, 0);
        this.assertRightPlace(r2, 1);
        this.assertRightPlace(r3, 2);
        this.assertRelationMetadataOrder(this.project1, this.isProjectOfPerson, List.of(r1, r2, r3));
    }

    @Test
    public void createNonUseForPlaceRelationshipWithRightPlaceAtTheStartTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author2, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author3, this.project1, this.isProjectOfPerson, -1, 0);
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r3, 0);
        this.assertRightPlace(r1, 1);
        this.assertRightPlace(r2, 2);
        this.assertRelationMetadataOrder(this.project1, this.isProjectOfPerson, List.of(r3, r1, r2));
    }

    @Test
    public void createNonUseForPlaceRelationshipWithRightPlaceInTheMiddleTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author2, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author3, this.project1, this.isProjectOfPerson, -1, 1);
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r1, 0);
        this.assertRightPlace(r3, 1);
        this.assertRightPlace(r2, 2);
        this.assertRelationMetadataOrder(this.project1, this.isProjectOfPerson, List.of(r1, r3, r2));
    }

    @Test
    public void createNonUseForPlaceRelationshipWithRightPlaceInTheMiddleTest_ignoreOtherRels() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author2, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author3, this.project1, this.isProjectOfPerson, -1, 1);
        Relationship ur1 = this.relationshipService.create(this.context, this.publication1, this.project1, this.isProjectOfPublication, -1, -1);
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r1, 0);
        this.assertRightPlace(r3, 1);
        this.assertRightPlace(r2, 2);
        this.assertRelationMetadataOrder(this.project1, this.isProjectOfPerson, List.of(r1, r3, r2));
        this.assertLeftPlace(ur1, 0);
        this.assertRightPlace(ur1, 0);
    }

    @Test
    public void createNonUseForPlaceRelationshipWithRightPlaceAtTheEndTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author2, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author3, this.project1, this.isProjectOfPerson, -1, 2);
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r1, 0);
        this.assertRightPlace(r2, 1);
        this.assertRightPlace(r3, 2);
        this.assertRelationMetadataOrder(this.project1, this.isProjectOfPerson, List.of(r1, r2, r3));
    }

    @Test
    public void moveUseForPlaceRelationshipToCurrentLeftPlaceNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r1, Integer.valueOf(0), null);
        this.relationshipService.move(this.context, r2, Integer.valueOf(1), null);
        this.relationshipService.move(this.context, r3, Integer.valueOf(2), null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r2, 1);
        this.assertLeftPlace(r3, 2);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r1, r2, r3));
    }

    @Test
    public void moveUseForPlaceRelationshipToLeftPlaceAtTheStartNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r3, Integer.valueOf(0), null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r3, 0);
        this.assertLeftPlace(r1, 1);
        this.assertLeftPlace(r2, 2);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r3, r1, r2));
    }

    @Test
    public void moveUseForPlaceRelationshipUpToLeftPlaceInTheMiddleNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r1, Integer.valueOf(1), null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r2, 0);
        this.assertLeftPlace(r1, 1);
        this.assertLeftPlace(r3, 2);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r2, r1, r3));
    }

    @Test
    public void moveUseForPlaceRelationshipDownToLeftPlaceInTheMiddleNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r3, Integer.valueOf(1), null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r3, 1);
        this.assertLeftPlace(r2, 2);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r1, r3, r2));
    }

    @Test
    public void moveUseForPlaceRelationshipToLeftPlaceAtTheEndNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r1, Integer.valueOf(-1), null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r2, 0);
        this.assertLeftPlace(r3, 1);
        this.assertLeftPlace(r1, 2);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r2, r3, r1));
    }

    @Test
    public void moveUseForPlaceRelationshipToLeftPlaceAtTheEndOverlapNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r1, Integer.valueOf(2), null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r2, 0);
        this.assertLeftPlace(r3, 1);
        this.assertLeftPlace(r1, 2);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r2, r3, r1));
    }

    @Test
    public void moveUseForPlaceRelationshipToCurrentLeftPlaceWithMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 1");
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 2");
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r1, Integer.valueOf(1), null);
        this.relationshipService.move(this.context, r2, Integer.valueOf(2), null);
        this.relationshipService.move(this.context, r3, Integer.valueOf(4), null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 1);
        this.assertLeftPlace(r2, 2);
        this.assertLeftPlace(r3, 4);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r1, r2, r3));
        this.assertMetadataOrder(this.publication1, "dc.contributor.author", List.of("MDV 1", "Author, First", "Author, Second", "MDV 2", "Author, Third"));
    }

    @Test
    public void moveUseForPlaceRelationshipToLeftPlaceAtTheStartWithMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 1");
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 2");
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r3, Integer.valueOf(0), null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r3, 0);
        this.assertLeftPlace(r1, 2);
        this.assertLeftPlace(r2, 3);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r3, r1, r2));
        this.assertMetadataOrder(this.publication1, "dc.contributor.author", List.of("Author, Third", "MDV 1", "Author, First", "Author, Second", "MDV 2"));
    }

    @Test
    public void moveUseForPlaceRelationshipUpToLeftPlaceInTheMiddleWithTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 1");
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 2");
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r1, Integer.valueOf(3), null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r2, 1);
        this.assertLeftPlace(r1, 3);
        this.assertLeftPlace(r3, 4);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r2, r1, r3));
    }

    @Test
    public void moveUseForPlaceRelationshipUpToLeftPlaceInTheMiddleWithTest_ignoreOtherRels() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship ur1 = this.relationshipService.create(this.context, this.publication1, this.project1, this.isProjectOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 1");
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship ur2 = this.relationshipService.create(this.context, this.publication1, this.project2, this.isProjectOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 2");
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r1, Integer.valueOf(3), null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r2, 1);
        this.assertLeftPlace(r1, 3);
        this.assertLeftPlace(r3, 4);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r2, r1, r3));
        this.assertLeftPlace(ur1, 0);
        this.assertRightPlace(ur1, 0);
        this.assertLeftPlace(ur2, 1);
        this.assertRightPlace(ur2, 0);
    }

    @Test
    public void moveUseForPlaceRelationshipDownToLeftPlaceInTheMiddleWithMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 1");
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 2");
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r3, Integer.valueOf(2), null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 1);
        this.assertLeftPlace(r3, 2);
        this.assertLeftPlace(r2, 3);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r1, r3, r2));
    }

    @Test
    public void moveUseForPlaceRelationshipDownToLeftPlaceInTheMiddleWithMetadataTest_ignoreOtherRels() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 1");
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship ur1 = this.relationshipService.create(this.context, this.publication1, this.project1, this.isProjectOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 2");
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        Relationship ur2 = this.relationshipService.create(this.context, this.author2, this.project2, this.isProjectOfPerson, -1, -1);
        this.relationshipService.move(this.context, r3, Integer.valueOf(2), null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 1);
        this.assertLeftPlace(r3, 2);
        this.assertLeftPlace(r2, 3);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r1, r3, r2));
        this.assertLeftPlace(ur1, 0);
        this.assertRightPlace(ur1, 0);
        this.assertLeftPlace(ur2, 0);
        this.assertRightPlace(ur2, 0);
    }

    @Test
    public void moveUseForPlaceRelationshipToLeftPlaceAtTheEndWithMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 1");
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 2");
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r1, Integer.valueOf(-1), null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r2, 1);
        this.assertLeftPlace(r3, 3);
        this.assertLeftPlace(r1, 4);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r2, r3, r1));
    }

    @Test
    public void moveUseForPlaceRelationshipToLeftPlaceAtTheEndOverlapWithMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 1");
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 2");
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r1, Integer.valueOf(4), null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r2, 1);
        this.assertLeftPlace(r3, 3);
        this.assertLeftPlace(r1, 4);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r2, r3, r1));
    }

    @Test
    public void moveUseForPlaceRelationshipToCurrentRightPlaceNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication2, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication3, this.author1, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r1, null, Integer.valueOf(0));
        this.relationshipService.move(this.context, r2, null, Integer.valueOf(1));
        this.relationshipService.move(this.context, r3, null, Integer.valueOf(2));
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r1, 0);
        this.assertRightPlace(r2, 1);
        this.assertRightPlace(r3, 2);
        this.assertRelationMetadataOrder(this.author1, this.isAuthorOfPublication, List.of(r1, r2, r3));
    }

    @Test
    public void moveUseForPlaceRelationshipToRightPlaceAtTheStartNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication2, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication3, this.author1, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r3, null, Integer.valueOf(0));
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r3, 0);
        this.assertRightPlace(r1, 1);
        this.assertRightPlace(r2, 2);
        this.assertRelationMetadataOrder(this.author1, this.isAuthorOfPublication, List.of(r3, r1, r2));
    }

    @Test
    public void moveUseForPlaceRelationshipUpToRightPlaceInTheMiddleNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication2, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication3, this.author1, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r1, null, Integer.valueOf(1));
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r2, 0);
        this.assertRightPlace(r1, 1);
        this.assertRightPlace(r3, 2);
        this.assertRelationMetadataOrder(this.author1, this.isAuthorOfPublication, List.of(r2, r1, r3));
    }

    @Test
    public void moveUseForPlaceRelationshipDownToRightPlaceInTheMiddleNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication2, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication3, this.author1, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r3, null, Integer.valueOf(1));
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r1, 0);
        this.assertRightPlace(r3, 1);
        this.assertRightPlace(r2, 2);
        this.assertRelationMetadataOrder(this.author1, this.isAuthorOfPublication, List.of(r1, r3, r2));
    }

    @Test
    public void moveUseForPlaceRelationshipToRightPlaceAtTheEndNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication2, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication3, this.author1, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r1, null, Integer.valueOf(-1));
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r2, 0);
        this.assertRightPlace(r3, 1);
        this.assertRightPlace(r1, 2);
        this.assertRelationMetadataOrder(this.author1, this.isAuthorOfPublication, List.of(r2, r3, r1));
    }

    @Test
    public void moveUseForPlaceRelationshipToRightPlaceAtTheEndOverlapNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication2, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication3, this.author1, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r1, null, Integer.valueOf(2));
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r2, 0);
        this.assertRightPlace(r3, 1);
        this.assertRightPlace(r1, 2);
        this.assertRelationMetadataOrder(this.author1, this.isAuthorOfPublication, List.of(r2, r3, r1));
    }

    @Test
    public void moveNonUseForPlaceRelationshipToCurrentLeftPlaceNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author1, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author1, this.project3, this.isProjectOfPerson, -1, -1);
        this.relationshipService.move(this.context, r1, Integer.valueOf(0), null);
        this.relationshipService.move(this.context, r2, Integer.valueOf(1), null);
        this.relationshipService.move(this.context, r3, Integer.valueOf(2), null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r2, 1);
        this.assertLeftPlace(r3, 2);
        this.assertRelationMetadataOrder(this.author1, this.isProjectOfPerson, List.of(r1, r2, r3));
    }

    @Test
    public void moveNonUseForPlaceRelationshipToLeftPlaceAtTheStartNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author1, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author1, this.project3, this.isProjectOfPerson, -1, -1);
        this.relationshipService.move(this.context, r3, Integer.valueOf(0), null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r3, 0);
        this.assertLeftPlace(r1, 1);
        this.assertLeftPlace(r2, 2);
        this.assertRelationMetadataOrder(this.author1, this.isProjectOfPerson, List.of(r3, r1, r2));
    }

    @Test
    public void moveNonUseForPlaceRelationshipUpToLeftPlaceInTheMiddleNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author1, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author1, this.project3, this.isProjectOfPerson, -1, -1);
        this.relationshipService.move(this.context, r1, Integer.valueOf(1), null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r2, 0);
        this.assertLeftPlace(r1, 1);
        this.assertLeftPlace(r3, 2);
        this.assertRelationMetadataOrder(this.author1, this.isProjectOfPerson, List.of(r2, r1, r3));
    }

    @Test
    public void moveNonUseForPlaceRelationshipDownToLeftPlaceInTheMiddleNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author1, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author1, this.project3, this.isProjectOfPerson, -1, -1);
        this.relationshipService.move(this.context, r3, Integer.valueOf(1), null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r3, 1);
        this.assertLeftPlace(r2, 2);
        this.assertRelationMetadataOrder(this.author1, this.isProjectOfPerson, List.of(r1, r3, r2));
    }

    @Test
    public void moveNonUseForPlaceRelationshipToLeftPlaceAtTheEndNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author1, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author1, this.project3, this.isProjectOfPerson, -1, -1);
        this.relationshipService.move(this.context, r1, Integer.valueOf(-1), null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r2, 0);
        this.assertLeftPlace(r3, 1);
        this.assertLeftPlace(r1, 2);
        this.assertRelationMetadataOrder(this.author1, this.isProjectOfPerson, List.of(r2, r3, r1));
    }

    @Test
    public void moveNonUseForPlaceRelationshipToLeftPlaceAtTheEndOverlapNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author1, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author1, this.project3, this.isProjectOfPerson, -1, -1);
        this.relationshipService.move(this.context, r1, Integer.valueOf(2), null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r2, 0);
        this.assertLeftPlace(r3, 1);
        this.assertLeftPlace(r1, 2);
        this.assertRelationMetadataOrder(this.author1, this.isProjectOfPerson, List.of(r2, r3, r1));
    }

    @Test
    public void moveNonUseForPlaceRelationshipToCurrentRightPlaceNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author2, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author3, this.project1, this.isProjectOfPerson, -1, -1);
        this.relationshipService.move(this.context, r1, null, Integer.valueOf(0));
        this.relationshipService.move(this.context, r2, null, Integer.valueOf(1));
        this.relationshipService.move(this.context, r3, null, Integer.valueOf(2));
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r1, 0);
        this.assertRightPlace(r2, 1);
        this.assertRightPlace(r3, 2);
        this.assertRelationMetadataOrder(this.project1, this.isProjectOfPerson, List.of(r1, r2, r3));
    }

    @Test
    public void moveNonUseForPlaceRelationshipToRightPlaceAtTheStartNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author2, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author3, this.project1, this.isProjectOfPerson, -1, -1);
        this.relationshipService.move(this.context, r3, null, Integer.valueOf(0));
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r3, 0);
        this.assertRightPlace(r1, 1);
        this.assertRightPlace(r2, 2);
        this.assertRelationMetadataOrder(this.project1, this.isProjectOfPerson, List.of(r3, r1, r2));
    }

    @Test
    public void moveNonUseForPlaceRelationshipUpToRightPlaceInTheMiddleNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author2, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author3, this.project1, this.isProjectOfPerson, -1, -1);
        this.relationshipService.move(this.context, r1, null, Integer.valueOf(1));
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r2, 0);
        this.assertRightPlace(r1, 1);
        this.assertRightPlace(r3, 2);
        this.assertRelationMetadataOrder(this.project1, this.isProjectOfPerson, List.of(r2, r1, r3));
    }

    @Test
    public void moveNonUseForPlaceRelationshipUpToRightPlaceInTheMiddleNoMetadataTest_ignoreOtherRels() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship ur1 = this.relationshipService.create(this.context, this.publication1, this.project1, this.isProjectOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author2, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship ur2 = this.relationshipService.create(this.context, this.publication2, this.project1, this.isProjectOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author3, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship ur3 = this.relationshipService.create(this.context, this.publication3, this.project1, this.isProjectOfPublication, -1, -1);
        this.relationshipService.move(this.context, r1, null, Integer.valueOf(1));
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r2, 0);
        this.assertRightPlace(r1, 1);
        this.assertRightPlace(r3, 2);
        this.assertRelationMetadataOrder(this.project1, this.isProjectOfPerson, List.of(r2, r1, r3));
        this.assertLeftPlace(ur1, 0);
        this.assertRightPlace(ur1, 0);
        this.assertLeftPlace(ur2, 0);
        this.assertRightPlace(ur2, 1);
        this.assertLeftPlace(ur3, 0);
        this.assertRightPlace(ur3, 2);
    }

    @Test
    public void moveNonUseForPlaceRelationshipDownToRightPlaceInTheMiddleNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author2, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author3, this.project1, this.isProjectOfPerson, -1, -1);
        this.relationshipService.move(this.context, r3, null, Integer.valueOf(1));
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r1, 0);
        this.assertRightPlace(r3, 1);
        this.assertRightPlace(r2, 2);
        this.assertRelationMetadataOrder(this.project1, this.isProjectOfPerson, List.of(r1, r3, r2));
    }

    @Test
    public void moveNonUseForPlaceRelationshipDownToRightPlaceInTheMiddleNoMetadataTest_ignoreOtherRels() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author2, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship ur1 = this.relationshipService.create(this.context, this.publication1, this.project1, this.isProjectOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author3, this.project1, this.isProjectOfPerson, -1, -1);
        this.relationshipService.move(this.context, r3, null, Integer.valueOf(1));
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r1, 0);
        this.assertRightPlace(r3, 1);
        this.assertRightPlace(r2, 2);
        this.assertRelationMetadataOrder(this.project1, this.isProjectOfPerson, List.of(r1, r3, r2));
        this.assertLeftPlace(ur1, 0);
        this.assertRightPlace(ur1, 0);
    }

    @Test
    public void moveNonUseForPlaceRelationshipToRightPlaceAtTheEndNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author2, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author3, this.project1, this.isProjectOfPerson, -1, -1);
        this.relationshipService.move(this.context, r1, null, Integer.valueOf(-1));
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r2, 0);
        this.assertRightPlace(r3, 1);
        this.assertRightPlace(r1, 2);
        this.assertRelationMetadataOrder(this.project1, this.isProjectOfPerson, List.of(r2, r3, r1));
    }

    @Test
    public void deleteUseForPlaceRelationshipFromLeftStartNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.delete(this.context, (Object)r1);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r2, 0);
        this.assertLeftPlace(r3, 1);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r2, r3));
    }

    @Test
    public void deleteUseForPlaceRelationshipFromLeftMiddleNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.delete(this.context, (Object)r2);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r3, 1);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r1, r3));
    }

    @Test
    public void deleteUseForPlaceRelationshipFromLeftEndNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.delete(this.context, (Object)r3);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r2, 1);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r1, r2));
    }

    @Test
    public void deleteUseForPlaceRelationshipFromLeftStartWithMetadataNoCopyTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 1");
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 2");
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.delete(this.context, r1, false, false);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r2, 1);
        this.assertLeftPlace(r3, 3);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r2, r3));
        this.assertMetadataOrder(this.publication1, "dc.contributor.author", List.of("MDV 1", "Author, Second", "MDV 2", "Author, Third"));
    }

    @Test
    public void deleteUseForPlaceRelationshipFromLeftStartWithMetadataCopyTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 1");
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 2");
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.delete(this.context, r1, true, false);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r2, 2);
        this.assertLeftPlace(r3, 4);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, Arrays.asList(null, r2, r3));
        this.assertMetadataOrder(this.publication1, "dc.contributor.author", List.of("Author, First", "MDV 1", "Author, Second", "MDV 2", "Author, Third"));
    }

    @Test
    public void deleteUseForPlaceRelationshipFromLeftMiddleWithMetadataNoCopyTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 1");
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 2");
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.delete(this.context, r2, false, false);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r3, 3);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, Arrays.asList(r1, r3));
        this.assertMetadataOrder(this.publication1, "dc.contributor.author", List.of("Author, First", "MDV 1", "MDV 2", "Author, Third"));
    }

    @Test
    public void deleteUseForPlaceRelationshipFromLeftMiddleWithMetadataNoCopyTest_ignoreOtherRels() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 1");
        Relationship ur1 = this.relationshipService.create(this.context, this.publication1, this.project1, this.isProjectOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 2");
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.delete(this.context, r2, false, false);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r3, 3);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, Arrays.asList(r1, r3));
        this.assertMetadataOrder(this.publication1, "dc.contributor.author", List.of("Author, First", "MDV 1", "MDV 2", "Author, Third"));
        this.assertLeftPlace(ur1, 0);
        this.assertRightPlace(ur1, 0);
    }

    @Test
    public void deleteUseForPlaceRelationshipFromLeftMiddleWithMetadataCopyTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 1");
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 2");
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.delete(this.context, r2, true, false);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r3, 4);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, Arrays.asList(r1, null, r3));
        this.assertMetadataOrder(this.publication1, "dc.contributor.author", List.of("Author, First", "MDV 1", "Author, Second", "MDV 2", "Author, Third"));
    }

    @Test
    public void deleteUseForPlaceRelationshipFromLeftMiddleWithMetadataCopyTest_ignoreOtherRels() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship ur1 = this.relationshipService.create(this.context, this.publication1, this.project1, this.isProjectOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 1");
        Relationship ur2 = this.relationshipService.create(this.context, this.publication1, this.project2, this.isProjectOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship ur3 = this.relationshipService.create(this.context, this.author2, this.project1, this.isProjectOfPerson, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 2");
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.delete(this.context, r2, true, false);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r3, 4);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, Arrays.asList(r1, null, r3));
        this.assertMetadataOrder(this.publication1, "dc.contributor.author", List.of("Author, First", "MDV 1", "Author, Second", "MDV 2", "Author, Third"));
        this.assertLeftPlace(ur1, 0);
        this.assertRightPlace(ur1, 0);
        this.assertLeftPlace(ur2, 1);
        this.assertRightPlace(ur2, 0);
        this.assertLeftPlace(ur3, 0);
        this.assertRightPlace(ur3, 0);
    }

    @Test
    public void deleteUseForPlaceRelationshipFromLeftEndWithMetadataNoCopyTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 1");
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 2");
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.delete(this.context, r3, false, false);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r2, 2);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, Arrays.asList(r1, r2));
        this.assertMetadataOrder(this.publication1, "dc.contributor.author", List.of("Author, First", "MDV 1", "Author, Second", "MDV 2"));
    }

    @Test
    public void deleteUseForPlaceRelationshipFromLeftEndWithMetadataCopyTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 1");
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 2");
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.delete(this.context, r3, true, false);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r2, 2);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, Arrays.asList(r1, r2, null));
        this.assertMetadataOrder(this.publication1, "dc.contributor.author", List.of("Author, First", "MDV 1", "Author, Second", "MDV 2", "Author, Third"));
    }

    @Test
    public void deleteUseForPlaceRelationshipFromRightStartNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication2, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication3, this.author1, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.delete(this.context, (Object)r1);
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r2, 0);
        this.assertRightPlace(r3, 1);
        this.assertRelationMetadataOrder(this.author1, this.isAuthorOfPublication, List.of(r2, r3));
    }

    @Test
    public void deleteUseForPlaceRelationshipFromRightMiddleNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication2, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication3, this.author1, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.delete(this.context, (Object)r2);
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r1, 0);
        this.assertRightPlace(r3, 1);
        this.assertRelationMetadataOrder(this.author1, this.isAuthorOfPublication, List.of(r1, r3));
    }

    @Test
    public void deleteUseForPlaceRelationshipFromRightEndNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication2, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication3, this.author1, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.delete(this.context, (Object)r3);
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r1, 0);
        this.assertRightPlace(r2, 1);
        this.assertRelationMetadataOrder(this.author1, this.isAuthorOfPublication, List.of(r1, r2));
    }

    @Test
    public void deleteNonUseForPlaceRelationshipFromLeftStartNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author1, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author1, this.project3, this.isProjectOfPerson, -1, -1);
        this.relationshipService.delete(this.context, (Object)r1);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r2, 0);
        this.assertLeftPlace(r3, 1);
        this.assertRelationMetadataOrder(this.author1, this.isProjectOfPerson, List.of(r2, r3));
    }

    @Test
    public void deleteNonUseForPlaceRelationshipFromLeftMiddleNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author1, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author1, this.project3, this.isProjectOfPerson, -1, -1);
        this.relationshipService.delete(this.context, (Object)r2);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r3, 1);
        this.assertRelationMetadataOrder(this.author1, this.isProjectOfPerson, List.of(r1, r3));
    }

    @Test
    public void deleteNonUseForPlaceRelationshipFromLeftEndNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author1, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author1, this.project3, this.isProjectOfPerson, -1, -1);
        this.relationshipService.delete(this.context, (Object)r3);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r2, 1);
        this.assertRelationMetadataOrder(this.author1, this.isProjectOfPerson, List.of(r1, r2));
    }

    @Test
    public void deleteNonUseForPlaceRelationshipFromRightStartNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author2, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author3, this.project1, this.isProjectOfPerson, -1, -1);
        this.relationshipService.delete(this.context, (Object)r1);
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r2, 0);
        this.assertRightPlace(r3, 1);
        this.assertRelationMetadataOrder(this.project1, this.isProjectOfPerson, List.of(r2, r3));
    }

    @Test
    public void deleteNonUseForPlaceRelationshipFromRightMiddleNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author2, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author3, this.project1, this.isProjectOfPerson, -1, -1);
        this.relationshipService.delete(this.context, (Object)r2);
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r1, 0);
        this.assertRightPlace(r3, 1);
        this.assertRelationMetadataOrder(this.project1, this.isProjectOfPerson, List.of(r1, r3));
    }

    @Test
    public void deleteNonUseForPlaceRelationshipFromRightMiddleNoMetadataTest_ignoreOtherRels() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author2, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship ur1 = this.relationshipService.create(this.context, this.publication1, this.project1, this.isProjectOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author3, this.project1, this.isProjectOfPerson, -1, -1);
        this.relationshipService.delete(this.context, (Object)r2);
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r1, 0);
        this.assertRightPlace(r3, 1);
        this.assertRelationMetadataOrder(this.project1, this.isProjectOfPerson, List.of(r1, r3));
        this.assertLeftPlace(ur1, 0);
        this.assertRightPlace(ur1, 0);
    }

    @Test
    public void deleteNonUseForPlaceRelationshipFromRightEndNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author2, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author3, this.project1, this.isProjectOfPerson, -1, -1);
        this.relationshipService.delete(this.context, (Object)r3);
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r1, 0);
        this.assertRightPlace(r2, 1);
        this.assertRelationMetadataOrder(this.project1, this.isProjectOfPerson, List.of(r1, r2));
    }

    @Test
    public void changeLeftItemInUseForPlaceRelationshipAtTheStartNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        Relationship r4 = this.relationshipService.create(this.context, this.publication2, this.author4, this.isAuthorOfPublication, -1, -1);
        Relationship r5 = this.relationshipService.create(this.context, this.publication2, this.author5, this.isAuthorOfPublication, -1, -1);
        Relationship r6 = this.relationshipService.create(this.context, this.publication2, this.author6, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r1, this.publication2, null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r2, 0);
        this.assertLeftPlace(r3, 1);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r2, r3));
        this.assertLeftPlace(r4, 0);
        this.assertLeftPlace(r5, 1);
        this.assertLeftPlace(r6, 2);
        this.assertLeftPlace(r1, 3);
        this.assertRelationMetadataOrder(this.publication2, this.isAuthorOfPublication, List.of(r4, r5, r6, r1));
    }

    @Test
    public void changeLeftItemInUseForPlaceRelationshipInTheMiddleNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        Relationship r4 = this.relationshipService.create(this.context, this.publication2, this.author4, this.isAuthorOfPublication, -1, -1);
        Relationship r5 = this.relationshipService.create(this.context, this.publication2, this.author5, this.isAuthorOfPublication, -1, -1);
        Relationship r6 = this.relationshipService.create(this.context, this.publication2, this.author6, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r2, this.publication2, null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r3, 1);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r1, r3));
        this.assertLeftPlace(r4, 0);
        this.assertLeftPlace(r5, 1);
        this.assertLeftPlace(r6, 2);
        this.assertLeftPlace(r2, 3);
        this.assertRelationMetadataOrder(this.publication2, this.isAuthorOfPublication, List.of(r4, r5, r6, r2));
    }

    @Test
    public void changeLeftItemInUseForPlaceRelationshipAtTheEndNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        Relationship r4 = this.relationshipService.create(this.context, this.publication2, this.author4, this.isAuthorOfPublication, -1, -1);
        Relationship r5 = this.relationshipService.create(this.context, this.publication2, this.author5, this.isAuthorOfPublication, -1, -1);
        Relationship r6 = this.relationshipService.create(this.context, this.publication2, this.author6, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r3, this.publication2, null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r2, 1);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r1, r2));
        this.assertLeftPlace(r4, 0);
        this.assertLeftPlace(r5, 1);
        this.assertLeftPlace(r6, 2);
        this.assertLeftPlace(r3, 3);
        this.assertRelationMetadataOrder(this.publication2, this.isAuthorOfPublication, List.of(r4, r5, r6, r3));
    }

    @Test
    public void changeLeftItemInUseForPlaceRelationshipAtTheStartWithMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 1");
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 2");
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication2, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 3");
        Relationship r4 = this.relationshipService.create(this.context, this.publication2, this.author4, this.isAuthorOfPublication, -1, -1);
        Relationship r5 = this.relationshipService.create(this.context, this.publication2, this.author5, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication2, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 4");
        Relationship r6 = this.relationshipService.create(this.context, this.publication2, this.author6, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r1, this.publication2, null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r2, 1);
        this.assertLeftPlace(r3, 3);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r2, r3));
        this.assertMetadataOrder(this.publication1, "dc.contributor.author", List.of("MDV 1", "Author, Second", "MDV 2", "Author, Third"));
        this.assertLeftPlace(r4, 1);
        this.assertLeftPlace(r5, 2);
        this.assertLeftPlace(r6, 4);
        this.assertLeftPlace(r1, 5);
        this.assertRelationMetadataOrder(this.publication2, this.isAuthorOfPublication, List.of(r4, r5, r6, r1));
        this.assertMetadataOrder(this.publication2, "dc.contributor.author", List.of("MDV 3", "Author, Fourth", "Author, Fifth", "MDV 4", "Author, Sixth", "Author, First"));
    }

    @Test
    public void changeLeftItemInUseForPlaceRelationshipInTheMiddleWithMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 1");
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 2");
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication2, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 3");
        Relationship r4 = this.relationshipService.create(this.context, this.publication2, this.author4, this.isAuthorOfPublication, -1, -1);
        Relationship r5 = this.relationshipService.create(this.context, this.publication2, this.author5, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication2, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 4");
        Relationship r6 = this.relationshipService.create(this.context, this.publication2, this.author6, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r2, this.publication2, null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r3, 3);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r1, r3));
        this.assertMetadataOrder(this.publication1, "dc.contributor.author", List.of("Author, First", "MDV 1", "MDV 2", "Author, Third"));
        this.assertLeftPlace(r4, 1);
        this.assertLeftPlace(r5, 2);
        this.assertLeftPlace(r6, 4);
        this.assertLeftPlace(r2, 5);
        this.assertRelationMetadataOrder(this.publication2, this.isAuthorOfPublication, List.of(r4, r5, r6, r2));
        this.assertMetadataOrder(this.publication2, "dc.contributor.author", List.of("MDV 3", "Author, Fourth", "Author, Fifth", "MDV 4", "Author, Sixth", "Author, Second"));
    }

    @Test
    public void changeLeftItemInUseForPlaceRelationshipInTheMiddleWithMetadataTest_ignoreOtherRels() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 1");
        Relationship ur1 = this.relationshipService.create(this.context, this.publication1, this.project1, this.isProjectOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 2");
        Relationship ur2 = this.relationshipService.create(this.context, this.publication1, this.project3, this.isProjectOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        Relationship ur3 = this.relationshipService.create(this.context, this.publication2, this.project2, this.isProjectOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication2, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 3");
        Relationship r4 = this.relationshipService.create(this.context, this.publication2, this.author4, this.isAuthorOfPublication, -1, -1);
        Relationship r5 = this.relationshipService.create(this.context, this.publication2, this.author5, this.isAuthorOfPublication, -1, -1);
        Relationship ur4 = this.relationshipService.create(this.context, this.publication2, this.project1, this.isProjectOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication2, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 4");
        Relationship r6 = this.relationshipService.create(this.context, this.publication2, this.author6, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r2, this.publication2, null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r3, 3);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r1, r3));
        this.assertMetadataOrder(this.publication1, "dc.contributor.author", List.of("Author, First", "MDV 1", "MDV 2", "Author, Third"));
        this.assertLeftPlace(r4, 1);
        this.assertLeftPlace(r5, 2);
        this.assertLeftPlace(r6, 4);
        this.assertLeftPlace(r2, 5);
        this.assertRelationMetadataOrder(this.publication2, this.isAuthorOfPublication, List.of(r4, r5, r6, r2));
        this.assertMetadataOrder(this.publication2, "dc.contributor.author", List.of("MDV 3", "Author, Fourth", "Author, Fifth", "MDV 4", "Author, Sixth", "Author, Second"));
        this.assertLeftPlace(ur1, 0);
        this.assertRightPlace(ur1, 0);
        this.assertLeftPlace(ur2, 1);
        this.assertRightPlace(ur2, 0);
        this.assertLeftPlace(ur3, 0);
        this.assertRightPlace(ur3, 0);
        this.assertLeftPlace(ur4, 1);
        this.assertRightPlace(ur4, 1);
    }

    @Test
    public void changeLeftItemInUseForPlaceRelationshipAtTheEndWithMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 1");
        Relationship r2 = this.relationshipService.create(this.context, this.publication1, this.author2, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication1, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 2");
        Relationship r3 = this.relationshipService.create(this.context, this.publication1, this.author3, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication2, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 3");
        Relationship r4 = this.relationshipService.create(this.context, this.publication2, this.author4, this.isAuthorOfPublication, -1, -1);
        Relationship r5 = this.relationshipService.create(this.context, this.publication2, this.author5, this.isAuthorOfPublication, -1, -1);
        this.itemService.addMetadata(this.context, (DSpaceObject)this.publication2, this.dcSchema, this.contributorElement, this.authorQualifier, null, "MDV 4");
        Relationship r6 = this.relationshipService.create(this.context, this.publication2, this.author6, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r3, this.publication2, null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r2, 2);
        this.assertRelationMetadataOrder(this.publication1, this.isAuthorOfPublication, List.of(r1, r2));
        this.assertMetadataOrder(this.publication1, "dc.contributor.author", List.of("Author, First", "MDV 1", "Author, Second", "MDV 2"));
        this.assertLeftPlace(r4, 1);
        this.assertLeftPlace(r5, 2);
        this.assertLeftPlace(r6, 4);
        this.assertLeftPlace(r3, 5);
        this.assertRelationMetadataOrder(this.publication2, this.isAuthorOfPublication, List.of(r4, r5, r6, r3));
        this.assertMetadataOrder(this.publication2, "dc.contributor.author", List.of("MDV 3", "Author, Fourth", "Author, Fifth", "MDV 4", "Author, Sixth", "Author, Third"));
    }

    @Test
    public void changeRightItemInUseForPlaceRelationshipAtTheStartNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication2, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication3, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r4 = this.relationshipService.create(this.context, this.publication4, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship r5 = this.relationshipService.create(this.context, this.publication5, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship r6 = this.relationshipService.create(this.context, this.publication6, this.author2, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r1, null, this.author2);
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r2, 0);
        this.assertRightPlace(r3, 1);
        this.assertRelationMetadataOrder(this.author1, this.isAuthorOfPublication, List.of(r2, r3));
        this.assertRightPlace(r4, 0);
        this.assertRightPlace(r5, 1);
        this.assertRightPlace(r6, 2);
        this.assertRightPlace(r1, 3);
        this.assertRelationMetadataOrder(this.author2, this.isAuthorOfPublication, List.of(r4, r5, r6, r1));
    }

    @Test
    public void changeRightItemInUseForPlaceRelationshipInTheMiddleNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication2, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication3, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r4 = this.relationshipService.create(this.context, this.publication4, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship r5 = this.relationshipService.create(this.context, this.publication5, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship r6 = this.relationshipService.create(this.context, this.publication6, this.author2, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r2, null, this.author2);
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r1, 0);
        this.assertRightPlace(r3, 1);
        this.assertRelationMetadataOrder(this.author1, this.isAuthorOfPublication, List.of(r1, r3));
        this.assertRightPlace(r4, 0);
        this.assertRightPlace(r5, 1);
        this.assertRightPlace(r6, 2);
        this.assertRightPlace(r2, 3);
        this.assertRelationMetadataOrder(this.author2, this.isAuthorOfPublication, List.of(r4, r5, r6, r2));
    }

    @Test
    public void changeRightItemInUseForPlaceRelationshipInTheMiddleNoMetadataTest_ignoreOtherRels() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication2, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship ur1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication3, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r4 = this.relationshipService.create(this.context, this.publication4, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship r5 = this.relationshipService.create(this.context, this.publication5, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship r6 = this.relationshipService.create(this.context, this.publication6, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship ur2 = this.relationshipService.create(this.context, this.author2, this.project1, this.isProjectOfPerson, -1, -1);
        this.relationshipService.move(this.context, r2, null, this.author2);
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r1, 0);
        this.assertRightPlace(r3, 1);
        this.assertRelationMetadataOrder(this.author1, this.isAuthorOfPublication, List.of(r1, r3));
        this.assertRightPlace(r4, 0);
        this.assertRightPlace(r5, 1);
        this.assertRightPlace(r6, 2);
        this.assertRightPlace(r2, 3);
        this.assertRelationMetadataOrder(this.author2, this.isAuthorOfPublication, List.of(r4, r5, r6, r2));
        this.assertLeftPlace(ur1, 0);
        this.assertRightPlace(ur1, 0);
        this.assertLeftPlace(ur2, 0);
        this.assertRightPlace(ur2, 1);
    }

    @Test
    public void changeRightItemInUseForPlaceRelationshipAtTheEndNoMetadataTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.publication1, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.publication2, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.publication3, this.author1, this.isAuthorOfPublication, -1, -1);
        Relationship r4 = this.relationshipService.create(this.context, this.publication4, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship r5 = this.relationshipService.create(this.context, this.publication5, this.author2, this.isAuthorOfPublication, -1, -1);
        Relationship r6 = this.relationshipService.create(this.context, this.publication6, this.author2, this.isAuthorOfPublication, -1, -1);
        this.relationshipService.move(this.context, r3, null, this.author2);
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r1, 0);
        this.assertRightPlace(r2, 1);
        this.assertRelationMetadataOrder(this.author1, this.isAuthorOfPublication, List.of(r1, r2));
        this.assertRightPlace(r4, 0);
        this.assertRightPlace(r5, 1);
        this.assertRightPlace(r6, 2);
        this.assertRightPlace(r3, 3);
        this.assertRelationMetadataOrder(this.author2, this.isAuthorOfPublication, List.of(r4, r5, r6, r3));
    }

    @Test
    public void changeLeftItemInNonUseForPlaceRelationshipAtTheStart() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author1, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author1, this.project3, this.isProjectOfPerson, -1, -1);
        Relationship r4 = this.relationshipService.create(this.context, this.author2, this.project4, this.isProjectOfPerson, -1, -1);
        Relationship r5 = this.relationshipService.create(this.context, this.author2, this.project5, this.isProjectOfPerson, -1, -1);
        Relationship r6 = this.relationshipService.create(this.context, this.author2, this.project6, this.isProjectOfPerson, -1, -1);
        this.relationshipService.move(this.context, r1, this.author2, null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r2, 0);
        this.assertLeftPlace(r3, 1);
        this.assertRelationMetadataOrder(this.author1, this.isProjectOfPerson, List.of(r2, r3));
        this.assertLeftPlace(r4, 0);
        this.assertLeftPlace(r5, 1);
        this.assertLeftPlace(r6, 2);
        this.assertLeftPlace(r1, 3);
        this.assertRelationMetadataOrder(this.author2, this.isProjectOfPerson, List.of(r4, r5, r6, r1));
    }

    @Test
    public void changeLeftItemInNonUseNonForPlaceRelationshipInTheMiddle() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author1, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author1, this.project3, this.isProjectOfPerson, -1, -1);
        Relationship r4 = this.relationshipService.create(this.context, this.author2, this.project4, this.isProjectOfPerson, -1, -1);
        Relationship r5 = this.relationshipService.create(this.context, this.author2, this.project5, this.isProjectOfPerson, -1, -1);
        Relationship r6 = this.relationshipService.create(this.context, this.author2, this.project6, this.isProjectOfPerson, -1, -1);
        this.relationshipService.move(this.context, r2, this.author2, null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r3, 1);
        this.assertRelationMetadataOrder(this.author1, this.isProjectOfPerson, List.of(r1, r3));
        this.assertLeftPlace(r4, 0);
        this.assertLeftPlace(r5, 1);
        this.assertLeftPlace(r6, 2);
        this.assertLeftPlace(r2, 3);
        this.assertRelationMetadataOrder(this.author2, this.isProjectOfPerson, List.of(r4, r5, r6, r2));
    }

    @Test
    public void changeLeftItemInNonUseForPlaceRelationshipAtTheEnd() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author1, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author1, this.project3, this.isProjectOfPerson, -1, -1);
        Relationship r4 = this.relationshipService.create(this.context, this.author2, this.project4, this.isProjectOfPerson, -1, -1);
        Relationship r5 = this.relationshipService.create(this.context, this.author2, this.project5, this.isProjectOfPerson, -1, -1);
        Relationship r6 = this.relationshipService.create(this.context, this.author2, this.project6, this.isProjectOfPerson, -1, -1);
        this.relationshipService.move(this.context, r3, this.author2, null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r2, 1);
        this.assertRelationMetadataOrder(this.author1, this.isProjectOfPerson, List.of(r1, r2));
        this.assertLeftPlace(r4, 0);
        this.assertLeftPlace(r5, 1);
        this.assertLeftPlace(r6, 2);
        this.assertLeftPlace(r3, 3);
        this.assertRelationMetadataOrder(this.author2, this.isProjectOfPerson, List.of(r4, r5, r6, r3));
    }

    @Test
    public void changeRightItemInUseNonForPlaceRelationshipAtTheStartTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author2, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author3, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r4 = this.relationshipService.create(this.context, this.author4, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r5 = this.relationshipService.create(this.context, this.author5, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r6 = this.relationshipService.create(this.context, this.author6, this.project2, this.isProjectOfPerson, -1, -1);
        this.relationshipService.move(this.context, r1, null, this.project2);
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r2, 0);
        this.assertRightPlace(r3, 1);
        this.assertRelationMetadataOrder(this.project1, this.isProjectOfPerson, List.of(r2, r3));
        this.assertRightPlace(r4, 0);
        this.assertRightPlace(r5, 1);
        this.assertRightPlace(r6, 2);
        this.assertRightPlace(r1, 3);
        this.assertRelationMetadataOrder(this.project2, this.isProjectOfPerson, List.of(r4, r5, r6, r1));
    }

    @Test
    public void changeRightItemInNonUseForPlaceRelationshipInTheMiddleTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author2, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author3, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r4 = this.relationshipService.create(this.context, this.author4, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r5 = this.relationshipService.create(this.context, this.author5, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r6 = this.relationshipService.create(this.context, this.author6, this.project2, this.isProjectOfPerson, -1, -1);
        this.relationshipService.move(this.context, r2, null, this.project2);
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r1, 0);
        this.assertRightPlace(r3, 1);
        this.assertRelationMetadataOrder(this.project1, this.isProjectOfPerson, List.of(r1, r3));
        this.assertRightPlace(r4, 0);
        this.assertRightPlace(r5, 1);
        this.assertRightPlace(r6, 2);
        this.assertRightPlace(r2, 3);
        this.assertRelationMetadataOrder(this.project2, this.isProjectOfPerson, List.of(r4, r5, r6, r2));
    }

    @Test
    public void changeRightItemInNonUseForPlaceRelationshipInTheMiddleTest_ignoreOtherRels() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author2, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship ur1 = this.relationshipService.create(this.context, this.publication1, this.project1, this.isProjectOfPublication, -1, -1);
        Relationship ur2 = this.relationshipService.create(this.context, this.publication2, this.project1, this.isProjectOfPublication, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author3, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r4 = this.relationshipService.create(this.context, this.author4, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r5 = this.relationshipService.create(this.context, this.author5, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship ur3 = this.relationshipService.create(this.context, this.author5, this.project3, this.isProjectOfPerson, -1, -1);
        Relationship r6 = this.relationshipService.create(this.context, this.author6, this.project2, this.isProjectOfPerson, -1, -1);
        this.relationshipService.move(this.context, r2, null, this.project2);
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r1, 0);
        this.assertRightPlace(r3, 1);
        this.assertRelationMetadataOrder(this.project1, this.isProjectOfPerson, List.of(r1, r3));
        this.assertRightPlace(r4, 0);
        this.assertRightPlace(r5, 1);
        this.assertRightPlace(r6, 2);
        this.assertRightPlace(r2, 3);
        this.assertRelationMetadataOrder(this.project2, this.isProjectOfPerson, List.of(r4, r5, r6, r2));
        this.assertLeftPlace(ur1, 0);
        this.assertRightPlace(ur1, 0);
        this.assertLeftPlace(ur2, 0);
        this.assertRightPlace(ur2, 1);
        this.assertLeftPlace(ur3, 1);
        this.assertRightPlace(ur3, 0);
    }

    @Test
    public void changeRightItemInNonUseForPlaceRelationshipAtTheEndTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author2, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author3, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r4 = this.relationshipService.create(this.context, this.author4, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r5 = this.relationshipService.create(this.context, this.author5, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r6 = this.relationshipService.create(this.context, this.author6, this.project2, this.isProjectOfPerson, -1, -1);
        this.relationshipService.move(this.context, r3, null, this.project2);
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r1, 0);
        this.assertRightPlace(r2, 1);
        this.assertRelationMetadataOrder(this.project1, this.isProjectOfPerson, List.of(r1, r2));
        this.assertRightPlace(r4, 0);
        this.assertRightPlace(r5, 1);
        this.assertRightPlace(r6, 2);
        this.assertRightPlace(r3, 3);
        this.assertRelationMetadataOrder(this.project2, this.isProjectOfPerson, List.of(r4, r5, r6, r3));
    }

    @Test
    public void changeLeftItemInNonUseForPlaceRelationshipAtTheStartToSameItemNoChanges() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author1, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author1, this.project3, this.isProjectOfPerson, -1, -1);
        this.relationshipService.move(this.context, r1, this.author1, null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r2, 1);
        this.assertLeftPlace(r3, 2);
        this.assertRelationMetadataOrder(this.author1, this.isProjectOfPerson, List.of(r1, r2, r3));
    }

    @Test
    public void changeRightItemInNonUseForPlaceRelationshipAtTheStartToSameItemNoChanges() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author1, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author1, this.project3, this.isProjectOfPerson, -1, -1);
        this.relationshipService.move(this.context, r1, null, this.project1);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r2, 1);
        this.assertLeftPlace(r3, 2);
        this.assertRelationMetadataOrder(this.author1, this.isProjectOfPerson, List.of(r1, r2, r3));
    }

    @Test
    public void changeLeftItemInNonUseForPlaceRelationshipAtTheStartWithSiblingsInOldLeftItem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author1, this.project2, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author1, this.project3, this.isProjectOfPerson, -1, -1);
        Relationship r4 = this.relationshipService.create(this.context, this.author4, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r5 = this.relationshipService.create(this.context, this.author5, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r6 = this.relationshipService.create(this.context, this.author6, this.project1, this.isProjectOfPerson, -1, -1);
        this.relationshipService.move(this.context, r1, this.author2, null);
        this.context.restoreAuthSystemState();
        this.assertLeftPlace(r2, 0);
        this.assertLeftPlace(r3, 1);
        this.assertRelationMetadataOrder(this.author1, this.isProjectOfPerson, List.of(r2, r3));
        this.assertRightPlace(r1, 0);
        this.assertRightPlace(r4, 1);
        this.assertRightPlace(r5, 2);
        this.assertRightPlace(r6, 3);
        this.assertRelationMetadataOrder(this.project1, this.isProjectOfPerson, List.of(r1, r4, r5, r6));
    }

    @Test
    public void changeRightItemInNonUseForPlaceRelationshipAtTheStartWithSiblingsInOldRightItem() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Relationship r1 = this.relationshipService.create(this.context, this.author1, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r2 = this.relationshipService.create(this.context, this.author2, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r3 = this.relationshipService.create(this.context, this.author3, this.project1, this.isProjectOfPerson, -1, -1);
        Relationship r4 = this.relationshipService.create(this.context, this.author1, this.project4, this.isProjectOfPerson, -1, -1);
        Relationship r5 = this.relationshipService.create(this.context, this.author1, this.project5, this.isProjectOfPerson, -1, -1);
        Relationship r6 = this.relationshipService.create(this.context, this.author1, this.project6, this.isProjectOfPerson, -1, -1);
        this.relationshipService.move(this.context, r1, null, this.project2);
        this.context.restoreAuthSystemState();
        this.assertRightPlace(r2, 0);
        this.assertRightPlace(r3, 1);
        this.assertRelationMetadataOrder(this.project1, this.isProjectOfPerson, List.of(r2, r3));
        this.assertLeftPlace(r1, 0);
        this.assertLeftPlace(r4, 1);
        this.assertLeftPlace(r5, 2);
        this.assertLeftPlace(r6, 3);
        this.assertRelationMetadataOrder(this.author1, this.isProjectOfPerson, List.of(r1, r4, r5, r6));
    }

    private void assertLeftPlace(Relationship relationship, int leftPlace) {
        Assert.assertEquals((long)leftPlace, (long)relationship.getLeftPlace());
    }

    private void assertRightPlace(Relationship relationship, int rightPlace) {
        Assert.assertEquals((long)rightPlace, (long)relationship.getRightPlace());
    }

    private void assertRelationMetadataOrder(Item item, RelationshipType relationshipType, List<Relationship> relationships) {
        String element = this.getRelationshipTypeStringForEntity(relationshipType, item);
        List mdvs = this.itemService.getMetadata((DSpaceObject)item, MetadataSchemaEnum.RELATION.getName(), element, null, "*");
        Assert.assertEquals((String)"Metadata authorities should match relationship IDs", relationships.stream().map(r -> {
            if (r != null) {
                return "virtual::" + r.getID();
            }
            return null;
        }).collect(Collectors.toList()), mdvs.stream().map(MetadataValue::getAuthority).collect(Collectors.toList()));
    }

    private void assertMetadataOrder(Item item, String metadataField, List<String> metadataValues) {
        List mdvs = this.itemService.getMetadataByMetadataString((DSpaceObject)item, metadataField);
        Assert.assertEquals(metadataValues, mdvs.stream().map(MetadataValue::getValue).collect(Collectors.toList()));
    }

    private String getRelationshipTypeStringForEntity(RelationshipType relationshipType, Item item) {
        String entityType = this.itemService.getEntityTypeLabel(item);
        if (StringUtils.equals((CharSequence)entityType, (CharSequence)relationshipType.getLeftType().getLabel())) {
            return relationshipType.getLeftwardType();
        }
        if (StringUtils.equals((CharSequence)entityType, (CharSequence)relationshipType.getRightType().getLabel())) {
            return relationshipType.getRightwardType();
        }
        throw new IllegalArgumentException(entityType + "is not a valid entity for " + relationshipType.getLeftwardType() + ", must be either " + relationshipType.getLeftType().getLabel() + " or " + relationshipType.getRightType().getLabel());
    }
}

