/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import org.dspace.AbstractDSpaceTest;
import org.dspace.content.crosswalk.IngestionCrosswalk;
import org.dspace.content.crosswalk.QDCCrosswalk;
import org.dspace.core.service.PluginService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.jdom2.Namespace;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class QDCCrosswalkTest
extends AbstractDSpaceTest {
    private static final String PLUGIN_NAME = "qdctest";
    private static final String NAMESPACE_PREFIX = "dc";
    private static final String NAMESPACE_PROPERTY = "crosswalk.qdc.namespace.qdctest.dc";
    private static final String NAMESPACE_URI = "http://purl.org/dc/elements/1.1/";
    private static final String SCHEMALOCATION_KEY = "crosswalk.qdc.schemaLocation.qdctest";
    private static final String SCHEMALOCATION = "http://purl.org/dc/terms/ http://dublincore.org/schemas/xmls/qdc/2006/01/06/dcterms.xsd";
    private static final String PROPERTIES_PREFIX = "crosswalk.qdc.properties.";
    private static final String PROPERTIES_KEY = "crosswalk.qdc.properties.qdctest";
    private static final String PROPERTIES = "crosswalks/QDC.properties";
    private static PluginService pluginService;

    @BeforeClass
    public static void setUpClass() {
        DSpaceServicesFactory dsf = DSpaceServicesFactory.getInstance();
        pluginService = (PluginService)dsf.getServiceManager().getServiceByName(null, PluginService.class);
        ConfigurationService cfg = dsf.getConfigurationService();
        cfg.setProperty("crosswalk.selfnamed." + IngestionCrosswalk.class.getName(), (Object)QDCCrosswalk.class.getName());
        cfg.setProperty(NAMESPACE_PROPERTY, (Object)NAMESPACE_URI);
        cfg.setProperty(SCHEMALOCATION_KEY, (Object)SCHEMALOCATION);
        for (String property : cfg.getPropertyKeys(PROPERTIES_PREFIX)) {
            cfg.setProperty(property, null);
        }
        cfg.setProperty(PROPERTIES_KEY, (Object)PROPERTIES);
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
        QDCCrosswalk.initStatic();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGetPluginNames() {
        String[] names = QDCCrosswalk.getPluginNames();
        Assert.assertEquals((String)"Wrong number of plugin names.", (long)1L, (long)names.length);
        Assert.assertEquals((String)"Plugin should be named 'qdctest'.", (Object)PLUGIN_NAME, (Object)names[0]);
    }

    @Test
    public void testGetNamespaces() {
        QDCCrosswalk instance = (QDCCrosswalk)pluginService.getNamedPlugin(IngestionCrosswalk.class, PLUGIN_NAME);
        Namespace[] namespaces = instance.getNamespaces();
        boolean found_prefix = false;
        for (Namespace namespace : namespaces) {
            found_prefix |= namespace.getPrefix().equals(NAMESPACE_PREFIX);
        }
        Assert.assertTrue((String)"Should know namespace dc.", (boolean)found_prefix);
    }

    @Test
    public void testGetSchemaLocation() {
        QDCCrosswalk instance = (QDCCrosswalk)pluginService.getNamedPlugin(IngestionCrosswalk.class, PLUGIN_NAME);
        String schemaLocation = instance.getSchemaLocation();
        System.out.println(schemaLocation);
        Assert.assertEquals((String)"SchemaLocation did not match.", (Object)SCHEMALOCATION, (Object)schemaLocation);
    }

    @Ignore
    @Test
    public void testDisseminateList() throws Exception {
    }

    @Ignore
    @Test
    public void testDisseminateElement() throws Exception {
    }

    @Ignore
    @Test
    public void testCanDisseminate() {
    }

    @Ignore
    @Test
    public void testIngest_4args_1() throws Exception {
    }

    @Ignore
    @Test
    public void testIngest_4args_2() throws Exception {
    }

    @Test
    public void testPreferList() {
        QDCCrosswalk instance = (QDCCrosswalk)pluginService.getNamedPlugin(IngestionCrosswalk.class, PLUGIN_NAME);
        Assert.assertTrue((String)"QDC crosswalk should prefer list.", (boolean)instance.preferList());
    }
}

