/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.ctask.general;

import java.io.IOException;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.ctask.general.CreateMissingIdentifiers;
import org.dspace.curate.Curator;
import org.dspace.identifier.VersionedHandleIdentifierProviderWithCanonicalHandles;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.junit.Assert;
import org.junit.Test;

public class CreateMissingIdentifiersIT
extends AbstractIntegrationTestWithDatabase {
    private static final String P_TASK_DEF = "plugin.named.org.dspace.curate.CurationTask";
    private static final String TASK_NAME = "test";

    @Test
    public void testPerform() throws IOException {
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        configurationService.setProperty(P_TASK_DEF, null);
        configurationService.addPropertyValue(P_TASK_DEF, (Object)(CreateMissingIdentifiers.class.getCanonicalName() + " = test"));
        Curator curator = new Curator();
        curator.addTask(TASK_NAME);
        this.context.setCurrentUser(this.admin);
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, this.parentCommunity).build();
        Item item = ItemBuilder.createItem(this.context, collection).build();
        curator.curate(this.context, (DSpaceObject)item);
        int status = curator.getStatus(TASK_NAME);
        Assert.assertEquals((String)"Curation should succeed", (long)0L, (long)status);
        DSpaceServicesFactory.getInstance().getServiceManager().registerServiceClass(VersionedHandleIdentifierProviderWithCanonicalHandles.class.getCanonicalName(), VersionedHandleIdentifierProviderWithCanonicalHandles.class);
        curator.curate(this.context, (DSpaceObject)item);
        System.out.format("With incompatible provider, result is '%s'.\n", curator.getResult(TASK_NAME));
        Assert.assertEquals((String)"Curation should fail", (long)-1L, (long)curator.getStatus(TASK_NAME));
    }
}

