/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.mail.MessagingException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.AbstractUnitTest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.InstallItemService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.EPersonDeletionException;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.workflow.WorkflowException;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowItemService;
import org.dspace.workflow.WorkflowService;
import org.dspace.workflow.factory.WorkflowServiceFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EPersonTest
extends AbstractUnitTest {
    protected EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected InstallItemService installItemService = ContentServiceFactory.getInstance().getInstallItemService();
    protected WorkflowItemService workflowItemService = WorkflowServiceFactory.getInstance().getWorkflowItemService();
    protected WorkflowService workflowService = WorkflowServiceFactory.getInstance().getWorkflowService();
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    private Community community = null;
    private Collection collection = null;
    private Item item = null;
    private static final String EMAIL = "test@example.com";
    private static final String FIRSTNAME = "Kevin";
    private static final String LASTNAME = "Van de Velde";
    private static final String NETID = "1985";
    private static final String PASSWORD = "test";
    private static final Logger log = LogManager.getLogger(EPersonTest.class);

    @Override
    @Before
    public void init() {
        super.init();
        this.context.turnOffAuthorisationSystem();
        try {
            EPerson eperson = this.ePersonService.create(this.context);
            eperson.setEmail(EMAIL);
            eperson.setFirstName(this.context, FIRSTNAME);
            eperson.setLastName(this.context, LASTNAME);
            eperson.setNetid(NETID);
            eperson.setPassword(PASSWORD);
            this.ePersonService.update(this.context, (DSpaceObject)eperson);
            this.community = this.communityService.create(null, this.context);
            this.collection = this.collectionService.create(this.context, this.community);
        }
        catch (SQLException | AuthorizeException ex) {
            log.error("Error in init", ex);
            Assert.fail((String)("Error in init: " + ex.getMessage()));
        }
        finally {
            this.context.restoreAuthSystemState();
        }
    }

    @Override
    public void destroy() {
        this.context.turnOffAuthorisationSystem();
        try {
            EPerson testPerson = this.ePersonService.findByEmail(this.context, EMAIL);
            if (testPerson != null) {
                this.ePersonService.delete(this.context, (DSpaceObject)testPerson);
            }
        }
        catch (IOException | SQLException | AuthorizeException ex) {
            log.error("Error in destroy", ex);
            Assert.fail((String)("Error in destroy: " + ex.getMessage()));
        }
        if (this.item != null) {
            try {
                this.item = (Item)this.itemService.find(this.context, this.item.getID());
                this.itemService.delete(this.context, (DSpaceObject)this.item);
            }
            catch (IOException | SQLException | AuthorizeException ex) {
                log.error("Error in destroy", ex);
                Assert.fail((String)("Error in destroy: " + ex.getMessage()));
            }
        }
        if (this.collection != null) {
            try {
                this.collection = (Collection)this.collectionService.find(this.context, this.collection.getID());
                this.collectionService.delete(this.context, (DSpaceObject)this.collection);
            }
            catch (IOException | SQLException | AuthorizeException ex) {
                log.error("Error in destroy", ex);
                Assert.fail((String)("Error in destroy: " + ex.getMessage()));
            }
        }
        if (this.community != null) {
            try {
                this.community = (Community)this.communityService.find(this.context, this.community.getID());
                this.communityService.delete(this.context, (DSpaceObject)this.community);
            }
            catch (IOException | SQLException | AuthorizeException ex) {
                log.error("Error in destroy", ex);
                Assert.fail((String)("Error in destroy: " + ex.getMessage()));
            }
        }
        this.context.restoreAuthSystemState();
        this.item = null;
        this.collection = null;
        this.community = null;
        super.destroy();
    }

    @Test
    public void testPreferences() throws Exception {
        String cookies = "{\"token_item\":true,\"impersonation\":true,\"redirect\":true,\"language\":true,\"klaro\":true,\"google-analytics\":false}";
        this.ePersonService.addMetadata(this.context, (DSpaceObject)this.eperson, "dspace", "agreements", "cookies", null, cookies);
        this.ePersonService.addMetadata(this.context, (DSpaceObject)this.eperson, "dspace", "agreements", "end-user", null, "true");
        this.ePersonService.update(this.context, (DSpaceObject)this.eperson);
        Assert.assertEquals((Object)cookies, (Object)this.ePersonService.getMetadataFirstValue((DSpaceObject)this.eperson, "dspace", "agreements", "cookies", null));
        Assert.assertEquals((Object)"true", (Object)this.ePersonService.getMetadataFirstValue((DSpaceObject)this.eperson, "dspace", "agreements", "end-user", null));
    }

    @Test
    public void testCheckPassword() throws SQLException, DecoderException {
        EPerson eperson = this.ePersonService.findByEmail(this.context, EMAIL);
        this.ePersonService.checkPassword(this.context, eperson, PASSWORD);
    }

    @Test
    public void testGetType() throws SQLException {
        System.out.println("getType");
        int expResult = 7;
        int result = this.eperson.getType();
        Assert.assertEquals((String)"Should return Constants.EPERSON", (long)expResult, (long)result);
    }

    @Test
    public void testDeleteEPerson() throws SQLException, AuthorizeException {
        EPerson deleteEperson = this.ePersonService.findByEmail(this.context, EMAIL);
        this.context.turnOffAuthorisationSystem();
        try {
            this.ePersonService.delete(this.context, (DSpaceObject)deleteEperson);
        }
        catch (IOException | AuthorizeException ex) {
            log.error("Cannot delete EPersion, caught " + ex.getClass().getName() + ":", ex);
            Assert.fail((String)("Caught an Exception while deleting an EPerson. " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
        this.context.restoreAuthSystemState();
        this.context.commit();
        EPerson findDeletedEperson = this.ePersonService.findByEmail(this.context, EMAIL);
        Assert.assertNull((String)"EPerson has not been deleted correctly!", (Object)findDeletedEperson);
    }

    @Test
    public void testDeletionConstraintOfSubmitter() throws SQLException {
        EPerson ep = this.ePersonService.findByEmail(this.context, EMAIL);
        try {
            this.item = this.prepareItem(ep);
        }
        catch (IOException | SQLException | AuthorizeException ex) {
            log.error("Caught an Exception while initializing an Item. " + ex.getClass().getName() + ": ", ex);
            Assert.fail((String)("Caught an Exception while initializing an Item. " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
        this.context.turnOffAuthorisationSystem();
        List tableList = this.ePersonService.getDeleteConstraints(this.context, ep);
        for (String tableName : tableList) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)tableName, (CharSequence)"item")) continue;
            return;
        }
        Assert.fail((String)"It was not recognized that a EPerson is referenced in the item table.");
    }

    @Test
    public void testDeletionOfSubmitterWithAnItem() throws SQLException, AuthorizeException {
        EPerson ep = this.ePersonService.findByEmail(this.context, EMAIL);
        try {
            this.item = this.prepareItem(ep);
        }
        catch (IOException | SQLException | AuthorizeException ex) {
            log.error("Caught an Exception while initializing an Item. " + ex.getClass().getName() + ": ", ex);
            Assert.fail((String)("Caught an Exception while initializing an Item. " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
        Assert.assertNotNull((Object)this.item);
        this.context.turnOffAuthorisationSystem();
        try {
            this.ePersonService.delete(this.context, (DSpaceObject)ep);
        }
        catch (IOException | SQLException | AuthorizeException ex) {
            if (ex.getCause() instanceof EPersonDeletionException) {
                Assert.fail((String)("Caught an EPersonDeletionException while trying to cascading delete an EPerson: " + ex.getMessage()));
            }
            log.error("Caught an Exception while deleting an EPerson. " + ex.getClass().getName() + ": ", ex);
            Assert.fail((String)("Caught an Exception while deleting an EPerson. " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
        this.item = (Item)this.itemService.find(this.context, this.item.getID());
        Assert.assertNotNull((String)"Could not load item after cascading deletion of the submitter.", (Object)this.item);
        Assert.assertNull((String)"Cascading deletion of an EPerson did not set the submitter of an submitted item null.", (Object)this.item.getSubmitter());
    }

    @Test
    public void testCascadingDeletionOfUnsubmittedWorkspaceItem() throws SQLException, AuthorizeException, IOException {
        EPerson ep = this.ePersonService.findByEmail(this.context, EMAIL);
        this.context.turnOffAuthorisationSystem();
        WorkspaceItem wsi = this.prepareWorkspaceItem(ep);
        Item item = wsi.getItem();
        this.itemService.addMetadata(this.context, (DSpaceObject)item, "dc", "title", null, "en", "Testdocument 1");
        this.itemService.update(this.context, (DSpaceObject)item);
        this.context.restoreAuthSystemState();
        this.context.commit();
        this.context.turnOffAuthorisationSystem();
        try {
            this.ePersonService.delete(this.context, (DSpaceObject)ep);
        }
        catch (IOException | SQLException | AuthorizeException ex) {
            if (ex.getCause() instanceof EPersonDeletionException) {
                Assert.fail((String)("Caught an EPersonDeletionException while trying to cascading delete an EPerson: " + ex.getMessage()));
            }
            log.error("Caught an Exception while deleting an EPerson. " + ex.getClass().getName() + ": ", ex);
            Assert.fail((String)("Caught an Exception while deleting an EPerson. " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
        this.context.restoreAuthSystemState();
        this.context.commit();
        try {
            WorkspaceItem restoredWsi = this.workspaceItemService.find(this.context, wsi.getID().intValue());
            Item restoredItem = (Item)this.itemService.find(this.context, item.getID());
            Assert.assertNull((String)"An unsubmited WorkspaceItem wasn't deleted while cascading deleting the submitter.", (Object)restoredWsi);
            Assert.assertNull((String)"An unsubmited Item wasn't deleted while cascading deleting the submitter.", (Object)restoredItem);
        }
        catch (SQLException ex) {
            log.error("SQLException while trying to load previously stored. " + ex);
        }
    }

    @Test
    public void testCascadingDeleteSubmitterPreservesWorkflowItems() throws SQLException, AuthorizeException, IOException, MessagingException, WorkflowException {
        EPerson ep = this.ePersonService.findByEmail(this.context, EMAIL);
        WorkspaceItem wsi = null;
        try {
            wsi = this.prepareWorkspaceItem(ep);
        }
        catch (IOException | SQLException | AuthorizeException ex) {
            log.error("Caught an Exception while initializing an WorkspaceItem. " + ex.getClass().getName() + ": ", ex);
            Assert.fail((String)("Caught an Exception while initializing an WorkspaceItem. " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
        Assert.assertNotNull((Object)wsi);
        this.context.turnOffAuthorisationSystem();
        Group wfGroup = this.collectionService.createWorkflowGroup(this.context, wsi.getCollection(), 1);
        this.collectionService.update(this.context, (DSpaceObject)wsi.getCollection());
        EPerson groupMember = this.ePersonService.create(this.context);
        groupMember.setEmail("testCascadingDeleteSubmitterPreservesWorkflowItems2@example.org");
        this.ePersonService.update(this.context, (DSpaceObject)groupMember);
        wfGroup.addMember(groupMember);
        this.groupService.update(this.context, (DSpaceObject)wfGroup);
        int wfiID = this.workflowService.startWithoutNotify(this.context, wsi).getID();
        this.context.restoreAuthSystemState();
        this.context.commit();
        this.context.turnOffAuthorisationSystem();
        Assert.assertNotNull((String)"Cannot find currently created WorkflowItem!", (Object)this.workflowItemService.find(this.context, wfiID));
        try {
            this.ePersonService.delete(this.context, (DSpaceObject)ep);
        }
        catch (IOException | SQLException | AuthorizeException ex) {
            if (ex.getCause() instanceof EPersonDeletionException) {
                Assert.fail((String)("Caught an EPersonDeletionException while trying to cascading delete an EPerson: " + ex.getMessage()));
            }
            log.error("Caught an Exception while deleting an EPerson. " + ex.getClass().getName() + ": ", ex);
            Assert.fail((String)("Caught an Exception while deleting an EPerson. " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
        this.context.restoreAuthSystemState();
        this.context.commit();
        this.context.turnOffAuthorisationSystem();
        WorkflowItem wfi = this.workflowItemService.find(this.context, wfiID);
        Assert.assertNotNull((String)"Could not load WorkflowItem after cascading deletion of the submitter.", (Object)wfi);
        Assert.assertNull((String)"Cascading deletion of an EPerson did not set the submitter of an submitted WorkflowItem null.", (Object)wfi.getSubmitter());
    }

    private Item prepareItem(EPerson submitter) throws SQLException, AuthorizeException, IOException {
        this.context.turnOffAuthorisationSystem();
        WorkspaceItem wsi = this.prepareWorkspaceItem(submitter);
        this.item = this.installItemService.installItem(this.context, (InProgressSubmission)wsi);
        this.context.restoreAuthSystemState();
        return this.item;
    }

    private WorkspaceItem prepareWorkspaceItem(EPerson submitter) throws SQLException, AuthorizeException, IOException {
        this.context.turnOffAuthorisationSystem();
        WorkspaceItem wsi = this.workspaceItemService.create(this.context, this.collection, false);
        wsi.getItem().setSubmitter(submitter);
        this.workspaceItemService.update(this.context, (InProgressSubmission)wsi);
        this.context.restoreAuthSystemState();
        return wsi;
    }
}

