/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.iiif.canvasdimension;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.builder.BitstreamBuilder;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Bitstream;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CanvasDimensionsIT
extends AbstractIntegrationTestWithDatabase {
    protected Community child1;
    protected Community child2;
    protected Collection col1;
    protected Collection col2;
    protected Collection col3;
    protected Item iiifItem;
    protected Item iiifItem2;
    protected Item iiifItem3;
    protected Bitstream bitstream;
    protected Bitstream bitstream2;
    private static final String METADATA_IIIF_HEIGHT = "iiif.image.height";
    private static final String METADATA_IIIF_WIDTH = "iiif.image.width";
    private final ByteArrayOutputStream outContent = new ByteArrayOutputStream();
    private final PrintStream originalOut = System.out;

    @Before
    public void setup() throws IOException {
        System.setOut(new PrintStream(this.outContent));
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("Parent Community").build();
        this.child1 = CommunityBuilder.createSubCommunity(this.context, this.parentCommunity).withName("Sub Community 1").build();
        this.child2 = CommunityBuilder.createSubCommunity(this.context, this.parentCommunity).withName("Sub Community 2").build();
        this.col1 = CollectionBuilder.createCollection(this.context, this.child1).withName("Collection 1").build();
        this.col2 = CollectionBuilder.createCollection(this.context, this.child2).withName("Collection 2").build();
        this.context.restoreAuthSystemState();
    }

    @Override
    @After
    public void destroy() throws Exception {
        System.setOut(this.originalOut);
        super.destroy();
    }

    @Test
    public void processItemNoForce() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.iiifItem = ItemBuilder.createItem(this.context, this.col1).withTitle("Test Item").withIssueDate("2017-10-17").enableIIIF().build();
        InputStream input = this.getClass().getResourceAsStream("cat.jpg");
        this.bitstream = BitstreamBuilder.createBitstream(this.context, this.iiifItem, input).withName("Bitstream2.jpg").withMimeType("image/jpeg").build();
        this.context.restoreAuthSystemState();
        String handle = this.iiifItem.getHandle();
        this.execCanvasScript(handle);
        Assert.assertTrue((boolean)this.bitstream.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_HEIGHT)).anyMatch(m -> m.getValue().contentEquals("400")));
        Assert.assertTrue((boolean)this.bitstream.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_WIDTH)).anyMatch(m -> m.getValue().contentEquals("600")));
    }

    @Test
    public void processCollectionNoForce() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.iiifItem = ItemBuilder.createItem(this.context, this.col1).withTitle("Test Item").withIssueDate("2017-10-17").enableIIIF().build();
        InputStream input = this.getClass().getResourceAsStream("cat.jpg");
        this.bitstream = BitstreamBuilder.createBitstream(this.context, this.iiifItem, input).withName("Bitstream2.jpg").withMimeType("image/jpeg").build();
        this.context.restoreAuthSystemState();
        String id = this.col1.getID().toString();
        this.execCanvasScript(id);
        Assert.assertTrue((boolean)this.bitstream.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_HEIGHT)).anyMatch(m -> m.getValue().contentEquals("400")));
        Assert.assertTrue((boolean)this.bitstream.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_WIDTH)).anyMatch(m -> m.getValue().contentEquals("600")));
    }

    @Test
    public void processSubCommunityNoForce() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.iiifItem = ItemBuilder.createItem(this.context, this.col1).withTitle("Test Item").withIssueDate("2017-10-17").enableIIIF().build();
        InputStream input = this.getClass().getResourceAsStream("cat.jpg");
        this.bitstream = BitstreamBuilder.createBitstream(this.context, this.iiifItem, input).withName("Bitstream2.jpg").withMimeType("image/jpeg").build();
        this.context.restoreAuthSystemState();
        String id = this.child1.getID().toString();
        this.execCanvasScript(id);
        Assert.assertTrue((boolean)this.bitstream.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_HEIGHT)).anyMatch(m -> m.getValue().contentEquals("400")));
        Assert.assertTrue((boolean)this.bitstream.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_WIDTH)).anyMatch(m -> m.getValue().contentEquals("600")));
    }

    @Test
    public void processParentCommunityNoForce() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.iiifItem = ItemBuilder.createItem(this.context, this.col1).withTitle("Test Item").withIssueDate("2017-10-17").enableIIIF().build();
        InputStream input = this.getClass().getResourceAsStream("cat.jpg");
        this.bitstream = BitstreamBuilder.createBitstream(this.context, this.iiifItem, input).withName("Bitstream2.jpg").withMimeType("image/jpeg").build();
        this.context.restoreAuthSystemState();
        String handle = this.parentCommunity.getHandle();
        this.execCanvasScript(handle);
        Assert.assertTrue((boolean)this.bitstream.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_HEIGHT)).anyMatch(m -> m.getValue().contentEquals("400")));
        Assert.assertTrue((boolean)this.bitstream.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_WIDTH)).anyMatch(m -> m.getValue().contentEquals("600")));
    }

    @Test
    public void processParentCommunityMultipleSubsNoForce() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.iiifItem = ItemBuilder.createItem(this.context, this.col1).withTitle("Test Item").withIssueDate("2017-10-17").enableIIIF().build();
        this.iiifItem2 = ItemBuilder.createItem(this.context, this.col2).withTitle("Test Item2").withIssueDate("2017-10-17").enableIIIF().build();
        InputStream input = this.getClass().getResourceAsStream("cat.jpg");
        this.bitstream = BitstreamBuilder.createBitstream(this.context, this.iiifItem, input).withName("Bitstream2.jpg").withMimeType("image/jpeg").build();
        input = this.getClass().getResourceAsStream("cat.jpg");
        this.bitstream2 = BitstreamBuilder.createBitstream(this.context, this.iiifItem2, input).withName("Bitstream2.jpg").withMimeType("image/jpeg").build();
        this.context.restoreAuthSystemState();
        String id = this.parentCommunity.getID().toString();
        this.execCanvasScript(id);
        Assert.assertTrue((boolean)this.bitstream.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_HEIGHT)).anyMatch(m -> m.getValue().contentEquals("400")));
        Assert.assertTrue((boolean)this.bitstream.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_WIDTH)).anyMatch(m -> m.getValue().contentEquals("600")));
        Assert.assertTrue((boolean)this.bitstream2.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_HEIGHT)).anyMatch(m -> m.getValue().contentEquals("400")));
        Assert.assertTrue((boolean)this.bitstream2.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_WIDTH)).anyMatch(m -> m.getValue().contentEquals("600")));
    }

    @Test
    public void processItemWithForce() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.iiifItem = ItemBuilder.createItem(this.context, this.col1).withTitle("Test Item").withIssueDate("2017-10-17").enableIIIF().build();
        InputStream input = this.getClass().getResourceAsStream("cat.jpg");
        this.bitstream = BitstreamBuilder.createBitstream(this.context, this.iiifItem, input).withName("Bitstream2.jpg").withMimeType("image/jpeg").withIIIFCanvasWidth(100).withIIIFCanvasHeight(100).build();
        this.context.restoreAuthSystemState();
        String id = this.iiifItem.getID().toString();
        this.execCanvasScriptForceOption(id);
        Assert.assertTrue((boolean)this.bitstream.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_HEIGHT)).anyMatch(m -> m.getValue().contentEquals("400")));
        Assert.assertTrue((boolean)this.bitstream.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_WIDTH)).anyMatch(m -> m.getValue().contentEquals("600")));
    }

    @Test
    public void processCollectionWithForce() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.iiifItem = ItemBuilder.createItem(this.context, this.col1).withTitle("Test Item").withIssueDate("2017-10-17").enableIIIF().build();
        InputStream input = this.getClass().getResourceAsStream("cat.jpg");
        this.bitstream = BitstreamBuilder.createBitstream(this.context, this.iiifItem, input).withName("Bitstream2.jpg").withMimeType("image/jpeg").withIIIFCanvasWidth(100).withIIIFCanvasHeight(100).build();
        this.context.restoreAuthSystemState();
        String id = this.col1.getID().toString();
        this.execCanvasScriptForceOption(id);
        Assert.assertTrue((boolean)this.bitstream.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_HEIGHT)).anyMatch(m -> m.getValue().contentEquals("400")));
        Assert.assertTrue((boolean)this.bitstream.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_WIDTH)).anyMatch(m -> m.getValue().contentEquals("600")));
    }

    @Test
    public void processItemWithExistingMetadata() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.iiifItem = ItemBuilder.createItem(this.context, this.col1).withTitle("Test Item").withIssueDate("2017-10-17").enableIIIF().build();
        InputStream input = this.getClass().getResourceAsStream("cat.jpg");
        this.bitstream = BitstreamBuilder.createBitstream(this.context, this.iiifItem, input).withName("Bitstream2.jpg").withMimeType("image/jpeg").withIIIFCanvasWidth(100).withIIIFCanvasHeight(100).build();
        this.context.restoreAuthSystemState();
        String handle = this.iiifItem.getHandle();
        this.execCanvasScript(handle);
        Assert.assertTrue((boolean)this.bitstream.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_HEIGHT)).anyMatch(m -> m.getValue().contentEquals("100")));
        Assert.assertTrue((boolean)this.bitstream.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_WIDTH)).anyMatch(m -> m.getValue().contentEquals("100")));
    }

    @Test
    public void processParentCommunityWithMaximum() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.iiifItem = ItemBuilder.createItem(this.context, this.col1).withTitle("Test Item 1").withIssueDate("2017-10-17").enableIIIF().build();
        this.iiifItem2 = ItemBuilder.createItem(this.context, this.col1).withTitle("Test Item 2").withIssueDate("2017-10-17").enableIIIF().build();
        this.iiifItem3 = ItemBuilder.createItem(this.context, this.col1).withTitle("Test Item3").withIssueDate("2017-10-17").enableIIIF().build();
        InputStream input = this.getClass().getResourceAsStream("cat.jpg");
        this.bitstream = BitstreamBuilder.createBitstream(this.context, this.iiifItem, input).withName("Bitstream2.jpg").withMimeType("image/jpeg").withIIIFCanvasWidth(100).withIIIFCanvasHeight(100).build();
        input = this.getClass().getResourceAsStream("cat.jpg");
        this.bitstream2 = BitstreamBuilder.createBitstream(this.context, this.iiifItem2, input).withName("Bitstream2.jpg").withMimeType("image/jpeg").withIIIFCanvasWidth(100).withIIIFCanvasHeight(100).build();
        input = this.getClass().getResourceAsStream("cat.jpg");
        Bitstream bitstream3 = BitstreamBuilder.createBitstream(this.context, this.iiifItem3, input).withName("Bitstream3.jpg").withMimeType("image/jpeg").withIIIFCanvasWidth(100).withIIIFCanvasHeight(100).build();
        this.context.restoreAuthSystemState();
        String id = this.parentCommunity.getID().toString();
        this.execCanvasScriptWithMaxRecs(id);
        Pattern regex = Pattern.compile(".*2 IIIF items were processed", 32);
        Assert.assertTrue((boolean)regex.matcher(StringUtils.chomp((String)this.outContent.toString())).find());
    }

    @Test
    public void processParentCommunityWithMultipleSkip() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.col3 = CollectionBuilder.createCollection(this.context, this.child1).withName("Collection 3").build();
        this.iiifItem = ItemBuilder.createItem(this.context, this.col1).withTitle("Test Item").withIssueDate("2017-10-17").enableIIIF().build();
        this.iiifItem2 = ItemBuilder.createItem(this.context, this.col2).withTitle("Test Item").withIssueDate("2017-10-17").enableIIIF().build();
        this.iiifItem3 = ItemBuilder.createItem(this.context, this.col3).withTitle("Test Item").withIssueDate("2017-10-17").enableIIIF().build();
        InputStream input = this.getClass().getResourceAsStream("cat.jpg");
        this.bitstream = BitstreamBuilder.createBitstream(this.context, this.iiifItem, input).withName("Bitstream2.jpg").withMimeType("image/jpeg").withIIIFCanvasWidth(100).withIIIFCanvasHeight(100).build();
        input = this.getClass().getResourceAsStream("cat.jpg");
        this.bitstream2 = BitstreamBuilder.createBitstream(this.context, this.iiifItem2, input).withName("Bitstream2.jpg").withMimeType("image/jpeg").withIIIFCanvasWidth(100).withIIIFCanvasHeight(100).build();
        input = this.getClass().getResourceAsStream("cat.jpg");
        Bitstream bitstream3 = BitstreamBuilder.createBitstream(this.context, this.iiifItem3, input).withName("Bitstream2.jpg").withMimeType("image/jpeg").withIIIFCanvasWidth(100).withIIIFCanvasHeight(100).build();
        this.context.restoreAuthSystemState();
        String id = this.parentCommunity.getID().toString();
        this.execCanvasScriptWithSkipList(id, this.col2.getHandle() + "," + this.col3.getHandle());
        Assert.assertTrue((boolean)this.bitstream.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_HEIGHT)).anyMatch(m -> m.getValue().contentEquals("400")));
        Assert.assertTrue((boolean)this.bitstream.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_WIDTH)).anyMatch(m -> m.getValue().contentEquals("600")));
        Assert.assertTrue((boolean)this.bitstream2.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_HEIGHT)).anyMatch(m -> m.getValue().contentEquals("100")));
        Assert.assertTrue((boolean)this.bitstream2.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_WIDTH)).anyMatch(m -> m.getValue().contentEquals("100")));
        Assert.assertTrue((boolean)bitstream3.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_HEIGHT)).anyMatch(m -> m.getValue().contentEquals("100")));
        Assert.assertTrue((boolean)bitstream3.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_WIDTH)).anyMatch(m -> m.getValue().contentEquals("100")));
    }

    @Test
    public void processParentCommunityWithSingleSkip() throws Exception {
        this.context.turnOffAuthorisationSystem();
        this.iiifItem = ItemBuilder.createItem(this.context, this.col1).withTitle("Test Item").withIssueDate("2017-10-17").enableIIIF().build();
        this.iiifItem2 = ItemBuilder.createItem(this.context, this.col2).withTitle("Test Item").withIssueDate("2017-10-17").enableIIIF().build();
        InputStream input = this.getClass().getResourceAsStream("cat.jpg");
        this.bitstream = BitstreamBuilder.createBitstream(this.context, this.iiifItem, input).withName("Bitstream2.jpg").withMimeType("image/jpeg").withIIIFCanvasWidth(100).withIIIFCanvasHeight(100).build();
        input = this.getClass().getResourceAsStream("cat.jpg");
        this.bitstream2 = BitstreamBuilder.createBitstream(this.context, this.iiifItem2, input).withName("Bitstream2.jpg").withMimeType("image/jpeg").withIIIFCanvasWidth(100).withIIIFCanvasHeight(100).build();
        this.context.restoreAuthSystemState();
        String id = this.parentCommunity.getID().toString();
        this.execCanvasScriptWithSkipList(id, this.col2.getHandle());
        Assert.assertTrue((boolean)this.bitstream.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_HEIGHT)).anyMatch(m -> m.getValue().contentEquals("400")));
        Assert.assertTrue((boolean)this.bitstream.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_WIDTH)).anyMatch(m -> m.getValue().contentEquals("600")));
        Assert.assertTrue((boolean)this.bitstream2.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_HEIGHT)).anyMatch(m -> m.getValue().contentEquals("100")));
        Assert.assertTrue((boolean)this.bitstream2.getMetadata().stream().filter(m -> m.getMetadataField().toString('.').contentEquals(METADATA_IIIF_WIDTH)).anyMatch(m -> m.getValue().contentEquals("100")));
    }

    private void execCanvasScript(String id) throws Exception {
        this.runDSpaceScript("iiif-canvas-dimensions", "-e", "admin@email.com", "-i", id);
    }

    private void execCanvasScriptForceOption(String id) throws Exception {
        this.runDSpaceScript("iiif-canvas-dimensions", "-e", "admin@email.com", "-i", id, "-f");
    }

    private void execCanvasScriptWithMaxRecs(String id) throws Exception {
        this.runDSpaceScript("iiif-canvas-dimensions", "-e", "admin@email.com", "-i", id, "-m", "2", "-f", "-q");
    }

    private void execCanvasScriptWithSkipList(String id, String skip) throws Exception {
        this.runDSpaceScript("iiif-canvas-dimensions", "-e", "admin@email.com", "-i", id, "-s", skip, "-f");
    }
}

