/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid;

import java.sql.SQLException;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.matcher.OrcidQueueMatcher;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EntityTypeBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.OrcidHistoryBuilder;
import org.dspace.builder.RelationshipBuilder;
import org.dspace.builder.RelationshipTypeBuilder;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.RelationshipType;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.ReloadableEntity;
import org.dspace.orcid.OrcidOperation;
import org.dspace.orcid.OrcidQueue;
import org.dspace.orcid.factory.OrcidServiceFactory;
import org.dspace.orcid.model.OrcidProfileSectionType;
import org.dspace.orcid.service.OrcidQueueService;
import org.dspace.profile.OrcidEntitySyncPreference;
import org.dspace.profile.OrcidProfileSyncPreference;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OrcidQueueConsumerIT
extends AbstractIntegrationTestWithDatabase {
    private OrcidQueueService orcidQueueService = OrcidServiceFactory.getInstance().getOrcidQueueService();
    private ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    private Collection profileCollection;

    @Before
    public void setup() {
        this.context.turnOffAuthorisationSystem();
        this.parentCommunity = CommunityBuilder.createCommunity(this.context).withName("Parent community").build();
        this.profileCollection = this.createCollection("Profiles", "Person");
        this.context.restoreAuthSystemState();
    }

    @After
    public void after() throws SQLException, AuthorizeException {
        List records = this.orcidQueueService.findAll(this.context);
        for (OrcidQueue record : records) {
            this.orcidQueueService.delete(this.context, record);
        }
        this.context.setDispatcher(null);
    }

    @Test
    public void testWithNotOrcidSynchronizationEntity() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Collection orgUnits = CollectionBuilder.createCollection(this.context, this.parentCommunity).withName("OrgUnits").withEntityType("OrgUnit").build();
        ItemBuilder.createItem(this.context, orgUnits).withTitle("Test OrgUnit").withSubject("test").build();
        this.context.restoreAuthSystemState();
        this.context.commit();
        List queueRecords = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.empty());
    }

    @Test
    public void testWithOrcidSynchronizationDisabled() throws Exception {
        this.configurationService.setProperty("orcid.synchronization-enabled", (Object)false);
        this.context.turnOffAuthorisationSystem();
        ItemBuilder.createItem(this.context, this.profileCollection).withTitle("Test User").withOrcidIdentifier("0000-1111-2222-3333").withOrcidAccessToken("ab4d18a0-8d9a-40f1-b601-a417255c8d20", this.eperson).withSubject("test").withOrcidSynchronizationProfilePreference(OrcidProfileSyncPreference.BIOGRAPHICAL).withOrcidSynchronizationProfilePreference(OrcidProfileSyncPreference.IDENTIFIERS).build();
        this.context.restoreAuthSystemState();
        this.context.commit();
        List queueRecords = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.empty());
    }

    @Test
    public void testOrcidQueueRecordCreationForProfile() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item profile = ItemBuilder.createItem(this.context, this.profileCollection).withTitle("Test User").withOrcidIdentifier("0000-1111-2222-3333").withOrcidAccessToken("ab4d18a0-8d9a-40f1-b601-a417255c8d20", this.eperson).withSubject("test").withHandle("123456789/200").withOrcidSynchronizationProfilePreference(OrcidProfileSyncPreference.BIOGRAPHICAL).withOrcidSynchronizationProfilePreference(OrcidProfileSyncPreference.IDENTIFIERS).build();
        this.context.restoreAuthSystemState();
        this.context.commit();
        List queueRecords = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasItem((Matcher)OrcidQueueMatcher.matches(profile, profile, "KEYWORDS", null, "dc.subject::test", "test", OrcidOperation.INSERT)));
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasItem((Matcher)OrcidQueueMatcher.matches(profile, "RESEARCHER_URLS", null, "dc.identifier.uri::http://localhost:4000/handle/123456789/200", "http://localhost:4000/handle/123456789/200", OrcidOperation.INSERT)));
        this.addMetadata(profile, "person", "name", "variant", "User Test", null);
        this.context.commit();
        queueRecords = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasItem((Matcher)OrcidQueueMatcher.matches(profile, profile, "KEYWORDS", null, "dc.subject::test", "test", OrcidOperation.INSERT)));
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasItem((Matcher)OrcidQueueMatcher.matches(profile, "RESEARCHER_URLS", null, "dc.identifier.uri::http://localhost:4000/handle/123456789/200", "http://localhost:4000/handle/123456789/200", OrcidOperation.INSERT)));
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasItem((Matcher)OrcidQueueMatcher.matches(profile, profile, "OTHER_NAMES", null, "person.name.variant::User Test", "User Test", OrcidOperation.INSERT)));
    }

    @Test
    public void testOrcidQueueRecordCreationForProfileWithSameMetadataPreviouslyDeleted() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item profile = ItemBuilder.createItem(this.context, this.profileCollection).withTitle("Test User").withOrcidIdentifier("0000-1111-2222-3333").withOrcidAccessToken("ab4d18a0-8d9a-40f1-b601-a417255c8d20", this.eperson).withOrcidSynchronizationProfilePreference(OrcidProfileSyncPreference.BIOGRAPHICAL).build();
        OrcidHistoryBuilder.createOrcidHistory(this.context, profile, profile).withRecordType("COUNTRY").withMetadata("person.country::IT").withPutCode("123456").withOperation(OrcidOperation.INSERT).withTimestamp(Date.from(Instant.ofEpochMilli(100000L))).withStatus(201).build();
        OrcidHistoryBuilder.createOrcidHistory(this.context, profile, profile).withRecordType("COUNTRY").withMetadata("person.country::IT").withPutCode("123456").withOperation(OrcidOperation.DELETE).withTimestamp(Date.from(Instant.ofEpochMilli(200000L))).withStatus(204).build();
        this.context.restoreAuthSystemState();
        this.context.commit();
        MatcherAssert.assertThat((Object)this.orcidQueueService.findAll(this.context), (Matcher)Matchers.empty());
        this.addMetadata(profile, "person", "country", null, "IT", null);
        this.context.commit();
        List queueRecords = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((OrcidQueue)queueRecords.get(0)), (Matcher)OrcidQueueMatcher.matches(profile, "COUNTRY", null, "person.country::IT", "IT", OrcidOperation.INSERT));
    }

    @Test
    public void testOrcidQueueRecordCreationForProfileWithMetadataPreviouslyDeletedAndThenInsertedAgain() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item profile = ItemBuilder.createItem(this.context, this.profileCollection).withTitle("Test User").withOrcidIdentifier("0000-1111-2222-3333").withOrcidAccessToken("ab4d18a0-8d9a-40f1-b601-a417255c8d20", this.eperson).withOrcidSynchronizationProfilePreference(OrcidProfileSyncPreference.BIOGRAPHICAL).build();
        OrcidHistoryBuilder.createOrcidHistory(this.context, profile, profile).withRecordType("COUNTRY").withMetadata("person.country::IT").withPutCode("123456").withOperation(OrcidOperation.INSERT).withTimestamp(Date.from(Instant.ofEpochMilli(100000L))).withStatus(201).build();
        OrcidHistoryBuilder.createOrcidHistory(this.context, profile, profile).withRecordType("COUNTRY").withMetadata("person.country::IT").withPutCode("123456").withOperation(OrcidOperation.DELETE).withTimestamp(Date.from(Instant.ofEpochMilli(200000L))).withStatus(204).build();
        OrcidHistoryBuilder.createOrcidHistory(this.context, profile, profile).withRecordType("COUNTRY").withMetadata("person.country::IT").withPutCode("123456").withOperation(OrcidOperation.INSERT).withTimestamp(Date.from(Instant.ofEpochMilli(300000L))).withStatus(201).build();
        this.context.restoreAuthSystemState();
        this.context.commit();
        MatcherAssert.assertThat((Object)this.orcidQueueService.findAll(this.context), (Matcher)Matchers.empty());
        this.addMetadata(profile, "person", "country", null, "IT", null);
        this.context.commit();
        MatcherAssert.assertThat((Object)this.orcidQueueService.findAll(this.context), (Matcher)Matchers.empty());
    }

    @Test
    public void testOrcidQueueRecordCreationForProfileWithNotSuccessfullyMetadataDeletion() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item profile = ItemBuilder.createItem(this.context, this.profileCollection).withTitle("Test User").withOrcidIdentifier("0000-1111-2222-3333").withOrcidAccessToken("ab4d18a0-8d9a-40f1-b601-a417255c8d20", this.eperson).withOrcidSynchronizationProfilePreference(OrcidProfileSyncPreference.BIOGRAPHICAL).build();
        OrcidHistoryBuilder.createOrcidHistory(this.context, profile, profile).withRecordType("COUNTRY").withMetadata("person.country::IT").withPutCode("123456").withOperation(OrcidOperation.INSERT).withTimestamp(Date.from(Instant.ofEpochMilli(100000L))).withStatus(201).build();
        OrcidHistoryBuilder.createOrcidHistory(this.context, profile, profile).withRecordType("COUNTRY").withMetadata("person.country::IT").withPutCode("123456").withOperation(OrcidOperation.DELETE).withTimestamp(Date.from(Instant.ofEpochMilli(200000L))).withStatus(400).build();
        this.context.restoreAuthSystemState();
        this.context.commit();
        MatcherAssert.assertThat((Object)this.orcidQueueService.findAll(this.context), (Matcher)Matchers.empty());
        this.addMetadata(profile, "person", "country", null, "IT", null);
        this.context.commit();
        MatcherAssert.assertThat((Object)this.orcidQueueService.findAll(this.context), (Matcher)Matchers.empty());
    }

    @Test
    public void testOrcidQueueRecordCreationAndDeletion() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.profileCollection).withTitle("Test User").withOrcidIdentifier("0000-1111-2222-3333").withOrcidAccessToken("ab4d18a0-8d9a-40f1-b601-a417255c8d20", this.eperson).withSubject("Science").withOrcidSynchronizationProfilePreference(OrcidProfileSyncPreference.BIOGRAPHICAL).build();
        this.context.restoreAuthSystemState();
        this.context.commit();
        List records = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)records, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)records, (Matcher)Matchers.hasItem((Matcher)OrcidQueueMatcher.matches(item, OrcidProfileSectionType.KEYWORDS.name(), null, "dc.subject::Science", "Science", OrcidOperation.INSERT)));
        this.removeMetadata(item, "dc", "subject", null);
        this.context.commit();
        MatcherAssert.assertThat((Object)this.orcidQueueService.findAll(this.context), (Matcher)Matchers.empty());
    }

    @Test
    public void testOrcidQueueRecordCreationAndDeletionWithOrcidHistoryInsertionInTheMiddle() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.profileCollection).withTitle("Test User").withOrcidIdentifier("0000-1111-2222-3333").withOrcidAccessToken("ab4d18a0-8d9a-40f1-b601-a417255c8d20", this.eperson).withSubject("Science").withOrcidSynchronizationProfilePreference(OrcidProfileSyncPreference.BIOGRAPHICAL).build();
        this.context.restoreAuthSystemState();
        this.context.commit();
        List records = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)records, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)records, (Matcher)Matchers.hasItem((Matcher)OrcidQueueMatcher.matches(item, OrcidProfileSectionType.KEYWORDS.name(), null, "dc.subject::Science", "Science", OrcidOperation.INSERT)));
        OrcidHistoryBuilder.createOrcidHistory(this.context, item, item).withPutCode("12345").withMetadata("dc.subject::Science").withDescription("Science").withRecordType(OrcidProfileSectionType.KEYWORDS.name()).withOperation(OrcidOperation.INSERT).withStatus(201).build();
        this.removeMetadata(item, "dc", "subject", null);
        this.context.commit();
        records = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)records, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)records, (Matcher)Matchers.hasItem((Matcher)OrcidQueueMatcher.matches(item, OrcidProfileSectionType.KEYWORDS.name(), "12345", "dc.subject::Science", "Science", OrcidOperation.DELETE)));
    }

    @Test
    public void testOrcidQueueRecordCreationAndDeletionWithFailedOrcidHistoryInsertionInTheMiddle() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.profileCollection).withTitle("Test User").withOrcidIdentifier("0000-1111-2222-3333").withOrcidAccessToken("ab4d18a0-8d9a-40f1-b601-a417255c8d20", this.eperson).withSubject("Science").withOrcidSynchronizationProfilePreference(OrcidProfileSyncPreference.BIOGRAPHICAL).build();
        this.context.restoreAuthSystemState();
        this.context.commit();
        List records = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)records, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)records, (Matcher)Matchers.hasItem((Matcher)OrcidQueueMatcher.matches(item, OrcidProfileSectionType.KEYWORDS.name(), null, "dc.subject::Science", "Science", OrcidOperation.INSERT)));
        OrcidHistoryBuilder.createOrcidHistory(this.context, item, item).withPutCode("12345").withMetadata("dc.subject::Science").withDescription("Science").withRecordType(OrcidProfileSectionType.KEYWORDS.name()).withOperation(OrcidOperation.INSERT).withStatus(400).build();
        this.removeMetadata(item, "dc", "subject", null);
        this.context.commit();
        MatcherAssert.assertThat((Object)this.orcidQueueService.findAll(this.context), (Matcher)Matchers.empty());
    }

    @Test
    public void testNoOrcidQueueRecordCreationOccursIfProfileSynchronizationIsDisabled() throws SQLException {
        this.context.turnOffAuthorisationSystem();
        ItemBuilder.createItem(this.context, this.profileCollection).withTitle("Test User").withOrcidIdentifier("0000-1111-2222-3333").withOrcidAccessToken("ab4d18a0-8d9a-40f1-b601-a417255c8d20", this.eperson).build();
        this.context.restoreAuthSystemState();
        this.context.commit();
        MatcherAssert.assertThat((Object)this.orcidQueueService.findAll(this.context), (Matcher)Matchers.empty());
    }

    @Test
    public void testNoOrcidQueueRecordCreationOccursIfNoComplianceMetadataArePresent() throws SQLException {
        this.context.turnOffAuthorisationSystem();
        ItemBuilder.createItem(this.context, this.profileCollection).withTitle("Test User").withOrcidIdentifier("0000-1111-2222-3333").withOrcidAccessToken("ab4d18a0-8d9a-40f1-b601-a417255c8d20", this.eperson).withOrcidSynchronizationProfilePreference(OrcidProfileSyncPreference.BIOGRAPHICAL).build();
        this.context.restoreAuthSystemState();
        this.context.commit();
        MatcherAssert.assertThat((Object)this.orcidQueueService.findAll(this.context), (Matcher)Matchers.empty());
    }

    @Test
    public void testOrcidQueueRecordCreationForPublication() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item profile = ItemBuilder.createItem(this.context, this.profileCollection).withTitle("Test User").withOrcidIdentifier("0000-1111-2222-3333").withOrcidAccessToken("ab4d18a0-8d9a-40f1-b601-a417255c8d20", this.eperson).withOrcidSynchronizationPublicationsPreference(OrcidEntitySyncPreference.ALL).build();
        Collection publicationCollection = this.createCollection("Publications", "Publication");
        Item publication = ItemBuilder.createItem(this.context, publicationCollection).withTitle("Test publication").withAuthor("Test User").build();
        EntityType publicationType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Publication").build();
        EntityType personType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Person").build();
        RelationshipType isAuthorOfPublication = RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, personType, publicationType, "isAuthorOfPublication", "isPublicationOfAuthor", 0, null, 0, null).build();
        RelationshipBuilder.createRelationshipBuilder(this.context, profile, publication, isAuthorOfPublication).build();
        this.context.restoreAuthSystemState();
        this.context.commit();
        List orcidQueueRecords = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)orcidQueueRecords, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((OrcidQueue)orcidQueueRecords.get(0)), (Matcher)OrcidQueueMatcher.matches(profile, publication, "Publication", OrcidOperation.INSERT));
        this.addMetadata(publication, "dc", "contributor", "editor", "Editor", null);
        this.context.commit();
        List newOrcidQueueRecords = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)newOrcidQueueRecords, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((OrcidQueue)orcidQueueRecords.get(0)), (Matcher)Matchers.equalTo((Object)((OrcidQueue)newOrcidQueueRecords.get(0))));
    }

    @Test
    public void testOrcidQueueRecordCreationToUpdatePublication() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item profile = ItemBuilder.createItem(this.context, this.profileCollection).withTitle("Test User").withOrcidIdentifier("0000-1111-2222-3333").withOrcidAccessToken("ab4d18a0-8d9a-40f1-b601-a417255c8d20", this.eperson).withOrcidSynchronizationPublicationsPreference(OrcidEntitySyncPreference.ALL).build();
        Collection publicationCollection = this.createCollection("Publications", "Publication");
        Item publication = ItemBuilder.createItem(this.context, publicationCollection).withTitle("Test publication").withAuthor("Test User").build();
        OrcidHistoryBuilder.createOrcidHistory(this.context, profile, publication).withPutCode("123456").withOperation(OrcidOperation.INSERT).build();
        EntityType publicationType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Publication").build();
        EntityType personType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Person").build();
        RelationshipType isAuthorOfPublication = RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, personType, publicationType, "isAuthorOfPublication", "isPublicationOfAuthor", 0, null, 0, null).build();
        RelationshipBuilder.createRelationshipBuilder(this.context, profile, publication, isAuthorOfPublication).build();
        this.context.restoreAuthSystemState();
        this.context.commit();
        List orcidQueueRecords = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)orcidQueueRecords, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((OrcidQueue)orcidQueueRecords.get(0)), (Matcher)OrcidQueueMatcher.matches(profile, publication, "Publication", "123456", OrcidOperation.UPDATE));
    }

    @Test
    public void testNoOrcidQueueRecordCreationOccursIfPublicationSynchronizationIsDisabled() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item profile = ItemBuilder.createItem(this.context, this.profileCollection).withTitle("Test User").withOrcidIdentifier("0000-1111-2222-3333").withOrcidAccessToken("ab4d18a0-8d9a-40f1-b601-a417255c8d20", this.eperson).build();
        Collection publicationCollection = this.createCollection("Publications", "Publication");
        Item publication = ItemBuilder.createItem(this.context, publicationCollection).withTitle("Test publication").withAuthor("Test User").build();
        EntityType publicationType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Publication").build();
        EntityType personType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Person").build();
        RelationshipType isAuthorOfPublication = RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, personType, publicationType, "isAuthorOfPublication", "isPublicationOfAuthor", 0, null, 0, null).build();
        RelationshipBuilder.createRelationshipBuilder(this.context, profile, publication, isAuthorOfPublication).build();
        this.context.restoreAuthSystemState();
        this.context.commit();
        MatcherAssert.assertThat((Object)this.orcidQueueService.findAll(this.context), (Matcher)Matchers.empty());
        this.addMetadata(profile, "dspace", "orcid", "sync-publications", OrcidEntitySyncPreference.DISABLED.name(), null);
        this.addMetadata(publication, "dc", "date", "issued", "2021-01-01", null);
        this.context.commit();
        MatcherAssert.assertThat((Object)this.orcidQueueService.findAll(this.context), (Matcher)Matchers.empty());
    }

    @Test
    public void testOrcidQueueRecordCreationToUpdateProject() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item profile = ItemBuilder.createItem(this.context, this.profileCollection).withTitle("Test User").withOrcidIdentifier("0000-1111-2222-3333").withOrcidAccessToken("ab4d18a0-8d9a-40f1-b601-a417255c8d20", this.eperson).withOrcidSynchronizationFundingsPreference(OrcidEntitySyncPreference.ALL).build();
        Collection projectCollection = this.createCollection("Projects", "Project");
        Item project = ItemBuilder.createItem(this.context, projectCollection).withTitle("Test project").build();
        OrcidHistoryBuilder.createOrcidHistory(this.context, profile, project).withPutCode("123456").build();
        EntityType projectType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Project").build();
        EntityType personType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Person").build();
        RelationshipType isProjectOfPerson = RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, projectType, personType, "isProjectOfPerson", "isPersonOfProject", 0, null, 0, null).build();
        RelationshipBuilder.createRelationshipBuilder(this.context, project, profile, isProjectOfPerson).build();
        this.context.restoreAuthSystemState();
        this.context.commit();
        List orcidQueueRecords = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)orcidQueueRecords, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((OrcidQueue)orcidQueueRecords.get(0)), (Matcher)OrcidQueueMatcher.matches(profile, project, "Project", "123456", OrcidOperation.UPDATE));
    }

    @Test
    public void testNoOrcidQueueRecordCreationOccursForNotConfiguredEntities() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item profile = ItemBuilder.createItem(this.context, this.profileCollection).withTitle("Test User").withOrcidIdentifier("0000-1111-2222-3333").withOrcidAccessToken("ab4d18a0-8d9a-40f1-b601-a417255c8d20", this.eperson).build();
        Collection projectCollection = this.createCollection("Projects", "Project");
        Item project = ItemBuilder.createItem(this.context, projectCollection).withTitle("Test project").withProjectInvestigator("Test User").build();
        EntityType projectType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Project").build();
        EntityType personType = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Person").build();
        RelationshipType isProjectOfPerson = RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, projectType, personType, "isProjectOfPerson", "isPersonOfProject", 0, null, 0, null).build();
        RelationshipBuilder.createRelationshipBuilder(this.context, project, profile, isProjectOfPerson).build();
        this.context.restoreAuthSystemState();
        this.context.commit();
        MatcherAssert.assertThat((Object)this.orcidQueueService.findAll(this.context), (Matcher)Matchers.empty());
    }

    @Test
    public void testOrcidQueueRecalculationOnProfilePreferenceUpdate() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item profile = ItemBuilder.createItem(this.context, this.profileCollection).withTitle("Test User").withOrcidIdentifier("0000-0000-0012-2345").withOrcidAccessToken("ab4d18a0-8d9a-40f1-b601-a417255c8d20", this.eperson).withSubject("Math").withHandle("123456789/200").withOrcidSynchronizationProfilePreference(OrcidProfileSyncPreference.BIOGRAPHICAL).build();
        this.context.restoreAuthSystemState();
        this.context.commit();
        List records = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)records, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)records, (Matcher)Matchers.hasItem((Matcher)OrcidQueueMatcher.matches(profile, "KEYWORDS", null, "dc.subject::Math", "Math", OrcidOperation.INSERT)));
        this.addMetadata(profile, "person", "identifier", "rid", "ID", null);
        this.addMetadata(profile, "dspace", "orcid", "sync-profile", OrcidProfileSyncPreference.IDENTIFIERS.name(), null);
        this.context.commit();
        records = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)records, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)records, (Matcher)Matchers.hasItem((Matcher)OrcidQueueMatcher.matches(profile, "KEYWORDS", null, "dc.subject::Math", "Math", OrcidOperation.INSERT)));
        MatcherAssert.assertThat((Object)records, (Matcher)Matchers.hasItem((Matcher)OrcidQueueMatcher.matches(profile, "EXTERNAL_IDS", null, "person.identifier.rid::ID", "ID", OrcidOperation.INSERT)));
        MatcherAssert.assertThat((Object)records, (Matcher)Matchers.hasItem((Matcher)OrcidQueueMatcher.matches(profile, "RESEARCHER_URLS", null, "dc.identifier.uri::http://localhost:4000/handle/123456789/200", "http://localhost:4000/handle/123456789/200", OrcidOperation.INSERT)));
        this.removeMetadata(profile, "dspace", "orcid", "sync-profile");
        this.context.commit();
        MatcherAssert.assertThat((Object)this.orcidQueueService.findAll(this.context), (Matcher)Matchers.empty());
    }

    @Test
    public void testWithManyInsertionAndDeletionOfSameMetadataValue() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item profile = ItemBuilder.createItem(this.context, this.profileCollection).withTitle("Test User").withOrcidIdentifier("0000-1111-2222-3333").withOrcidAccessToken("ab4d18a0-8d9a-40f1-b601-a417255c8d20", this.eperson).withOrcidSynchronizationProfilePreference(OrcidProfileSyncPreference.BIOGRAPHICAL).withSubject("Science").build();
        this.context.restoreAuthSystemState();
        this.context.commit();
        List queueRecords = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((OrcidQueue)queueRecords.get(0)), (Matcher)OrcidQueueMatcher.matches(profile, "KEYWORDS", null, "dc.subject::Science", "Science", OrcidOperation.INSERT));
        OrcidHistoryBuilder.createOrcidHistory(this.context, profile, profile).withRecordType(OrcidProfileSectionType.KEYWORDS.name()).withDescription("Science").withMetadata("dc.subject::Science").withOperation(OrcidOperation.INSERT).withPutCode("12345").withStatus(201).build();
        this.removeMetadata(profile, "dc", "subject", null);
        this.context.commit();
        queueRecords = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((OrcidQueue)queueRecords.get(0)), (Matcher)OrcidQueueMatcher.matches(profile, "KEYWORDS", "12345", "dc.subject::Science", "Science", OrcidOperation.DELETE));
        OrcidHistoryBuilder.createOrcidHistory(this.context, profile, profile).withRecordType(OrcidProfileSectionType.KEYWORDS.name()).withDescription("Science").withMetadata("dc.subject::Science").withOperation(OrcidOperation.DELETE).withStatus(204).build();
        this.addMetadata(profile, "dc", "subject", null, "Science", null);
        this.context.commit();
        queueRecords = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((OrcidQueue)queueRecords.get(0)), (Matcher)OrcidQueueMatcher.matches(profile, "KEYWORDS", null, "dc.subject::Science", "Science", OrcidOperation.INSERT));
        OrcidHistoryBuilder.createOrcidHistory(this.context, profile, profile).withRecordType(OrcidProfileSectionType.KEYWORDS.name()).withDescription("Science").withMetadata("dc.subject::Science").withOperation(OrcidOperation.INSERT).withPutCode("12346").withStatus(201).build();
        this.removeMetadata(profile, "dc", "subject", null);
        this.context.commit();
        queueRecords = this.orcidQueueService.findAll(this.context);
        MatcherAssert.assertThat((Object)queueRecords, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((OrcidQueue)queueRecords.get(0)), (Matcher)OrcidQueueMatcher.matches(profile, "KEYWORDS", "12346", "dc.subject::Science", "Science", OrcidOperation.DELETE));
    }

    private void addMetadata(Item item, String schema, String element, String qualifier, String value, String authority) throws Exception {
        this.context.turnOffAuthorisationSystem();
        item = (Item)this.context.reloadEntity((ReloadableEntity)item);
        this.itemService.addMetadata(this.context, (DSpaceObject)item, schema, element, qualifier, null, value, authority, 600);
        this.itemService.update(this.context, (DSpaceObject)item);
        this.context.restoreAuthSystemState();
    }

    private void removeMetadata(Item item, String schema, String element, String qualifier) throws Exception {
        this.context.turnOffAuthorisationSystem();
        item = (Item)this.context.reloadEntity((ReloadableEntity)item);
        List metadata = this.itemService.getMetadata((DSpaceObject)item, schema, element, qualifier, "*");
        this.itemService.removeMetadataValues(this.context, (DSpaceObject)item, metadata);
        this.itemService.update(this.context, (DSpaceObject)item);
        this.context.restoreAuthSystemState();
    }

    private Collection createCollection(String name, String entityType) {
        return CollectionBuilder.createCollection(this.context, this.parentCommunity).withName(name).withEntityType(entityType).build();
    }
}

