/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.workflow;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.dspace.workflow.CurationTaskConfig;
import org.dspace.workflow.FlowStep;
import org.dspace.workflow.Task;
import org.dspace.workflow.TaskSet;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.xml.sax.SAXException;

public class CurationTaskConfigTest {
    private static CurationTaskConfig instance;
    private static final String TEST1 = "test1";
    private static final String STEP1 = "step1";
    private static final String TASK1 = "task1";
    private static final String ACTION_REJECT = "reject";
    private static final String CONDITION_FAIL = "fail";
    private static final String ADMINISTRATOR = "me";
    private static final String COLLECTION_9_HANDLE = "123456789/9";
    private static final String BAD_HANDLE = "axolotl";
    private static final String CONFIGURATION = "<?xml version='1.0' encoding='UTF-8'?><workflow-curation xmlns='https://dspace.org/workflow-curation'>  <taskset-map>    <mapping collection-handle='default' taskset='test1'/>    <mapping collection-handle='123456789/9' taskset='default'/>  </taskset-map>  <tasksets>    <taskset name='default'>      <flowstep name='default1'>        <task name='dontcare'/>      </flowstep>    </taskset>    <taskset name='test1'>      <flowstep name='step1'>        <task name='task1'>          <workflow>reject</workflow>          <notify on='fail'>me</notify>        </task>      </flowstep>    </taskset>  </tasksets></workflow-curation>";

    @BeforeClass
    public static void setUpClass() throws JAXBException, SAXException, IOException {
        instance = new CurationTaskConfig((InputStream)new ByteArrayInputStream(CONFIGURATION.getBytes(StandardCharsets.UTF_8)));
    }

    @Test
    public void testFindTaskSet() {
        TaskSet taskSet = instance.findTaskSet("123456789/2");
        Assert.assertNotNull((String)"The 'default' Handle should match", (Object)taskSet);
        Assert.assertEquals((String)"The wrong taskset was found.", (Object)TEST1, (Object)taskSet.name);
        Object foundStep = null;
        for (Object step : taskSet.steps) {
            if (!STEP1.equals(((FlowStep)step).step)) continue;
            foundStep = step;
            break;
        }
        Assert.assertNotNull((String)"step1 should be in this taskset.", foundStep);
        Task foundTask = null;
        for (Task task : ((FlowStep)foundStep).tasks) {
            if (!TASK1.equals(task.name)) continue;
            foundTask = task;
            break;
        }
        Assert.assertNotNull((String)"task1 should be in step1.", foundTask);
        Assert.assertTrue((String)"task1 should have 'reject' action", (boolean)foundTask.powers.contains(ACTION_REJECT));
        List contacts = (List)foundTask.contacts.get(CONDITION_FAIL);
        Assert.assertNotNull((String)"task1 should have contacts for condition fail", (Object)contacts);
        Assert.assertTrue((String)"task1 on condition fail should contact me", (boolean)contacts.contains(ADMINISTRATOR));
    }

    @Test
    public void testContainsKey() {
        boolean isContained = instance.containsKey(COLLECTION_9_HANDLE);
        Assert.assertTrue((String)"Collection '123456789/9' should be found.", (boolean)isContained);
        isContained = instance.containsKey(BAD_HANDLE);
        Assert.assertFalse((String)"Collection 'axolotl' should not be found.", (boolean)isContained);
    }
}

