/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.state;

import java.util.List;
import org.dspace.AbstractUnitTest;
import org.dspace.utils.DSpace;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.Workflow;
import org.dspace.xmlworkflow.state.actions.WorkflowActionConfig;
import org.junit.Assert;
import org.junit.Test;

public class StepTest
extends AbstractUnitTest {
    private Workflow defaultWorkflow = (Workflow)new DSpace().getServiceManager().getServiceByName("defaultWorkflow", Workflow.class);
    private Workflow selectSingleReviewer = (Workflow)new DSpace().getServiceManager().getServiceByName("selectSingleReviewer", Workflow.class);
    private Workflow scoreReview = (Workflow)new DSpace().getServiceManager().getServiceByName("scoreReview", Workflow.class);

    @Test
    public void defaultWorkflow_ReviewStep() throws WorkflowConfigurationException {
        Step step = this.defaultWorkflow.getStep("reviewstep");
        Assert.assertEquals((Object)"claimaction", (Object)step.getUserSelectionMethod().getId());
        Assert.assertEquals((Object)"Reviewer", (Object)step.getRole().getName());
        List actions = step.getActions();
        Assert.assertTrue((boolean)this.containsActionNamed(actions, "reviewaction"));
        Assert.assertEquals((Object)"editstep", (Object)step.getNextStep(0).getId());
    }

    @Test
    public void defaultWorkflow_EditStep() throws WorkflowConfigurationException {
        Step step = this.defaultWorkflow.getStep("editstep");
        Assert.assertEquals((Object)"claimaction", (Object)step.getUserSelectionMethod().getId());
        Assert.assertEquals((Object)"Editor", (Object)step.getRole().getName());
        List actions = step.getActions();
        Assert.assertTrue((boolean)this.containsActionNamed(actions, "editaction"));
        Assert.assertEquals((Object)"finaleditstep", (Object)step.getNextStep(0).getId());
    }

    @Test
    public void defaultWorkflow_FinalEditStep() throws WorkflowConfigurationException {
        Step step = this.defaultWorkflow.getStep("finaleditstep");
        Assert.assertEquals((Object)"claimaction", (Object)step.getUserSelectionMethod().getId());
        Assert.assertEquals((Object)"Final Editor", (Object)step.getRole().getName());
        List actions = step.getActions();
        Assert.assertTrue((boolean)this.containsActionNamed(actions, "finaleditaction"));
        Assert.assertNull((Object)step.getNextStep(0));
    }

    @Test
    public void selectSingleReviewer_SelectReviewerStep() throws WorkflowConfigurationException {
        Step step = this.selectSingleReviewer.getStep("selectReviewerStep");
        Assert.assertEquals((Object)"claimaction", (Object)step.getUserSelectionMethod().getId());
        Assert.assertEquals((Object)"ReviewManagers", (Object)step.getRole().getName());
        List actions = step.getActions();
        Assert.assertTrue((boolean)this.containsActionNamed(actions, "selectrevieweraction"));
        Assert.assertEquals((Object)"singleUserReviewStep", (Object)step.getNextStep(0).getId());
    }

    @Test
    public void selectSingleReviewer_SingleUserReviewStep() throws WorkflowConfigurationException {
        Step step = this.selectSingleReviewer.getStep("singleUserReviewStep");
        Assert.assertEquals((Object)"autoassignAction", (Object)step.getUserSelectionMethod().getId());
        Assert.assertEquals((Object)"Reviewer", (Object)step.getRole().getName());
        List actions = step.getActions();
        Assert.assertTrue((boolean)this.containsActionNamed(actions, "singleuserreviewaction"));
        Assert.assertEquals((Object)"selectReviewerStep", (Object)step.getNextStep(1).getId());
    }

    @Test
    public void scoreReview_ScoreReviewStep() throws WorkflowConfigurationException {
        Step step = this.scoreReview.getStep("scoreReviewStep");
        Assert.assertEquals((Object)"claimaction", (Object)step.getUserSelectionMethod().getId());
        Assert.assertEquals((Object)"ScoreReviewers", (Object)step.getRole().getName());
        List actions = step.getActions();
        Assert.assertTrue((boolean)this.containsActionNamed(actions, "scorereviewaction"));
        Assert.assertEquals((Object)"evaluationStep", (Object)step.getNextStep(0).getId());
        Assert.assertEquals((long)2L, (long)step.getRequiredUsers());
    }

    @Test
    public void scoreReview_EvaluationStep() throws WorkflowConfigurationException {
        Step step = this.scoreReview.getStep("evaluationStep");
        Assert.assertEquals((Object)"noUserSelectionAction", (Object)step.getUserSelectionMethod().getId());
        List actions = step.getActions();
        Assert.assertTrue((boolean)this.containsActionNamed(actions, "evaluationaction"));
        Assert.assertNull((Object)step.getNextStep(0));
    }

    private boolean containsActionNamed(List<WorkflowActionConfig> actions, String actionName) {
        for (WorkflowActionConfig workflowActionConfig : actions) {
            if (!workflowActionConfig.getId().equalsIgnoreCase(actionName)) continue;
            return true;
        }
        return false;
    }
}

