/*
 * Decompiled with CFR 0.152.
 */
package org.dspace;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.dspace.AbstractUnitTest;
import org.dspace.utils.DSpace;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;

@Ignore
public class AbstractIntegrationTest
extends AbstractUnitTest {
    private static final int CONFIG_RELOAD_TIME = 5500;
    private long initialLocalCfgSize;
    private boolean localCfgChanged = false;

    @Override
    @Before
    public void init() {
        super.init();
        String extraConfPath = this.getLocalConfigurationFilePath();
        try {
            FileChannel fileOpen = FileChannel.open(Paths.get(extraConfPath, new String[0]), StandardOpenOption.READ);
            this.initialLocalCfgSize = fileOpen.size();
            fileOpen.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    @After
    public void destroy() {
        super.destroy();
        this.cleanExtraConfigurations();
    }

    protected void cleanExtraConfigurations() {
        if (!this.localCfgChanged) {
            return;
        }
        String extraConfPath = this.getLocalConfigurationFilePath();
        try {
            FileChannel.open(Paths.get(extraConfPath, new String[0]), StandardOpenOption.WRITE).truncate(this.initialLocalCfgSize).close();
            this.localCfgChanged = false;
            Thread.sleep(5500L);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private String getLocalConfigurationFilePath() {
        return new DSpace().getConfigurationService().getProperty("dspace.dir") + "/config/local.cfg";
    }

    protected void appendToLocalConfiguration(String textToAppend) {
        String extraConfPath = this.getLocalConfigurationFilePath();
        try (BufferedWriter output = new BufferedWriter(new FileWriter(extraConfPath, StandardCharsets.UTF_8, true));){
            output.append("\n");
            output.append(textToAppend);
            ((Writer)output).flush();
            ((Writer)output).close();
            this.localCfgChanged = true;
            Thread.sleep(5500L);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

