/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import junit.framework.TestCase;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.launcher.ScriptLauncher;
import org.dspace.app.scripts.handler.impl.TestDSpaceRunnableHandler;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Constants;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.scripts.configuration.ScriptConfiguration;
import org.dspace.scripts.factory.ScriptServiceFactory;
import org.dspace.scripts.handler.DSpaceRunnableHandler;
import org.dspace.scripts.service.ScriptService;
import org.dspace.servicemanager.DSpaceKernelImpl;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.jdom2.Document;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class MetadataExportIT
extends AbstractIntegrationTestWithDatabase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    @Test
    public void metadataExportToCsvTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).build();
        Item item = ItemBuilder.createItem(this.context, collection).withAuthor("Donald, Smith").build();
        this.context.restoreAuthSystemState();
        String fileLocation = this.configurationService.getProperty("dspace.dir") + testProps.get("test.exportcsv").toString();
        String[] args = new String[]{"metadata-export", "-i", String.valueOf(item.getHandle()), "-f", fileLocation};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        File file = new File(fileLocation);
        String fileContent = IOUtils.toString((InputStream)new FileInputStream(file), (Charset)StandardCharsets.UTF_8);
        TestCase.assertTrue((boolean)fileContent.contains("Donald, Smith"));
        TestCase.assertTrue((boolean)fileContent.contains(String.valueOf(item.getID())));
    }

    @Test(expected=ParseException.class)
    public void metadataExportWithoutFileParameter() throws IllegalAccessException, InstantiationException, ParseException {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).build();
        Item item = ItemBuilder.createItem(this.context, collection).withAuthor("Donald, Smith").build();
        this.context.restoreAuthSystemState();
        String[] args = new String[]{"metadata-export", "-i", String.valueOf(item.getHandle())};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptService scriptService = ScriptServiceFactory.getInstance().getScriptService();
        ScriptConfiguration scriptConfiguration = scriptService.getScriptConfiguration(args[0]);
        DSpaceRunnable script = null;
        if (scriptConfiguration != null) {
            script = scriptService.createDSpaceRunnableForScriptConfiguration(scriptConfiguration);
        }
        if (script != null) {
            script.initialize(args, (DSpaceRunnableHandler)testDSpaceRunnableHandler, null);
            script.run();
        }
    }

    @Test
    public void metadataExportToCsvTestUUID() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).build();
        Item item = ItemBuilder.createItem(this.context, collection).withAuthor("Donald, Smith").build();
        this.context.restoreAuthSystemState();
        String fileLocation = this.configurationService.getProperty("dspace.dir") + testProps.get("test.exportcsv").toString();
        String[] args = new String[]{"metadata-export", "-i", String.valueOf(item.getID()), "-f", fileLocation};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        File file = new File(fileLocation);
        String fileContent = IOUtils.toString((InputStream)new FileInputStream(file), (Charset)StandardCharsets.UTF_8);
        TestCase.assertTrue((boolean)fileContent.contains("Donald, Smith"));
        TestCase.assertTrue((boolean)fileContent.contains(String.valueOf(item.getID())));
    }

    @Test
    public void metadataExportToCsvTestUUIDParent() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).build();
        Item item = ItemBuilder.createItem(this.context, collection).withAuthor("Donald, Smith").build();
        this.context.restoreAuthSystemState();
        String fileLocation = this.configurationService.getProperty("dspace.dir") + testProps.get("test.exportcsv").toString();
        String[] args = new String[]{"metadata-export", "-i", String.valueOf(collection.getID()), "-f", fileLocation};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        File file = new File(fileLocation);
        String fileContent = IOUtils.toString((InputStream)new FileInputStream(file), (Charset)StandardCharsets.UTF_8);
        TestCase.assertTrue((boolean)fileContent.contains("Donald, Smith"));
        TestCase.assertTrue((boolean)fileContent.contains(String.valueOf(item.getID())));
    }

    @Test
    public void metadataExportToCsvTestUUIDGrandParent() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        Collection collection = CollectionBuilder.createCollection(this.context, community).build();
        Item item = ItemBuilder.createItem(this.context, collection).withAuthor("Donald, Smith").build();
        this.context.restoreAuthSystemState();
        String fileLocation = this.configurationService.getProperty("dspace.dir") + testProps.get("test.exportcsv").toString();
        String[] args = new String[]{"metadata-export", "-i", String.valueOf(community.getID()), "-f", fileLocation};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        File file = new File(fileLocation);
        String fileContent = IOUtils.toString((InputStream)new FileInputStream(file), (Charset)StandardCharsets.UTF_8);
        TestCase.assertTrue((boolean)fileContent.contains("Donald, Smith"));
        TestCase.assertTrue((boolean)fileContent.contains(String.valueOf(item.getID())));
    }

    @Test
    public void metadataExportToCsvTest_NonValidIdentifier() throws Exception {
        String fileLocation = this.configurationService.getProperty("dspace.dir") + testProps.get("test.exportcsv").toString();
        String nonValidUUID = String.valueOf(UUID.randomUUID());
        String[] args = new String[]{"metadata-export", "-i", nonValidUUID, "-f", fileLocation};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptService scriptService = ScriptServiceFactory.getInstance().getScriptService();
        ScriptConfiguration scriptConfiguration = scriptService.getScriptConfiguration(args[0]);
        DSpaceRunnable script = null;
        if (scriptConfiguration != null) {
            script = scriptService.createDSpaceRunnableForScriptConfiguration(scriptConfiguration);
        }
        if (script != null) {
            script.initialize(args, (DSpaceRunnableHandler)testDSpaceRunnableHandler, null);
            script.run();
        }
        Exception exceptionDuringTestRun = testDSpaceRunnableHandler.getException();
        TestCase.assertTrue((String)"Random UUID caused IllegalArgumentException", (boolean)(exceptionDuringTestRun instanceof IllegalArgumentException));
        TestCase.assertTrue((String)"IllegalArgumentException contains mention of the non-valid UUID", (boolean)StringUtils.contains((CharSequence)exceptionDuringTestRun.getMessage(), (CharSequence)nonValidUUID));
    }

    @Test
    public void metadataExportToCsvTest_NonValidDSOType() throws Exception {
        String fileLocation = this.configurationService.getProperty("dspace.dir") + testProps.get("test.exportcsv").toString();
        String uuidNonValidDSOType = String.valueOf(this.eperson.getID());
        String[] args = new String[]{"metadata-export", "-i", uuidNonValidDSOType, "-f", fileLocation};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptService scriptService = ScriptServiceFactory.getInstance().getScriptService();
        ScriptConfiguration scriptConfiguration = scriptService.getScriptConfiguration(args[0]);
        DSpaceRunnable script = null;
        if (scriptConfiguration != null) {
            script = scriptService.createDSpaceRunnableForScriptConfiguration(scriptConfiguration);
        }
        if (script != null) {
            script.initialize(args, (DSpaceRunnableHandler)testDSpaceRunnableHandler, null);
            script.run();
        }
        Exception exceptionDuringTestRun = testDSpaceRunnableHandler.getException();
        TestCase.assertTrue((String)"UUID of non-supported dsoType IllegalArgumentException", (boolean)(exceptionDuringTestRun instanceof IllegalArgumentException));
        TestCase.assertTrue((String)"IllegalArgumentException contains mention of the UUID of non-supported dsoType", (boolean)StringUtils.contains((CharSequence)exceptionDuringTestRun.getMessage(), (CharSequence)uuidNonValidDSOType));
        TestCase.assertTrue((String)"IllegalArgumentException contains mention of the non-supported dsoType", (boolean)StringUtils.contains((CharSequence)exceptionDuringTestRun.getMessage(), (CharSequence)Constants.typeText[this.eperson.getType()]));
    }
}

