/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.cli.ParseException;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.AbstractIntegrationTestWithDatabase;
import org.dspace.app.launcher.ScriptLauncher;
import org.dspace.app.scripts.handler.impl.TestDSpaceRunnableHandler;
import org.dspace.builder.CollectionBuilder;
import org.dspace.builder.CommunityBuilder;
import org.dspace.builder.EntityTypeBuilder;
import org.dspace.builder.ItemBuilder;
import org.dspace.builder.RelationshipTypeBuilder;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.scripts.configuration.ScriptConfiguration;
import org.dspace.scripts.factory.ScriptServiceFactory;
import org.dspace.scripts.handler.DSpaceRunnableHandler;
import org.dspace.scripts.service.ScriptService;
import org.dspace.servicemanager.DSpaceKernelImpl;
import org.jdom2.Document;
import org.junit.Before;
import org.junit.Test;

public class MetadataImportIT
extends AbstractIntegrationTestWithDatabase {
    private final ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private final EPersonService ePersonService = EPersonServiceFactory.getInstance().getEPersonService();
    private final RelationshipService relationshipService = ContentServiceFactory.getInstance().getRelationshipService();
    private Collection collection;
    private Collection publicationCollection;
    private Collection personCollection;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.context.turnOffAuthorisationSystem();
        Community community = CommunityBuilder.createCommunity(this.context).build();
        this.collection = CollectionBuilder.createCollection(this.context, community).build();
        this.publicationCollection = CollectionBuilder.createCollection(this.context, community).withEntityType("Publication").build();
        this.personCollection = CollectionBuilder.createCollection(this.context, community).withEntityType("Person").build();
        this.context.restoreAuthSystemState();
    }

    @Test
    public void metadataImportTest() throws Exception {
        String[] csv = new String[]{"id,collection,dc.title,dc.contributor.author", "+," + this.collection.getHandle() + ",\"Test Import 1\",\"Donald, SmithImported\""};
        this.performImportScript(csv);
        Item importedItem = this.findItemByName("Test Import 1");
        TestCase.assertTrue((boolean)StringUtils.equals((CharSequence)((MetadataValue)this.itemService.getMetadata((DSpaceObject)importedItem, "dc", "contributor", "author", "*").get(0)).getValue(), (CharSequence)"Donald, SmithImported"));
        this.eperson = this.ePersonService.findByEmail(this.context, this.eperson.getEmail());
        TestCase.assertEquals((Object)importedItem.getSubmitter(), (Object)this.eperson);
        this.context.turnOffAuthorisationSystem();
        this.itemService.delete(this.context, (DSpaceObject)((Item)this.itemService.find(this.context, importedItem.getID())));
        this.context.restoreAuthSystemState();
    }

    @Test
    public void metadataImportIntoCollectionWithEntityTypeWithTemplateEnabledTest() throws Exception {
        String[] csv = new String[]{"id,collection,dc.title,dc.contributor.author", "+," + this.publicationCollection.getHandle() + ",\"Test Import 1\",\"Donald, SmithImported\""};
        this.performImportScript(csv, true);
        Item importedItem = this.findItemByName("Test Import 1");
        TestCase.assertTrue((boolean)StringUtils.equals((CharSequence)((MetadataValue)this.itemService.getMetadata((DSpaceObject)importedItem, "dc", "contributor", "author", "*").get(0)).getValue(), (CharSequence)"Donald, SmithImported"));
        TestCase.assertTrue((boolean)StringUtils.equals((CharSequence)((MetadataValue)this.itemService.getMetadata((DSpaceObject)importedItem, "dspace", "entity", "type", "*").get(0)).getValue(), (CharSequence)"Publication"));
        this.eperson = this.ePersonService.findByEmail(this.context, this.eperson.getEmail());
        TestCase.assertEquals((Object)importedItem.getSubmitter(), (Object)this.eperson);
        this.context.turnOffAuthorisationSystem();
        this.itemService.delete(this.context, (DSpaceObject)((Item)this.itemService.find(this.context, importedItem.getID())));
        this.context.restoreAuthSystemState();
    }

    @Test
    public void metadataImportIntoCollectionWithEntityTypeWithTemplateDisabledTest() throws Exception {
        String[] csv = new String[]{"id,collection,dc.title,dc.contributor.author", "+," + this.publicationCollection.getHandle() + ",\"Test Import 1\",\"Donald, SmithImported\""};
        this.performImportScript(csv, false);
        Item importedItem = this.findItemByName("Test Import 1");
        TestCase.assertTrue((boolean)StringUtils.equals((CharSequence)((MetadataValue)this.itemService.getMetadata((DSpaceObject)importedItem, "dc", "contributor", "author", "*").get(0)).getValue(), (CharSequence)"Donald, SmithImported"));
        TestCase.assertEquals((int)0, (int)this.itemService.getMetadata((DSpaceObject)importedItem, "dspace", "entity", "type", "*").size());
        this.eperson = this.ePersonService.findByEmail(this.context, this.eperson.getEmail());
        TestCase.assertEquals((Object)importedItem.getSubmitter(), (Object)this.eperson);
        this.context.turnOffAuthorisationSystem();
        this.itemService.delete(this.context, (DSpaceObject)((Item)this.itemService.find(this.context, importedItem.getID())));
        this.context.restoreAuthSystemState();
    }

    @Test(expected=ParseException.class)
    public void metadataImportWithoutEPersonParameterTest() throws IllegalAccessException, InstantiationException, ParseException {
        String fileLocation = new File(testProps.get("test.importcsv").toString()).getAbsolutePath();
        String[] args = new String[]{"metadata-import", "-f", fileLocation, "-s"};
        TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
        ScriptService scriptService = ScriptServiceFactory.getInstance().getScriptService();
        ScriptConfiguration scriptConfiguration = scriptService.getScriptConfiguration(args[0]);
        DSpaceRunnable script = null;
        if (scriptConfiguration != null) {
            script = scriptService.createDSpaceRunnableForScriptConfiguration(scriptConfiguration);
        }
        if (script != null) {
            script.initialize(args, (DSpaceRunnableHandler)testDSpaceRunnableHandler, null);
            script.run();
        }
    }

    @Test
    public void relationshipMetadataImportTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.publicationCollection).withTitle("Publication1").build();
        EntityType publication = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Publication").build();
        EntityType person = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Person").build();
        RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, publication, person, "isAuthorOfPublication", "isPublicationOfAuthor", 0, 10, 0, 10);
        this.context.restoreAuthSystemState();
        String[] csv = new String[]{"id,collection,dc.title,relation.isPublicationOfAuthor,dspace.entity.type", "+," + this.personCollection.getHandle() + ",\"Test Import 1\"," + item.getID() + ",Person"};
        this.performImportScript(csv);
        Item importedItem = this.findItemByName("Test Import 1");
        TestCase.assertEquals((int)1, (int)this.relationshipService.findByItem(this.context, importedItem).size());
        this.context.turnOffAuthorisationSystem();
        this.itemService.delete(this.context, (DSpaceObject)((Item)this.itemService.find(this.context, importedItem.getID())));
        this.context.restoreAuthSystemState();
    }

    @Test
    public void relationshipMetadataImporAlreadyExistingItemTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item personItem = ItemBuilder.createItem(this.context, this.personCollection).withTitle("Person1").build();
        List relationshipList = this.relationshipService.findByItem(this.context, personItem);
        TestCase.assertEquals((int)0, (int)relationshipList.size());
        Item publicationItem = ItemBuilder.createItem(this.context, this.publicationCollection).withTitle("Publication1").build();
        EntityType publication = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Publication").build();
        EntityType person = EntityTypeBuilder.createEntityTypeBuilder(this.context, "Person").build();
        RelationshipTypeBuilder.createRelationshipTypeBuilder(this.context, publication, person, "isAuthorOfPublication", "isPublicationOfAuthor", 0, 10, 0, 10);
        this.context.restoreAuthSystemState();
        String[] csv = new String[]{"id,collection,relation.isPublicationOfAuthor", personItem.getID() + "," + this.publicationCollection.getHandle() + "," + publicationItem.getID()};
        this.performImportScript(csv);
        Item importedItem = this.findItemByName("Person1");
        TestCase.assertEquals((int)1, (int)this.relationshipService.findByItem(this.context, importedItem).size());
    }

    @Test
    public void personMetadataImportTest() throws Exception {
        String[] csv = new String[]{"id,collection,dc.title,person.birthDate", "+," + this.publicationCollection.getHandle() + ",\"Test Import 2\",2000"};
        this.performImportScript(csv);
        Item importedItem = this.findItemByName("Test Import 2");
        TestCase.assertTrue((boolean)StringUtils.equals((CharSequence)((MetadataValue)this.itemService.getMetadata((DSpaceObject)importedItem, "person", "birthDate", null, "*").get(0)).getValue(), (CharSequence)"2000"));
        this.context.turnOffAuthorisationSystem();
        this.itemService.delete(this.context, (DSpaceObject)importedItem);
        this.context.restoreAuthSystemState();
    }

    @Test
    public void metadataImportRemovingValueTest() throws Exception {
        this.context.turnOffAuthorisationSystem();
        Item item = ItemBuilder.createItem(this.context, this.personCollection).withAuthor("TestAuthorToRemove").withTitle("title").build();
        this.context.restoreAuthSystemState();
        TestCase.assertTrue((boolean)StringUtils.equals((CharSequence)((MetadataValue)this.itemService.getMetadata((DSpaceObject)item, "dc", "contributor", "author", "*").get(0)).getValue(), (CharSequence)"TestAuthorToRemove"));
        String[] csv = new String[]{"id,collection,dc.title,dc.contributor.author[*]", item.getID().toString() + "," + this.personCollection.getHandle() + "," + item.getName() + ","};
        this.performImportScript(csv);
        item = this.findItemByName("title");
        TestCase.assertEquals((int)0, (int)this.itemService.getMetadata((DSpaceObject)item, "dc", "contributor", "author", "*").size());
    }

    private Item findItemByName(String name) throws SQLException {
        Item importedItem = null;
        List allItems = IteratorUtils.toList((Iterator)this.itemService.findAll(this.context));
        for (Item item : allItems) {
            if (!item.getName().equals(name)) continue;
            importedItem = item;
        }
        return importedItem;
    }

    public void performImportScript(String[] csv) throws Exception {
        this.performImportScript(csv, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performImportScript(String[] csv, boolean useTemplate) throws Exception {
        File csvFile = File.createTempFile("dspace-test-import", "csv");
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(csvFile), "UTF-8"));
        for (String csvLine : csv) {
            out.write(csvLine + "\n");
        }
        out.flush();
        out.close();
        String fileLocation = csvFile.getAbsolutePath();
        try {
            Object[] args = new String[]{"metadata-import", "-f", fileLocation, "-e", this.eperson.getEmail(), "-s"};
            if (useTemplate) {
                args = (String[])ArrayUtils.add((Object[])args, (Object)"-t");
            }
            TestDSpaceRunnableHandler testDSpaceRunnableHandler = new TestDSpaceRunnableHandler();
            ScriptLauncher.handleScript((String[])args, (Document)ScriptLauncher.getConfig((DSpaceKernelImpl)kernelImpl), (DSpaceRunnableHandler)testDSpaceRunnableHandler, (DSpaceKernelImpl)kernelImpl);
        }
        finally {
            csvFile.delete();
        }
    }
}

