/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.matcher;

import org.dspace.content.Item;
import org.dspace.orcid.OrcidOperation;
import org.dspace.orcid.OrcidQueue;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public class OrcidQueueMatcher
extends TypeSafeMatcher<OrcidQueue> {
    private final Matcher<Item> profileItemMatcher;
    private final Matcher<Item> entityMatcher;
    private final Matcher<String> recordTypeMatcher;
    private final Matcher<String> putCodeMatcher;
    private final Matcher<String> descriptionMatcher;
    private final Matcher<String> metadataMatcher;
    private final Matcher<OrcidOperation> operationMatcher;
    private final Matcher<Integer> attemptsMatcher;

    private OrcidQueueMatcher(Matcher<Item> profileItemMatcher, Matcher<Item> entityMatcher, Matcher<String> recordTypeMatcher, Matcher<String> putCodeMatcher, Matcher<String> metadataMatcher, Matcher<String> descriptionMatcher, Matcher<OrcidOperation> operationMatcher, Matcher<Integer> attemptsMatcher) {
        this.profileItemMatcher = profileItemMatcher;
        this.entityMatcher = entityMatcher;
        this.recordTypeMatcher = recordTypeMatcher;
        this.putCodeMatcher = putCodeMatcher;
        this.metadataMatcher = metadataMatcher;
        this.descriptionMatcher = descriptionMatcher;
        this.operationMatcher = operationMatcher;
        this.attemptsMatcher = attemptsMatcher;
    }

    public static OrcidQueueMatcher matches(Item profileItem, Item entity, String recordType, OrcidOperation operation) {
        return new OrcidQueueMatcher((Matcher<Item>)Matchers.is((Object)profileItem), (Matcher<Item>)Matchers.is((Object)entity), (Matcher<String>)Matchers.is((Object)recordType), OrcidQueueMatcher.anything(), OrcidQueueMatcher.anything(), OrcidQueueMatcher.anything(), (Matcher<OrcidOperation>)Matchers.is((Object)operation), OrcidQueueMatcher.anything());
    }

    public static OrcidQueueMatcher matches(Item profileItem, Item entity, String recordType, OrcidOperation operation, int attempts) {
        return new OrcidQueueMatcher((Matcher<Item>)Matchers.is((Object)profileItem), (Matcher<Item>)Matchers.is((Object)entity), (Matcher<String>)Matchers.is((Object)recordType), OrcidQueueMatcher.anything(), OrcidQueueMatcher.anything(), OrcidQueueMatcher.anything(), (Matcher<OrcidOperation>)Matchers.is((Object)operation), (Matcher<Integer>)Matchers.is((Object)attempts));
    }

    public static OrcidQueueMatcher matches(Item profileItem, Item entity, String recordType, String putCode, OrcidOperation operation) {
        return new OrcidQueueMatcher((Matcher<Item>)Matchers.is((Object)profileItem), (Matcher<Item>)Matchers.is((Object)entity), (Matcher<String>)Matchers.is((Object)recordType), (Matcher<String>)Matchers.is((Object)putCode), OrcidQueueMatcher.anything(), OrcidQueueMatcher.anything(), (Matcher<OrcidOperation>)Matchers.is((Object)operation), OrcidQueueMatcher.anything());
    }

    public static OrcidQueueMatcher matches(Item profileItem, Item entity, String recordType, String putCode, String metadata, String description, OrcidOperation operation) {
        return new OrcidQueueMatcher((Matcher<Item>)Matchers.is((Object)profileItem), (Matcher<Item>)Matchers.is((Object)entity), (Matcher<String>)Matchers.is((Object)recordType), (Matcher<String>)Matchers.is((Object)putCode), (Matcher<String>)Matchers.is((Object)metadata), (Matcher<String>)Matchers.is((Object)description), (Matcher<OrcidOperation>)Matchers.is((Object)operation), OrcidQueueMatcher.anything());
    }

    public static OrcidQueueMatcher matches(Item item, String recordType, String putCode, String metadata, String description, OrcidOperation operation) {
        return new OrcidQueueMatcher((Matcher<Item>)Matchers.is((Object)item), (Matcher<Item>)Matchers.is((Object)item), (Matcher<String>)Matchers.is((Object)recordType), (Matcher<String>)Matchers.is((Object)putCode), (Matcher<String>)Matchers.is((Object)metadata), (Matcher<String>)Matchers.is((Object)description), (Matcher<OrcidOperation>)Matchers.is((Object)operation), OrcidQueueMatcher.anything());
    }

    public static OrcidQueueMatcher matches(Item profileItem, Item entity, String recordType, String putCode, Matcher<String> metadata, String description, OrcidOperation operation) {
        return new OrcidQueueMatcher((Matcher<Item>)Matchers.is((Object)profileItem), (Matcher<Item>)Matchers.is((Object)entity), (Matcher<String>)Matchers.is((Object)recordType), (Matcher<String>)Matchers.is((Object)putCode), metadata, (Matcher<String>)Matchers.is((Object)description), (Matcher<OrcidOperation>)Matchers.is((Object)operation), OrcidQueueMatcher.anything());
    }

    public void describeTo(Description description) {
        description.appendText("an orcid queue record that with the following attributes:").appendText(" item profileItem ").appendDescriptionOf(this.profileItemMatcher).appendText(", item entity ").appendDescriptionOf(this.entityMatcher).appendText(", record type ").appendDescriptionOf(this.recordTypeMatcher).appendText(", metadata ").appendDescriptionOf(this.metadataMatcher).appendText(", description ").appendDescriptionOf(this.descriptionMatcher).appendText(", operation ").appendDescriptionOf(this.operationMatcher).appendText(", attempts ").appendDescriptionOf(this.attemptsMatcher).appendText(" and put code ").appendDescriptionOf(this.putCodeMatcher);
    }

    protected boolean matchesSafely(OrcidQueue item) {
        return this.profileItemMatcher.matches((Object)item.getProfileItem()) && this.entityMatcher.matches((Object)item.getEntity()) && this.recordTypeMatcher.matches((Object)item.getRecordType()) && this.metadataMatcher.matches((Object)item.getMetadata()) && this.putCodeMatcher.matches((Object)item.getPutCode()) && this.descriptionMatcher.matches((Object)item.getDescription()) && this.operationMatcher.matches((Object)item.getOperation()) && this.attemptsMatcher.matches((Object)item.getAttempts());
    }

    private static <T> Matcher<T> anything() {
        return new BaseMatcher<T>(){

            public boolean matches(Object item) {
                return true;
            }

            public void describeTo(Description description) {
            }
        };
    }
}

