/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.requestitem;

import java.util.List;
import org.dspace.app.requestitem.CombiningRequestItemStrategy;
import org.dspace.app.requestitem.RequestItemAuthor;
import org.dspace.app.requestitem.RequestItemAuthorExtractor;
import org.dspace.app.requestitem.RequestItemHelpdeskStrategy;
import org.dspace.app.requestitem.RequestItemMetadataStrategy;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.Test;
import org.mockito.Mockito;

public class CombiningRequestItemStrategyTest {
    @Test
    public void testGetRequestItemAuthor() throws Exception {
        System.out.println("getRequestItemAuthor");
        Context context = null;
        Item item = (Item)Mockito.mock(Item.class);
        RequestItemAuthor author1 = new RequestItemAuthor("Pat Paulsen", "ppaulsen@example.com");
        RequestItemAuthor author2 = new RequestItemAuthor("Alfred E. Neuman", "aeneuman@example.com");
        RequestItemAuthor author3 = new RequestItemAuthor("Alias Undercover", "aundercover@example.com");
        RequestItemAuthorExtractor strategy1 = (RequestItemAuthorExtractor)Mockito.mock(RequestItemHelpdeskStrategy.class);
        Mockito.when((Object)strategy1.getRequestItemAuthor(context, item)).thenReturn(List.of(author1));
        RequestItemAuthorExtractor strategy2 = (RequestItemAuthorExtractor)Mockito.mock(RequestItemMetadataStrategy.class);
        Mockito.when((Object)strategy2.getRequestItemAuthor(context, item)).thenReturn(List.of(author2, author3));
        List<RequestItemAuthorExtractor> strategies = List.of(strategy1, strategy2);
        CombiningRequestItemStrategy instance = new CombiningRequestItemStrategy(strategies);
        List result = instance.getRequestItemAuthor(context, item);
        MatcherAssert.assertThat((Object)result, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new RequestItemAuthor[]{author1, author2, author3}));
    }
}

