/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.sql.SQLException;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.builder.AbstractBuilder;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.MutablePeriod;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormat;

public abstract class AbstractDSpaceObjectBuilder<T extends DSpaceObject>
extends AbstractBuilder<T, DSpaceObjectService> {
    private static final Logger log = LogManager.getLogger(AbstractDSpaceObjectBuilder.class);

    protected AbstractDSpaceObjectBuilder(Context context) {
        super(context);
        this.context = context;
    }

    @Override
    public abstract void cleanup() throws Exception;

    @Override
    protected abstract DSpaceObjectService<T> getService();

    @Override
    protected <B> B handleException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return null;
    }

    protected <B extends AbstractDSpaceObjectBuilder<T>> B addMetadataValue(T dso, String schema, String element, String qualifier, String value) {
        try {
            this.getService().addMetadata(this.context, dso, schema, element, qualifier, null, value);
        }
        catch (Exception e) {
            return (B)((AbstractDSpaceObjectBuilder)this.handleException(e));
        }
        return (B)this;
    }

    protected <B extends AbstractDSpaceObjectBuilder<T>> B addMetadataValue(T dso, String schema, String element, String qualifier, String language, String value) {
        try {
            this.getService().addMetadata(this.context, dso, schema, element, qualifier, language, value);
        }
        catch (Exception e) {
            return (B)((AbstractDSpaceObjectBuilder)this.handleException(e));
        }
        return (B)this;
    }

    protected <B extends AbstractDSpaceObjectBuilder<T>> B addMetadataValue(T dso, String schema, String element, String qualifier, String language, String value, String authority, int confidence) {
        try {
            this.getService().addMetadata(this.context, dso, schema, element, qualifier, language, value, authority, confidence);
        }
        catch (Exception e) {
            return (B)((AbstractDSpaceObjectBuilder)this.handleException(e));
        }
        return (B)this;
    }

    protected <B extends AbstractDSpaceObjectBuilder<T>> B setMetadataSingleValue(T dso, String schema, String element, String qualifier, String value) {
        try {
            this.getService().setMetadataSingleValue(this.context, dso, schema, element, qualifier, "*", value);
        }
        catch (Exception e) {
            return (B)((AbstractDSpaceObjectBuilder)this.handleException(e));
        }
        return (B)this;
    }

    protected <B extends AbstractDSpaceObjectBuilder<T>> B setEmbargo(String embargoPeriod, DSpaceObject dso) {
        try {
            MutablePeriod period = PeriodFormat.getDefault().parseMutablePeriod(embargoPeriod);
            Date embargoDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).plus((ReadablePeriod)period).toDate();
            return this.setOnlyReadPermission(dso, groupService.findByName(this.context, "Anonymous"), embargoDate);
        }
        catch (Exception e) {
            return (B)((AbstractDSpaceObjectBuilder)this.handleException(e));
        }
    }

    protected <B extends AbstractDSpaceObjectBuilder<T>> B setOnlyReadPermission(DSpaceObject dso, Group group, Date startDate) {
        try {
            authorizeService.removeAllPolicies(this.context, dso);
            ResourcePolicy rp = authorizeService.createOrModifyPolicy(null, this.context, null, group, null, startDate, 0, "Integration Test", dso);
            if (rp != null) {
                resourcePolicyService.update(this.context, (Object)rp);
            }
        }
        catch (Exception e) {
            return (B)((AbstractDSpaceObjectBuilder)this.handleException(e));
        }
        return (B)this;
    }

    protected <B extends AbstractDSpaceObjectBuilder<T>> B setAdminPermission(DSpaceObject dso, EPerson eperson, Date startDate) {
        try {
            ResourcePolicy rp = authorizeService.createOrModifyPolicy(null, this.context, null, null, eperson, startDate, 11, "Integration Test", dso);
            if (rp != null) {
                resourcePolicyService.update(this.context, (Object)rp);
            }
        }
        catch (Exception e) {
            return (B)((AbstractDSpaceObjectBuilder)this.handleException(e));
        }
        return (B)this;
    }

    protected <B extends AbstractDSpaceObjectBuilder<T>> B setRemovePermissionForEperson(DSpaceObject dso, EPerson eperson, Date startDate) {
        try {
            ResourcePolicy rp = authorizeService.createOrModifyPolicy(null, this.context, null, null, eperson, startDate, 4, "Integration Test", dso);
            if (rp != null) {
                log.info("Updating resource policy with REMOVE for eperson: " + eperson.getEmail());
                resourcePolicyService.update(this.context, (Object)rp);
            }
        }
        catch (Exception e) {
            return (B)((AbstractDSpaceObjectBuilder)this.handleException(e));
        }
        return (B)this;
    }

    protected <B extends AbstractDSpaceObjectBuilder<T>> B setAddPermissionForEperson(DSpaceObject dso, EPerson eperson, Date startDate) {
        try {
            ResourcePolicy rp = authorizeService.createOrModifyPolicy(null, this.context, null, null, eperson, startDate, 3, "Integration Test", dso);
            if (rp != null) {
                log.info("Updating resource policy with ADD for eperson: " + eperson.getEmail());
                resourcePolicyService.update(this.context, (Object)rp);
            }
        }
        catch (Exception e) {
            return (B)((AbstractDSpaceObjectBuilder)this.handleException(e));
        }
        return (B)this;
    }

    protected <B extends AbstractDSpaceObjectBuilder<T>> B setWritePermissionForEperson(DSpaceObject dso, EPerson eperson, Date startDate) {
        try {
            ResourcePolicy rp = authorizeService.createOrModifyPolicy(null, this.context, null, null, eperson, startDate, 1, "Integration Test", dso);
            if (rp != null) {
                log.info("Updating resource policy with WRITE for eperson: " + eperson.getEmail());
                resourcePolicyService.update(this.context, (Object)rp);
            }
        }
        catch (Exception e) {
            return (B)((AbstractDSpaceObjectBuilder)this.handleException(e));
        }
        return (B)this;
    }

    @Override
    public abstract T build() throws SQLException, AuthorizeException;

    @Override
    public void delete(Context c, T dso) throws Exception {
        if (dso != null) {
            this.getService().delete(c, dso);
        }
        c.complete();
        indexingService.commit();
    }
}

