/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.io.IOException;
import java.sql.SQLException;
import java.util.UUID;
import org.dspace.authorize.AuthorizeException;
import org.dspace.builder.AbstractDSpaceObjectBuilder;
import org.dspace.content.DSpaceObject;
import org.dspace.content.service.DSpaceObjectService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;

public class GroupBuilder
extends AbstractDSpaceObjectBuilder<Group> {
    private Group group;

    protected GroupBuilder(Context context) {
        super(context);
    }

    @Override
    public void cleanup() throws Exception {
        try (Context c = new Context();){
            c.setDispatcher("noindex");
            c.turnOffAuthorisationSystem();
            this.group = (Group)c.reloadEntity((ReloadableEntity)this.group);
            if (this.group != null) {
                this.delete(c, this.group);
                c.complete();
            }
        }
    }

    public static GroupBuilder createGroup(Context context) {
        GroupBuilder builder = new GroupBuilder(context);
        return builder.create(context);
    }

    private GroupBuilder create(Context context) {
        this.context = context;
        try {
            this.group = groupService.create(context);
        }
        catch (Exception e) {
            return (GroupBuilder)this.handleException(e);
        }
        return this;
    }

    @Override
    protected DSpaceObjectService<Group> getService() {
        return groupService;
    }

    @Override
    public Group build() {
        try {
            groupService.update(this.context, (DSpaceObject)this.group);
        }
        catch (Exception e) {
            return (Group)this.handleException(e);
        }
        return this.group;
    }

    public GroupBuilder withName(String groupName) {
        try {
            groupService.setName(this.group, groupName);
        }
        catch (Exception e) {
            return (GroupBuilder)this.handleException(e);
        }
        return this;
    }

    public GroupBuilder withParent(Group parent) {
        try {
            groupService.addMember(this.context, parent, this.group);
        }
        catch (Exception e) {
            return (GroupBuilder)this.handleException(e);
        }
        return this;
    }

    public GroupBuilder addMember(EPerson eperson) {
        try {
            groupService.addMember(this.context, this.group, eperson);
        }
        catch (Exception e) {
            return (GroupBuilder)this.handleException(e);
        }
        return this;
    }

    public static void deleteGroup(UUID uuid) throws SQLException, IOException {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            Group group = (Group)groupService.find(c, uuid);
            if (group != null) {
                try {
                    groupService.delete(c, (DSpaceObject)group);
                }
                catch (AuthorizeException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            c.complete();
        }
    }
}

