/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.builder;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dspace.builder.AbstractBuilder;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.orcid.OrcidHistory;
import org.dspace.orcid.OrcidOperation;
import org.dspace.orcid.service.OrcidHistoryService;

public class OrcidHistoryBuilder
extends AbstractBuilder<OrcidHistory, OrcidHistoryService> {
    private static final Logger log = Logger.getLogger(OrcidHistoryBuilder.class);
    private OrcidHistory orcidHistory;

    protected OrcidHistoryBuilder(Context context) {
        super(context);
    }

    @Override
    protected OrcidHistoryService getService() {
        return orcidHistoryService;
    }

    @Override
    public void cleanup() throws Exception {
        this.delete(this.orcidHistory);
    }

    public static OrcidHistoryBuilder createOrcidHistory(Context context, Item profileItem, Item entity) {
        OrcidHistoryBuilder builder = new OrcidHistoryBuilder(context);
        return builder.create(context, profileItem, entity);
    }

    private OrcidHistoryBuilder create(Context context, Item profileItem, Item entity) {
        try {
            this.context = context;
            this.orcidHistory = this.getService().create(context, profileItem, entity);
        }
        catch (Exception e) {
            log.error((Object)"Error in OrcidHistoryBuilder.create(..), error: ", (Throwable)e);
        }
        return this;
    }

    @Override
    public OrcidHistory build() throws SQLException {
        try {
            this.getService().update(this.context, this.orcidHistory);
            this.context.dispatchEvents();
            indexingService.commit();
        }
        catch (Exception e) {
            log.error((Object)"Error in OrcidHistoryBuilder.build(), error: ", (Throwable)e);
        }
        return this.orcidHistory;
    }

    @Override
    public void delete(Context c, OrcidHistory orcidHistory) throws Exception {
        if (orcidHistory != null) {
            this.getService().delete(c, orcidHistory);
        }
    }

    public static void deleteOrcidHistory(Integer id) throws SQLException, IOException {
        if (id == null) {
            return;
        }
        try (Context c = new Context();){
            OrcidHistory orcidHistory = orcidHistoryService.find(c, id.intValue());
            if (orcidHistory != null) {
                orcidHistoryService.delete(c, orcidHistory);
            }
            c.complete();
        }
    }

    public void delete(OrcidHistory orcidHistory) throws Exception {
        try (Context c = new Context();){
            c.turnOffAuthorisationSystem();
            OrcidHistory attachedTab = (OrcidHistory)c.reloadEntity((ReloadableEntity)orcidHistory);
            if (attachedTab != null) {
                this.getService().delete(c, attachedTab);
            }
            c.complete();
        }
        indexingService.commit();
    }

    public OrcidHistoryBuilder withResponseMessage(String responseMessage) throws SQLException {
        this.orcidHistory.setResponseMessage(responseMessage);
        return this;
    }

    public OrcidHistoryBuilder withPutCode(String putCode) throws SQLException {
        this.orcidHistory.setPutCode(putCode);
        return this;
    }

    public OrcidHistoryBuilder withStatus(Integer status) throws SQLException {
        this.orcidHistory.setStatus(status);
        return this;
    }

    public OrcidHistoryBuilder withMetadata(String metadata) throws SQLException {
        this.orcidHistory.setMetadata(metadata);
        return this;
    }

    public OrcidHistoryBuilder withRecordType(String recordType) throws SQLException {
        this.orcidHistory.setRecordType(recordType);
        return this;
    }

    public OrcidHistoryBuilder withOperation(OrcidOperation operation) throws SQLException {
        this.orcidHistory.setOperation(operation);
        return this;
    }

    public OrcidHistoryBuilder withDescription(String description) throws SQLException {
        this.orcidHistory.setDescription(description);
        return this;
    }

    public OrcidHistoryBuilder withTimestamp(Date timestamp) {
        this.orcidHistory.setTimestamp(timestamp);
        return this;
    }
}

